/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyFlash;
import org.jfree.chart.JFreeChart;

public class ConstantDutyPressureFlash
extends ConstantDutyFlash {
    private static final long serialVersionUID = 1000L;

    public ConstantDutyPressureFlash(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(0);
        }
        int iterations = 0;
        double deriv = 0.0;
        double funk = 0.0;
        double dkidp = 0.0;
        double dyidp = 0.0;
        double dxidp = 0.0;
        double Pold = 0.0;
        do {
            int i;
            this.system.init(2);
            ++iterations;
            for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                this.system.getPhases()[0].getComponent(i).setK(this.system.getPhases()[1].getComponent(i).getFugacityCoefficient() / this.system.getPhases()[0].getComponent(i).getFugacityCoefficient());
                this.system.getPhases()[1].getComponent(i).setK(this.system.getPhases()[0].getComponent(i).getK());
            }
            this.system.calc_x_y_nonorm();
            funk = 0.0;
            deriv = 0.0;
            for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                dkidp = (this.system.getPhases()[1].getComponent(i).getdfugdp() - this.system.getPhases()[0].getComponent(i).getdfugdp()) * this.system.getPhases()[1].getComponent(i).getK();
                dxidp = -this.system.getPhases()[1].getComponent(i).getz() * this.system.getBeta() * dkidp / Math.pow(1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhases()[1].getComponent(i).getK(), 2.0);
                dyidp = dkidp * this.system.getPhases()[1].getComponent(i).getx() + this.system.getPhases()[1].getComponent(i).getK() * dxidp;
                funk += this.system.getPhases()[0].getComponent(i).getx() - this.system.getPhases()[1].getComponent(i).getx();
                deriv += dyidp - dxidp;
            }
            Pold = this.system.getPressure();
            double pres = Math.abs(Pold - 0.5 * funk / deriv);
            this.system.setPressure(pres);
        } while (Math.abs((this.system.getPressure() - Pold) / this.system.getPressure()) > 1.0E-10 && iterations < 300 || iterations < 3);
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.system;
    }
}

