/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HydrateFormationTemperatureFlash
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(HydrateFormationTemperatureFlash.class);

    public HydrateFormationTemperatureFlash(SystemInterface system) {
        super(system);
    }

    public void stop() {
        this.system = null;
    }

    @Override
    public void run() {
        double olfFug = 0.0;
        double temp = 0.0;
        double oldTemp = 0.0;
        double oldDiff = 0.0;
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        this.system.getPhase(4).getComponent("water").setx(1.0);
        int iter = 0;
        double diff = 0.0;
        this.system.setTemperature(this.system.getTemperature() + 1.0E-4);
        do {
            ++iter;
            olfFug = this.system.getPhase(4).getFugacity("water");
            ops.TPflash();
            this.setFug();
            this.system.getPhase(4).getComponent("water").fugcoef(this.system.getPhase(4));
            this.system.getPhase(4).getComponent("water").setx(1.0);
            oldDiff = diff;
            diff = 1.0 - this.system.getPhase(4).getFugacity("water") / this.system.getPhase(0).getFugacity("water");
            oldTemp = temp;
            temp = this.system.getTemperature();
            double dDiffdT = (diff - oldDiff) / (temp - oldTemp);
            if (iter < 2) {
                this.system.setTemperature(this.system.getTemperature() + 0.1);
            } else {
                double dT;
                double d = dT = Math.abs(diff / dDiffdT) > 10.0 ? Math.signum(diff / dDiffdT) * 10.0 : diff / dDiffdT;
                if (Double.isNaN(dT)) {
                    dT = 0.1;
                }
                this.system.setTemperature(this.system.getTemperature() - dT);
            }
            if (iter > 2 && Math.abs(diff) > Math.abs(oldDiff)) {
                this.system.setTemperature((oldTemp + this.system.getTemperature()) / 2.0);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Math.abs((olfFug - this.system.getPhase(4).getFugacity("water")) / olfFug) > 1.0E-6 && iter < 100 || iter < 3);
    }

    public void run2() {
        double olfFug = 0.0;
        double oldTemp = 0.0;
        double oldOldTemp = 0.0;
        double oldDiff = 0.0;
        double oldOldDiff = 0.0;
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        this.system.getPhase(4).getComponent("water").setx(1.0);
        int iter = 0;
        do {
            ++iter;
            olfFug = this.system.getPhase(4).getFugacity("water");
            ops.TPflash();
            this.setFug();
            this.system.getPhase(4).getComponent("water").fugcoef(this.system.getPhase(4));
            this.system.getPhase(4).getComponent("water").setx(1.0);
            if (iter % 4 == 0) {
                change = -oldDiff / ((oldDiff - oldOldDiff) / (oldTemp - oldOldTemp));
                if (Math.abs(change) > 5.0) {
                    change = Math.abs(change) / change * 5.0;
                }
                this.system.setTemperature(this.system.getTemperature() + change);
            } else {
                change = 1.0 - this.system.getPhase(4).getFugacity("water") / this.system.getPhase(0).getFugacity("water");
                if (Math.abs(change) > 5.0) {
                    change = Math.abs(change) / change * 5.0;
                }
                this.system.setTemperature(this.system.getTemperature() + change);
            }
            double diff = 1.0 - this.system.getPhase(4).getFugacity("water") / this.system.getPhase(0).getFugacity("water");
            oldOldTemp = oldTemp;
            oldTemp = this.system.getTemperature();
            oldOldDiff = oldDiff;
            oldDiff = diff;
        } while (Math.abs((olfFug - this.system.getPhase(4).getFugacity("water")) / olfFug) > 1.0E-6 && iter < 100 || iter < 3);
    }

    public void setFug() {
        this.system.getPhase(4).getComponent("water").setx(1.0);
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.system.getPhase(0).getNumberOfComponents(); ++j) {
                if (this.system.getPhase(4).getComponent(j).isHydrateFormer() || this.system.getPhase(4).getComponent(j).getName().equals("water")) {
                    ((ComponentHydrate)this.system.getPhase(4).getComponent(i)).setRefFug(j, this.system.getPhase(0).getFugacity(j));
                    continue;
                }
                ((ComponentHydrate)this.system.getPhase(4).getComponent(i)).setRefFug(j, 0.0);
            }
        }
        this.system.getPhase(4).getComponent("water").setx(1.0);
        this.system.getPhase(4).init();
        this.system.getPhase(4).getComponent("water").fugcoef(this.system.getPhase(4));
    }

    @Override
    public void printToFile(String name) {
    }
}

