/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HydrateInhibitorwtFlash
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(HydrateInhibitorwtFlash.class);
    double wtfrac = 0.5;
    String inhibitor = "MEG";

    public HydrateInhibitorwtFlash(SystemInterface system, String inhibitor, double wtfr) {
        super(system);
        this.wtfrac = wtfr;
        this.inhibitor = inhibitor;
    }

    public void stop() {
        this.system = null;
    }

    @Override
    public void run() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        int iter = 0;
        double error = 1.0;
        double oldError = 1.0;
        double oldC = this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles();
        double derrordC = 1.0;
        do {
            ++iter;
            try {
                derrordC = (error - oldError) / (this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles() - oldC);
                oldError = error;
                oldC = this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles();
                if (iter < 4) {
                    this.system.addComponent(this.inhibitor, error * 0.01);
                } else {
                    double newC = -error / derrordC;
                    double correction = newC * 0.5;
                    this.system.addComponent(this.inhibitor, correction);
                }
                this.system.init(0);
                this.system.init(1);
                ops.TPflash();
                double wtp = 0.0;
                if (this.system.hasPhaseType(PhaseType.AQUEOUS)) {
                    wtp = this.system.getPhase(PhaseType.AQUEOUS).getComponent(this.inhibitor).getx() * this.system.getPhase(PhaseType.AQUEOUS).getComponent(this.inhibitor).getMolarMass() / (this.system.getPhase(PhaseType.AQUEOUS).getComponent(this.inhibitor).getx() * this.system.getPhase(PhaseType.AQUEOUS).getComponent(this.inhibitor).getMolarMass() + this.system.getPhase(PhaseType.AQUEOUS).getComponent("water").getx() * this.system.getPhase(PhaseType.AQUEOUS).getComponent("water").getMolarMass());
                } else {
                    this.system.addComponent(this.inhibitor, this.system.getTotalNumberOfMoles());
                    ops.TPflash();
                    wtp = this.system.getPhase(PhaseType.AQUEOUS).getComponent(this.inhibitor).getx() * this.system.getPhase(PhaseType.AQUEOUS).getComponent(this.inhibitor).getMolarMass() / (this.system.getPhase(PhaseType.AQUEOUS).getComponent(this.inhibitor).getx() * this.system.getPhase(PhaseType.AQUEOUS).getComponent(this.inhibitor).getMolarMass() + this.system.getPhase(PhaseType.AQUEOUS).getComponent("water").getx() * this.system.getPhase(PhaseType.AQUEOUS).getComponent("water").getMolarMass());
                }
                error = -(wtp - this.wtfrac);
                logger.info("error " + error);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } while (Math.abs(error) > 1.0E-5 && iter < 100 || iter < 3);
    }

    @Override
    public void printToFile(String name) {
    }
}

