/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.database;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import neqsim.util.util.FileSystemSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AspenIP21Database
implements FileSystemSettings,
Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(AspenIP21Database.class);
    protected Connection databaseConnection = null;
    private static String dataBaseType = "Karsto";
    private Statement statement = null;

    public AspenIP21Database() {
        try {
            if (dataBaseType.equals("Karsto")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception ex) {
            logger.error("error in Online Karsto ", (Throwable)ex);
            logger.error("The database must be registered on the local DBMS to work.");
        }
        try {
            this.databaseConnection = this.openConnection("Karsto");
            this.setStatement(this.databaseConnection.createStatement());
        }
        catch (Exception ex) {
            logger.error("SQLException ", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection openConnection(String database) throws SQLException, ClassNotFoundException {
        InitialContext ctx = null;
        try {
            Connection connection = DriverManager.getConnection(".....");
            return connection;
        }
        catch (Exception ex) {
            logger.error("SQLException ", (Throwable)ex);
            logger.error("error in Kaarsto DB ", (Throwable)ex);
            logger.error("The Kaarsto database must be registered on the local DBMS to work.");
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public ResultSet getResultSet(String sqlString) {
        return this.getResultSet("Karsto", sqlString);
    }

    public ResultSet getResultSet(String database, String sqlString) {
        try {
            ResultSet result = this.getStatement().executeQuery(sqlString);
            return result;
        }
        catch (Exception ex) {
            logger.error("error in DB ", (Throwable)ex);
            logger.error("The database must be rgistered on the local DBMS to work.");
            return null;
        }
    }

    public Statement getStatement() {
        return this.statement;
    }
}

