/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.database;

import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.exception.NotInitializedException;
import neqsim.util.util.FileSystemSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.jdbc.JdbcSQLSyntaxErrorException;

public class NeqSimDataBase
implements FileSystemSettings,
Serializable,
AutoCloseable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(NeqSimDataBase.class);
    public static String dataBasePath = "";
    private static boolean createTemporaryTables = false;
    private static String username = "remote";
    private static String password = "remote";
    private static String dataBaseType = "H2fromCSV";
    private static String connectionString = "jdbc:h2:mem:neqsimthermodatabase";
    private static boolean h2IsInitialized = false;
    private static boolean h2IsInitalizing = false;
    private Statement statement = null;
    protected Connection databaseConnection = null;

    public NeqSimDataBase() {
        NeqSimDataBase.setDataBaseType(dataBaseType);
        try {
            this.databaseConnection = this.openConnection();
            this.statement = this.databaseConnection.createStatement();
        }
        catch (Exception ex) {
            logger.error("SQLException ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public Connection openConnection() throws SQLException, ClassNotFoundException {
        InitialContext ctx = null;
        DataSource ds = null;
        try {
            if (System.getenv("NEQSIMTHERMODB_CS") != null) {
                Properties properties = new Properties();
                properties.setProperty("user", System.getenv("MYSQL_USER"));
                properties.setProperty("password", System.getenv("MYSQL_PASSWORD"));
                properties.setProperty("useSSL", "false");
                Connection connection = DriverManager.getConnection(System.getenv("NEQSIMTHERMODB_CS"), properties);
                return connection;
            }
            if (dataBaseType.equals("MSAccess")) {
                String dir = "";
                dir = System.getProperty("NeqSim.home") == null ? "c:\\programming\\NeqSimSourceCode\\java\\neqsim" : System.getProperty("NeqSim.home");
                Connection connection = DriverManager.getConnection("jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=" + dir + "\\data\\NeqSimDatabase");
                return connection;
            }
            if (dataBaseType.equals("H2fromCSV") || dataBaseType.equals("H2") || dataBaseType.equals("H2RT")) {
                Connection dir = DriverManager.getConnection(connectionString, "sa", "");
                return dir;
            }
            if (dataBaseType.equals("MSAccessUCanAccess")) {
                Connection dir = DriverManager.getConnection(NeqSimDataBase.getConnectionString());
                return dir;
            }
            if (dataBaseType.equals("mySQL") || dataBaseType.equals("mySQLNTNU") || dataBaseType.equals("Derby")) {
                Connection dir = DriverManager.getConnection(NeqSimDataBase.getConnectionString(), username, password);
                return dir;
            }
            if (dataBaseType.equals("mySQLNeqSimWeb")) {
                ctx = new InitialContext();
                ds = (DataSource)ctx.lookup("java:comp/env/jdbc/NeqsimThermoDatabase");
                Connection dir = ds.getConnection();
                return dir;
            }
            Connection dir = DriverManager.getConnection(NeqSimDataBase.getConnectionString());
            return dir;
        }
        catch (Exception ex) {
            logger.error("error loading NeqSimDataBase... ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public Connection getConnection() {
        return this.databaseConnection;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public boolean execute(String sqlString) {
        try {
            if (this.databaseConnection == null) {
                this.databaseConnection = this.openConnection();
                this.setStatement(this.databaseConnection.createStatement());
            }
            return this.getStatement().execute(sqlString);
        }
        catch (Exception ex) {
            logger.error("error in NeqSimDataBase ", (Throwable)ex);
            logger.error("The database must be registered on the local DBMS to work.");
            throw new RuntimeException(ex);
        }
    }

    public void executeQuery(String sqlString) {
        try {
            if (this.databaseConnection == null) {
                this.databaseConnection = this.openConnection();
                this.setStatement(this.databaseConnection.createStatement());
            }
            this.getStatement().executeQuery(sqlString);
        }
        catch (Exception ex) {
            logger.error("error in NeqSimDataBase ", (Throwable)ex);
            logger.error("The database must be registered on the local DBMS to work.");
            throw new RuntimeException(ex);
        }
    }

    public ResultSet getResultSet(String sqlString) {
        try {
            if (this.databaseConnection == null) {
                this.databaseConnection = this.openConnection();
                this.setStatement(this.databaseConnection.createStatement());
            }
            return this.getStatement().executeQuery(sqlString);
        }
        catch (JdbcSQLSyntaxErrorException ex) {
            if (ex.getMessage().startsWith("Table ") && ex.getMessage().contains(" not found;")) {
                throw new RuntimeException(new NotInitializedException(this, "getResultSet", ex.getMessage()));
            }
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            logger.error("error loading NeqSimbataBase ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.databaseConnection != null) {
            this.databaseConnection.close();
            this.databaseConnection = null;
        }
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
    }

    public static boolean createTemporaryTables() {
        return createTemporaryTables;
    }

    public static void setCreateTemporaryTables(boolean createTemporaryTables) {
        NeqSimDataBase.createTemporaryTables = createTemporaryTables;
    }

    public static String getDataBaseType() {
        return dataBaseType;
    }

    public static void setDataBaseType(String aDataBaseType) {
        NeqSimDataBase.setDataBaseType(aDataBaseType, null);
    }

    public static void setDataBaseType(String aDataBaseType, String connectionString) {
        dataBaseType = aDataBaseType;
        if ("H2fromCSV".equals(dataBaseType) && !h2IsInitialized && !h2IsInitalizing) {
            NeqSimDataBase.initH2DatabaseFromCSVfiles();
        }
        if (connectionString != null) {
            NeqSimDataBase.connectionString = connectionString;
        }
        try {
            if (dataBaseType.equals("MSAccess")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("H2fromCSV") || dataBaseType.equals("H2") || dataBaseType.equals("H2RT")) {
                Class.forName("org.h2.Driver");
            } else if (dataBaseType.equals("MSAccessUCanAccess")) {
                Class.forName("net.ucanaccess.jdbc.UcanaccessDriver");
            } else if (dataBaseType.equals("mySQL")) {
                Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("mySQLNTNU")) {
                Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("Derby")) {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("oracle")) {
                Class.forName("oracle.jdbc.driver.OracleDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("oracleST")) {
                Class.forName("oracle.jdbc.driver.OracleDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
        }
        catch (Exception ex) {
            logger.error("error loading database driver.. ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static void setUsername(String aUsername) {
        username = aUsername;
    }

    public static void setPassword(String aPassword) {
        password = aPassword;
    }

    public static String getConnectionString() {
        return connectionString;
    }

    public static void setConnectionString(String aConnectionString) {
        connectionString = aConnectionString;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String[] getComponentNames() {
        try (NeqSimDataBase database = new NeqSimDataBase();){
            String[] stringArray;
            block14: {
                ResultSet dataSet = database.getResultSet("SELECT name FROM comp ORDER BY ID");
                try {
                    ArrayList<String> names = new ArrayList<String>();
                    while (dataSet.next()) {
                        names.add(dataSet.getString("name"));
                    }
                    stringArray = names.toArray(new String[0]);
                    if (dataSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (dataSet != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dataSet.close();
            }
            return stringArray;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasComponent(String name) {
        try (NeqSimDataBase database = new NeqSimDataBase();){
            boolean bl;
            block17: {
                ResultSet dataSet;
                block15: {
                    boolean bl2;
                    block16: {
                        dataSet = database.getResultSet("select count(*) from comp WHERE NAME='" + name + "'");
                        try {
                            dataSet.next();
                            int size = dataSet.getInt(1);
                            if (size != 0) break block15;
                            bl2 = false;
                            if (dataSet == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (dataSet != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        dataSet.close();
                    }
                    return bl2;
                }
                bl = true;
                if (dataSet == null) break block17;
                dataSet.close();
            }
            return bl;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasTempComponent(String name) {
        try (NeqSimDataBase database = new NeqSimDataBase();){
            boolean bl;
            block17: {
                ResultSet dataSet;
                block15: {
                    boolean bl2;
                    block16: {
                        dataSet = database.getResultSet("select count(*) from comptemp WHERE NAME='" + name + "'");
                        try {
                            dataSet.next();
                            int size = dataSet.getInt(1);
                            if (size != 0) break block15;
                            bl2 = false;
                            if (dataSet == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (dataSet != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        dataSet.close();
                    }
                    return bl2;
                }
                bl = true;
                if (dataSet == null) break block17;
                dataSet.close();
            }
            return bl;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void updateTable(String tableName) {
        NeqSimDataBase.updateTable(tableName, "data/" + tableName + ".csv");
    }

    public static void updateTable(String tableName, String path) {
        URL url = NeqSimDataBase.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new RuntimeException(new InvalidInputException("NeqSimDataBase", "updateTable", "path", "- Resource " + path + " not found"));
        }
        try (NeqSimDataBase database = new NeqSimDataBase();){
            database.execute("DROP TABLE IF EXISTS " + tableName);
            String sqlString = "CREATE TABLE " + tableName + " AS SELECT * FROM CSVREAD('file:" + String.valueOf(url) + "')";
            database.execute(sqlString);
        }
        catch (Exception ex) {
            logger.error("Failed updating table " + tableName, (Throwable)ex);
        }
    }

    public static void replaceTable(String tableName, String path) {
        try (NeqSimDataBase database = new NeqSimDataBase();){
            database.execute("DROP TABLE IF EXISTS " + tableName);
            String sqlString = "CREATE TABLE " + tableName + " AS SELECT * FROM CSVREAD('" + path + "')";
            database.execute(sqlString);
        }
        catch (Exception ex) {
            NeqSimDataBase.updateTable(tableName);
            logger.error("Failed updating table " + tableName, (Throwable)ex);
            throw new RuntimeException(new InvalidInputException("NeqSimDataBase", "replaceTable", "path", "- Resource " + path + " not found"));
        }
    }

    public static void initH2DatabaseFromCSVfiles() {
        h2IsInitalizing = true;
        connectionString = "jdbc:h2:mem:neqsimthermodatabase;DB_CLOSE_DELAY=-1";
        dataBaseType = "H2";
        try {
            NeqSimDataBase.updateTable("COMP");
            NeqSimDataBase.updateTable("INTER");
            NeqSimDataBase.updateTable("element");
            NeqSimDataBase.updateTable("ISO6976constants");
            NeqSimDataBase.updateTable("ISO6976constants2016");
            NeqSimDataBase.updateTable("STOCCOEFDATA");
            NeqSimDataBase.updateTable("REACTIONDATA");
            NeqSimDataBase.updateTable("ReactionKSPdata");
            NeqSimDataBase.updateTable("AdsorptionParameters");
            NeqSimDataBase.updateTable("UNIFACcomp");
            NeqSimDataBase.updateTable("UNIFACcompUMRPRU");
            NeqSimDataBase.updateTable("UNIFACGroupParam");
            NeqSimDataBase.updateTable("UNIFACInterParam");
            NeqSimDataBase.updateTable("UNIFACInterParamA_UMR");
            NeqSimDataBase.updateTable("UNIFACInterParamA_UMRMC");
            NeqSimDataBase.updateTable("UNIFACInterParamB");
            NeqSimDataBase.updateTable("UNIFACInterParamB_UMR");
            NeqSimDataBase.updateTable("UNIFACInterParamB_UMRMC");
            NeqSimDataBase.updateTable("UNIFACInterParamC");
            NeqSimDataBase.updateTable("UNIFACInterParamC_UMR");
            NeqSimDataBase.updateTable("UNIFACInterParamC_UMRMC");
            NeqSimDataBase.updateTable("MBWR32param");
            NeqSimDataBase.updateTable("COMPSALT");
            NeqSimDataBase.updateTable("PIPEDATA");
            try (NeqSimDataBase database = new NeqSimDataBase();){
                database.execute("CREATE TABLE comptemp AS SELECT * FROM comp");
                database.execute("CREATE TABLE intertemp AS SELECT * FROM inter");
            }
            h2IsInitialized = true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

