/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.unit;

import neqsim.util.unit.BaseUnit;

public class TemperatureUnit
extends BaseUnit {
    private static final long serialVersionUID = 1000L;

    public TemperatureUnit(double value, String name) {
        super(value, name);
    }

    public double getConversionFactor(String name) {
        switch (name) {
            case "K": {
                return 1.0;
            }
            case "C": {
                return 1.0;
            }
            case "F": {
                return 0.5555555555555556;
            }
            case "R": {
                return 0.5555555555555556;
            }
        }
        throw new IllegalArgumentException("Unknown unit: " + name);
    }

    @Override
    public double getValue(double value, String fromUnit, String toUnit) {
        if (fromUnit.equals(toUnit)) {
            return value;
        }
        double tempInKelvin = switch (fromUnit) {
            case "K" -> value;
            case "C" -> value + 273.15;
            case "F" -> (value - 32.0) * 5.0 / 9.0 + 273.15;
            case "R" -> value * 5.0 / 9.0;
            default -> throw new IllegalArgumentException("Unsupported fromUnit: " + fromUnit);
        };
        if (toUnit.equals("K")) {
            return tempInKelvin;
        }
        if (toUnit.equals("C")) {
            return tempInKelvin - 273.15;
        }
        if (toUnit.equals("F")) {
            return (tempInKelvin - 273.15) * 9.0 / 5.0 + 32.0;
        }
        if (toUnit.equals("R")) {
            return tempInKelvin * 9.0 / 5.0;
        }
        throw new IllegalArgumentException("Unsupported unit: " + toUnit);
    }

    @Override
    public double getValue(String toUnit) {
        switch (toUnit) {
            case "K": {
                return this.invalue;
            }
            case "C": {
                return this.invalue - 273.15;
            }
            case "F": {
                return this.invalue * 9.0 / 5.0 - 459.67;
            }
            case "R": {
                return this.invalue * 9.0 / 5.0;
            }
        }
        throw new IllegalArgumentException("Unsupported conversion unit: " + toUnit);
    }
}

