
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import Jama
import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.chemicalreactions
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.component
import jneqsim.neqsim.thermo.system
import typing



class ChemEq(java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def __init__(self, double: float, double2: float, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray]): ...
    @typing.overload
    def __init__(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    def chemSolve(self) -> None: ...
    def innerStep(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], int: int, double2: float) -> float: ...
    @typing.overload
    def solve(self) -> None: ...
    @typing.overload
    def solve(self, double: float, double2: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def step(self) -> float: ...

class ChemicalEquilibrium(java.io.Serializable):
    def __init__(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, componentInterfaceArray: typing.Union[typing.List[jneqsim.neqsim.thermo.component.ComponentInterface], jpype.JArray], int: int): ...
    def calcRefPot(self) -> None: ...
    def chemSolve(self) -> None: ...
    def getMoles(self) -> typing.MutableSequence[float]: ...
    def innerStep(self, int: int, doubleArray: typing.Union[typing.List[float], jpype.JArray], int2: int, double2: float, boolean: bool) -> float: ...
    def printComp(self) -> None: ...
    def solve(self) -> bool: ...
    def step(self) -> float: ...
    def updateMoles(self) -> None: ...

class LinearProgrammingChemicalEquilibrium(jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    def __init__(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], componentInterfaceArray: typing.Union[typing.List[jneqsim.neqsim.thermo.component.ComponentInterface], jpype.JArray], stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], chemicalReactionOperations: jneqsim.neqsim.chemicalreactions.ChemicalReactionOperations, int: int): ...
    def calcA(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def calcx(self, matrix: Jama.Matrix, matrix2: Jama.Matrix) -> None: ...
    def changePrimaryComponents(self) -> None: ...
    def generateInitialEstimates(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray], double2: float, int: int) -> typing.MutableSequence[float]: ...
    def getA(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getRefPot(self) -> typing.MutableSequence[float]: ...

class ReferencePotComparator(java.util.Comparator[jneqsim.neqsim.thermo.component.ComponentInterface], java.io.Serializable):
    def __init__(self): ...
    def compare(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface, componentInterface2: jneqsim.neqsim.thermo.component.ComponentInterface) -> int: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.chemicalreactions.chemicalequilibrium")``.

    ChemEq: typing.Type[ChemEq]
    ChemicalEquilibrium: typing.Type[ChemicalEquilibrium]
    LinearProgrammingChemicalEquilibrium: typing.Type[LinearProgrammingChemicalEquilibrium]
    ReferencePotComparator: typing.Type[ReferencePotComparator]
