
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import jneqsim.neqsim.fluidmechanics.flowleg.pipeleg
import jneqsim.neqsim.fluidmechanics.flownode
import jneqsim.neqsim.fluidmechanics.geometrydefinitions
import jneqsim.neqsim.thermo.system
import typing



class FlowLegInterface:
    @typing.overload
    def createFlowNodes(self) -> None: ...
    @typing.overload
    def createFlowNodes(self, flowNodeInterface: jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface) -> None: ...
    def getFlowNodes(self) -> typing.MutableSequence[jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface]: ...
    def getNode(self, int: int) -> jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface: ...
    def getNumberOfNodes(self) -> int: ...
    def setEquipmentGeometry(self, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface) -> None: ...
    def setFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setHeightCoordinates(self, double: float, double2: float) -> None: ...
    def setLongitudionalCoordinates(self, double: float, double2: float) -> None: ...
    def setNumberOfNodes(self, int: int) -> None: ...
    def setOuterHeatTransferCoefficients(self, double: float, double2: float) -> None: ...
    def setOuterTemperatures(self, double: float, double2: float) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setWallHeatTransferCoefficients(self, double: float, double2: float) -> None: ...

class FlowLeg(FlowLegInterface, java.io.Serializable):
    def __init__(self): ...
    @typing.overload
    def createFlowNodes(self, flowNodeInterface: jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface) -> None: ...
    @typing.overload
    def createFlowNodes(self) -> None: ...
    def getFlowNodes(self) -> typing.MutableSequence[jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface]: ...
    def getNode(self, int: int) -> jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface: ...
    def getNumberOfNodes(self) -> int: ...
    def setEquipmentGeometry(self, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface) -> None: ...
    def setFlowNodeTypes(self) -> None: ...
    def setFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setHeightCoordinates(self, double: float, double2: float) -> None: ...
    def setLongitudionalCoordinates(self, double: float, double2: float) -> None: ...
    def setNumberOfNodes(self, int: int) -> None: ...
    def setOuterHeatTransferCoefficients(self, double: float, double2: float) -> None: ...
    def setOuterTemperatures(self, double: float, double2: float) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setWallHeatTransferCoefficients(self, double: float, double2: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.flowleg")``.

    FlowLeg: typing.Type[FlowLeg]
    FlowLegInterface: typing.Type[FlowLegInterface]
    pipeleg: jneqsim.neqsim.fluidmechanics.flowleg.pipeleg.__module_protocol__
