
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import Jama
import java.io
import java.lang
import jneqsim.neqsim.fluidmechanics.flownode
import jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.equilibriumfluidboundary
import jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.finitevolumeboundary
import jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary
import jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.reactivefilmmodel.enhancementfactor
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations
import typing



class FluidBoundaryInterface(java.lang.Cloneable):
    def calcFluxes(self) -> typing.MutableSequence[float]: ...
    def clone(self) -> 'FluidBoundaryInterface': ...
    def display(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getBinaryMassTransferCoefficient(self, int: int, int2: int, int3: int) -> float: ...
    def getBulkSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getBulkSystemOpertions(self) -> jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations: ...
    def getEffectiveMassTransferCoefficient(self, int: int, int2: int) -> float: ...
    def getEnhancementFactor(self) -> jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.reactivefilmmodel.enhancementfactor.EnhancementFactor: ...
    def getInterphaseHeatFlux(self, int: int) -> float: ...
    def getInterphaseMolarFlux(self, int: int) -> float: ...
    def getInterphaseSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getMassTransferCoefficientMatrix(self) -> typing.MutableSequence[Jama.Matrix]: ...
    def heatTransSolve(self) -> None: ...
    def isHeatTransferCalc(self) -> bool: ...
    def massTransSolve(self) -> None: ...
    def setEnhancementType(self, int: int) -> None: ...
    def setHeatTransferCalc(self, boolean: bool) -> None: ...
    def setInterphaseSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setMassTransferCalc(self, boolean: bool) -> None: ...
    def solve(self) -> None: ...
    @typing.overload
    def useFiniteFluxCorrection(self, int: int) -> bool: ...
    @typing.overload
    def useFiniteFluxCorrection(self, boolean: bool) -> None: ...
    @typing.overload
    def useFiniteFluxCorrection(self, boolean: bool, int: int) -> None: ...
    @typing.overload
    def useThermodynamicCorrections(self, int: int) -> bool: ...
    @typing.overload
    def useThermodynamicCorrections(self, boolean: bool) -> None: ...
    @typing.overload
    def useThermodynamicCorrections(self, boolean: bool, int: int) -> None: ...
    def write(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], boolean: bool) -> None: ...

class FluidBoundary(FluidBoundaryInterface, java.io.Serializable):
    interphaseHeatFlux: typing.MutableSequence[float] = ...
    massTransferCalc: bool = ...
    heatTransferCalc: bool = ...
    thermodynamicCorrections: typing.MutableSequence[bool] = ...
    finiteFluxCorrection: typing.MutableSequence[bool] = ...
    binaryMassTransferCoefficient: typing.MutableSequence[typing.MutableSequence[typing.MutableSequence[float]]] = ...
    heatTransferCoefficient: typing.MutableSequence[float] = ...
    heatTransferCorrection: typing.MutableSequence[float] = ...
    @typing.overload
    def __init__(self, flowNodeInterface: jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcFluxTypeCorrectionMatrix(self, int: int, int2: int) -> None: ...
    def calcNonIdealCorrections(self, int: int) -> None: ...
    def clone(self) -> 'FluidBoundary': ...
    def createTable(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def display(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getBinaryMassTransferCoefficient(self, int: int, int2: int, int3: int) -> float: ...
    def getBulkSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getBulkSystemOpertions(self) -> jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations: ...
    def getEffectiveMassTransferCoefficient(self, int: int, int2: int) -> float: ...
    def getEnhancementFactor(self) -> jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.reactivefilmmodel.enhancementfactor.EnhancementFactor: ...
    def getInterphaseHeatFlux(self, int: int) -> float: ...
    def getInterphaseMolarFlux(self, int: int) -> float: ...
    def getInterphaseOpertions(self) -> jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations: ...
    def getInterphaseSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getMassTransferCoefficientMatrix(self) -> typing.MutableSequence[Jama.Matrix]: ...
    def heatTransSolve(self) -> None: ...
    def init(self) -> None: ...
    def initHeatTransferCalc(self) -> None: ...
    def initInterphaseSystem(self) -> None: ...
    def initMassTransferCalc(self) -> None: ...
    def isHeatTransferCalc(self) -> bool: ...
    def massTransSolve(self) -> None: ...
    def setBulkSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setEnhancementType(self, int: int) -> None: ...
    def setHeatTransferCalc(self, boolean: bool) -> None: ...
    def setInterphaseSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setMassTransferCalc(self, boolean: bool) -> None: ...
    def setSolverType(self, int: int) -> None: ...
    @typing.overload
    def useFiniteFluxCorrection(self, int: int) -> bool: ...
    @typing.overload
    def useFiniteFluxCorrection(self, boolean: bool) -> None: ...
    @typing.overload
    def useFiniteFluxCorrection(self, boolean: bool, int: int) -> None: ...
    @typing.overload
    def useThermodynamicCorrections(self, int: int) -> bool: ...
    @typing.overload
    def useThermodynamicCorrections(self, boolean: bool) -> None: ...
    @typing.overload
    def useThermodynamicCorrections(self, boolean: bool, int: int) -> None: ...
    def write(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], boolean: bool) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc")``.

    FluidBoundary: typing.Type[FluidBoundary]
    FluidBoundaryInterface: typing.Type[FluidBoundaryInterface]
    equilibriumfluidboundary: jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.equilibriumfluidboundary.__module_protocol__
    finitevolumeboundary: jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.finitevolumeboundary.__module_protocol__
    nonequilibriumfluidboundary: jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.__module_protocol__
