
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import jpype
import jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc
import typing



class EnhancementFactorInterface:
    def calcEnhancementVec(self, int: int) -> None: ...
    def getEnhancementVec(self, int: int) -> float: ...
    def getHattaNumber(self, int: int) -> float: ...

class EnhancementFactor(EnhancementFactorInterface):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, fluidBoundaryInterface: jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.FluidBoundaryInterface): ...
    @typing.overload
    def calcEnhancementVec(self, int: int) -> None: ...
    @typing.overload
    def calcEnhancementVec(self, int: int, int2: int) -> None: ...
    @typing.overload
    def getEnhancementVec(self, int: int) -> float: ...
    @typing.overload
    def getEnhancementVec(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getHattaNumber(self, int: int) -> float: ...
    @typing.overload
    def getHattaNumber(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def setEnhancementVec(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setEnhancementVec(self, int: int, double: float) -> None: ...
    def setHattaNumber(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setOnesVec(self, int: int) -> None: ...

class EnhancementFactorAlg(EnhancementFactor):
    def __init__(self, fluidBoundaryInterface: jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.FluidBoundaryInterface): ...
    @typing.overload
    def calcEnhancementVec(self, int: int, int2: int) -> None: ...
    @typing.overload
    def calcEnhancementVec(self, int: int) -> None: ...

class EnhancementFactorNumeric(EnhancementFactor):
    def __init__(self, fluidBoundaryInterface: jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.FluidBoundaryInterface): ...
    def calcEnhancementMatrix(self, int: int) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.reactivefilmmodel.enhancementfactor")``.

    EnhancementFactor: typing.Type[EnhancementFactor]
    EnhancementFactorAlg: typing.Type[EnhancementFactorAlg]
    EnhancementFactorInterface: typing.Type[EnhancementFactorInterface]
    EnhancementFactorNumeric: typing.Type[EnhancementFactorNumeric]
