
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import jneqsim.neqsim.fluidmechanics.flowsolver.onephaseflowsolver
import jneqsim.neqsim.fluidmechanics.flowsolver.twophaseflowsolver
import typing



class FlowSolverInterface:
    def setBoundarySpecificationType(self, int: int) -> None: ...
    def setDynamic(self, boolean: bool) -> None: ...
    def setSolverType(self, int: int) -> None: ...
    def setTimeStep(self, double: float) -> None: ...
    def solve(self) -> None: ...
    def solveTDMA(self) -> None: ...

class FlowSolver(FlowSolverInterface, java.io.Serializable):
    def __init__(self): ...
    def setBoundarySpecificationType(self, int: int) -> None: ...
    def setDynamic(self, boolean: bool) -> None: ...
    def setSolverType(self, int: int) -> None: ...
    def setTimeStep(self, double: float) -> None: ...
    def solve(self) -> None: ...
    def solveTDMA(self) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.flowsolver")``.

    FlowSolver: typing.Type[FlowSolver]
    FlowSolverInterface: typing.Type[FlowSolverInterface]
    onephaseflowsolver: jneqsim.neqsim.fluidmechanics.flowsolver.onephaseflowsolver.__module_protocol__
    twophaseflowsolver: jneqsim.neqsim.fluidmechanics.flowsolver.twophaseflowsolver.__module_protocol__
