
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.fluidmechanics.flownode
import jneqsim.neqsim.fluidmechanics.flowsolver
import jneqsim.neqsim.fluidmechanics.flowsystem.onephaseflowsystem
import jneqsim.neqsim.fluidmechanics.flowsystem.twophaseflowsystem
import jneqsim.neqsim.fluidmechanics.geometrydefinitions
import jneqsim.neqsim.fluidmechanics.util.fluidmechanicsvisualization.flowsystemvisualization
import jneqsim.neqsim.fluidmechanics.util.timeseries
import jneqsim.neqsim.thermo.system
import typing



class FlowSystemInterface:
    def calcFluxes(self) -> None: ...
    def createSystem(self) -> None: ...
    def getDisplay(self) -> jneqsim.neqsim.fluidmechanics.util.fluidmechanicsvisualization.flowsystemvisualization.FlowSystemVisualizationInterface: ...
    def getFlowNodes(self) -> typing.MutableSequence[jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface]: ...
    def getInletPressure(self) -> float: ...
    def getInletTemperature(self) -> float: ...
    def getLegHeights(self) -> typing.MutableSequence[float]: ...
    def getNode(self, int: int) -> jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface: ...
    def getNumberOfLegs(self) -> int: ...
    def getNumberOfNodesInLeg(self, int: int) -> int: ...
    def getSolver(self) -> jneqsim.neqsim.fluidmechanics.flowsolver.FlowSolverInterface: ...
    def getSystemLength(self) -> float: ...
    def getTimeSeries(self) -> jneqsim.neqsim.fluidmechanics.util.timeseries.TimeSeries: ...
    @typing.overload
    def getTotalMolarMassTransferRate(self, int: int) -> float: ...
    @typing.overload
    def getTotalMolarMassTransferRate(self, int: int, int2: int) -> float: ...
    def getTotalNumberOfNodes(self) -> int: ...
    @typing.overload
    def getTotalPressureDrop(self) -> float: ...
    @typing.overload
    def getTotalPressureDrop(self, int: int) -> float: ...
    def init(self) -> None: ...
    def print_(self) -> None: ...
    def setEndPressure(self, double: float) -> None: ...
    def setEquilibriumHeatTransfer(self, boolean: bool) -> None: ...
    def setEquilibriumMassTransfer(self, boolean: bool) -> None: ...
    def setEquipmentGeometry(self, geometryDefinitionInterfaceArray: typing.Union[typing.List[jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface], jpype.JArray]) -> None: ...
    def setFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInitialFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInletThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setLegHeights(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setLegOuterHeatTransferCoefficients(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setLegOuterTemperatures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setLegPositions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setLegWallHeatTransferCoefficients(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setNodes(self) -> None: ...
    def setNumberOfLegs(self, int: int) -> None: ...
    def setNumberOfNodesInLeg(self, int: int) -> None: ...
    @typing.overload
    def solveSteadyState(self, int: int, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def solveSteadyState(self, int: int) -> None: ...
    @typing.overload
    def solveTransient(self, int: int, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def solveTransient(self, int: int) -> None: ...

class FlowSystem(FlowSystemInterface, java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcFluxes(self) -> None: ...
    def calcTotalNumberOfNodes(self) -> int: ...
    def createSystem(self) -> None: ...
    def flowLegInit(self) -> None: ...
    def getDisplay(self) -> jneqsim.neqsim.fluidmechanics.util.fluidmechanicsvisualization.flowsystemvisualization.FlowSystemVisualizationInterface: ...
    def getFlowNodes(self) -> typing.MutableSequence[jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface]: ...
    def getInletPressure(self) -> float: ...
    def getInletTemperature(self) -> float: ...
    def getLegHeights(self) -> typing.MutableSequence[float]: ...
    def getNode(self, int: int) -> jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface: ...
    def getNumberOfLegs(self) -> int: ...
    def getNumberOfNodesInLeg(self, int: int) -> int: ...
    def getSolver(self) -> jneqsim.neqsim.fluidmechanics.flowsolver.FlowSolverInterface: ...
    def getSystemLength(self) -> float: ...
    def getTimeSeries(self) -> jneqsim.neqsim.fluidmechanics.util.timeseries.TimeSeries: ...
    @typing.overload
    def getTotalMolarMassTransferRate(self, int: int) -> float: ...
    @typing.overload
    def getTotalMolarMassTransferRate(self, int: int, int2: int) -> float: ...
    def getTotalNumberOfNodes(self) -> int: ...
    @typing.overload
    def getTotalPressureDrop(self) -> float: ...
    @typing.overload
    def getTotalPressureDrop(self, int: int) -> float: ...
    def init(self) -> None: ...
    def print_(self) -> None: ...
    def setEndPressure(self, double: float) -> None: ...
    def setEquilibriumHeatTransfer(self, boolean: bool) -> None: ...
    def setEquilibriumHeatTransferModel(self, int: int, int2: int) -> None: ...
    def setEquilibriumMassTransfer(self, boolean: bool) -> None: ...
    def setEquilibriumMassTransferModel(self, int: int, int2: int) -> None: ...
    def setEquipmentGeometry(self, geometryDefinitionInterfaceArray: typing.Union[typing.List[jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface], jpype.JArray]) -> None: ...
    def setFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInitialFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInletThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setLegHeights(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setLegOuterHeatTransferCoefficients(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setLegOuterTemperatures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setLegPositions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setLegWallHeatTransferCoefficients(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setNodes(self) -> None: ...
    def setNonEquilibriumHeatTransferModel(self, int: int, int2: int) -> None: ...
    def setNonEquilibriumMassTransferModel(self, int: int, int2: int) -> None: ...
    def setNumberOfLegs(self, int: int) -> None: ...
    def setNumberOfNodesInLeg(self, int: int) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.flowsystem")``.

    FlowSystem: typing.Type[FlowSystem]
    FlowSystemInterface: typing.Type[FlowSystemInterface]
    onephaseflowsystem: jneqsim.neqsim.fluidmechanics.flowsystem.onephaseflowsystem.__module_protocol__
    twophaseflowsystem: jneqsim.neqsim.fluidmechanics.flowsystem.twophaseflowsystem.__module_protocol__
