
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import typing



class MaterialLayer:
    def __init__(self, string: typing.Union[java.lang.String, str], double: float): ...
    def getConductivity(self) -> float: ...
    def getCv(self) -> float: ...
    def getDensity(self) -> float: ...
    def getHeatTransferCoefficient(self) -> float: ...
    def getInsideTemperature(self) -> float: ...
    def getOutsideTemperature(self) -> float: ...
    def getThickness(self) -> float: ...
    def setConductivity(self, double: float) -> None: ...
    def setCv(self, double: float) -> None: ...
    def setDensity(self, double: float) -> None: ...
    def setInsideTemperature(self, double: float) -> None: ...
    def setOutsideTemperature(self, double: float) -> None: ...
    def setThickness(self, double: float) -> None: ...

class WallInterface:
    def addMaterialLayer(self, materialLayer: MaterialLayer) -> None: ...
    def getWallMaterialLayer(self, int: int) -> MaterialLayer: ...

class Wall(WallInterface):
    def __init__(self): ...
    def addMaterialLayer(self, materialLayer: MaterialLayer) -> None: ...
    def calcHeatTransferCoefficient(self) -> float: ...
    def getHeatTransferCoefficient(self) -> float: ...
    def getWallMaterialLayer(self, int: int) -> MaterialLayer: ...
    def setHeatTransferCoefficient(self, double: float) -> None: ...

class PipeWall(Wall):
    def __init__(self): ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.wall")``.

    MaterialLayer: typing.Type[MaterialLayer]
    PipeWall: typing.Type[PipeWall]
    Wall: typing.Type[Wall]
    WallInterface: typing.Type[WallInterface]
