
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import jpype
import jneqsim.neqsim.thermo.component
import jneqsim.neqsim.thermo.phase
import jneqsim.neqsim.thermo.system
import typing



class NewtonRhapson(java.io.Serializable):
    def __init__(self): ...
    def derivValue(self, double: float) -> float: ...
    def dubDerivValue(self, double: float) -> float: ...
    def funkValue(self, double: float) -> float: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def setConstants(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMaxIterations(self, int: int) -> None: ...
    def setOrder(self, int: int) -> None: ...
    def solve(self, double: float) -> float: ...
    def solve1order(self, double: float) -> float: ...

class NumericalDerivative(java.io.Serializable):
    @staticmethod
    def fugcoefDiffPres(componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    @staticmethod
    def fugcoefDiffTemp(componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...

class NumericalIntegration:
    def __init__(self): ...

class SysNewtonRhapson(java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int): ...
    def calcInc(self, int: int) -> None: ...
    def calcInc2(self, int: int) -> None: ...
    def findSpecEq(self) -> None: ...
    def findSpecEqInit(self) -> None: ...
    def getNpCrit(self) -> int: ...
    def init(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...
    def setu(self) -> None: ...
    def sign(self, double: float, double2: float) -> float: ...
    def solve(self, int: int) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.mathlib.nonlinearsolver")``.

    NewtonRhapson: typing.Type[NewtonRhapson]
    NumericalDerivative: typing.Type[NumericalDerivative]
    NumericalIntegration: typing.Type[NumericalIntegration]
    SysNewtonRhapson: typing.Type[SysNewtonRhapson]
