
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import jpype
import jneqsim.neqsim.physicalproperties.interfaceproperties
import jneqsim.neqsim.thermo.system
import org.apache.commons.math3.ode
import typing



class GTSurfaceTensionFullGT:
    normtol: float = ...
    reltol: float = ...
    abstol: float = ...
    maxit: int = ...
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int): ...
    @staticmethod
    def Newton(doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], double2: float, int: int, double3: float, boolean: bool, boolean2: bool, doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int2: int, double5: float, doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> float: ...
    def calc_std_integral(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> float: ...
    @staticmethod
    def debugPlot(doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @staticmethod
    def delta_mu(systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @staticmethod
    def directsolve(doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[typing.MutableSequence[float]]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], double4: float, int: int, doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], int2: int) -> None: ...
    @staticmethod
    def initmu(systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray], double6: float) -> None: ...
    @staticmethod
    def linspace(double: float, double2: float, int: int) -> typing.MutableSequence[float]: ...
    def runcase(self) -> float: ...
    @staticmethod
    def sigmaCalc(double: float, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], boolean: bool, doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], int: int) -> float: ...

class GTSurfaceTensionODE(org.apache.commons.math3.ode.FirstOrderDifferentialEquations):
    normtol: float = ...
    reltol: float = ...
    abstol: float = ...
    maxit: int = ...
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int, int3: int, double: float): ...
    def computeDerivatives(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def fjacfun(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def getDimension(self) -> int: ...
    def initmu(self) -> None: ...

class GTSurfaceTensionUtils:
    @staticmethod
    def mufun(systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class SurfaceTensionInterface:
    def calcSurfaceTension(self, int: int, int2: int) -> float: ...

class SurfaceTension(jneqsim.neqsim.physicalproperties.interfaceproperties.InterfaceProperties, SurfaceTensionInterface):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcPureComponentSurfaceTension(self, int: int) -> float: ...
    def calcSurfaceTension(self, int: int, int2: int) -> float: ...
    def getComponentWithHighestBoilingpoint(self) -> int: ...

class FirozabadiRamleyInterfaceTension(SurfaceTension):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcPureComponentSurfaceTension(self, int: int) -> float: ...
    def calcSurfaceTension(self, int: int, int2: int) -> float: ...

class GTSurfaceTension(SurfaceTension):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcSurfaceTension(self, int: int, int2: int) -> float: ...
    @staticmethod
    def solveFullDensityProfile(systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int) -> float: ...
    @staticmethod
    def solveWithRefcomp(systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int, int3: int) -> float: ...

class GTSurfaceTensionSimple(SurfaceTension):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcInfluenceParameters(self) -> None: ...
    def calcSurfaceTension(self, int: int, int2: int) -> float: ...
    def getDmudn2(self) -> typing.MutableSequence[typing.MutableSequence[typing.MutableSequence[float]]]: ...
    def getInfluenceParameter(self, double: float, int: int) -> float: ...
    def getMolarDensity(self, int: int) -> typing.MutableSequence[float]: ...
    def getMolarDensityTotal(self) -> typing.MutableSequence[float]: ...
    def getPressure(self) -> typing.MutableSequence[float]: ...
    def getz(self) -> typing.MutableSequence[float]: ...
    def setDmudn2(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[typing.MutableSequence[float]]], jpype.JArray]) -> None: ...

class LGTSurfaceTension(SurfaceTension):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcSurfaceTension(self, int: int, int2: int) -> float: ...
    def getMolarDensity(self, int: int) -> typing.MutableSequence[float]: ...
    def getMolarDensityTotal(self) -> typing.MutableSequence[float]: ...
    def getPressure(self) -> typing.MutableSequence[float]: ...
    def getz(self) -> typing.MutableSequence[float]: ...

class ParachorSurfaceTension(SurfaceTension):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcPureComponentSurfaceTension(self, int: int) -> float: ...
    def calcSurfaceTension(self, int: int, int2: int) -> float: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.physicalproperties.interfaceproperties.surfacetension")``.

    FirozabadiRamleyInterfaceTension: typing.Type[FirozabadiRamleyInterfaceTension]
    GTSurfaceTension: typing.Type[GTSurfaceTension]
    GTSurfaceTensionFullGT: typing.Type[GTSurfaceTensionFullGT]
    GTSurfaceTensionODE: typing.Type[GTSurfaceTensionODE]
    GTSurfaceTensionSimple: typing.Type[GTSurfaceTensionSimple]
    GTSurfaceTensionUtils: typing.Type[GTSurfaceTensionUtils]
    LGTSurfaceTension: typing.Type[LGTSurfaceTension]
    ParachorSurfaceTension: typing.Type[ParachorSurfaceTension]
    SurfaceTension: typing.Type[SurfaceTension]
    SurfaceTensionInterface: typing.Type[SurfaceTensionInterface]
