
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jneqsim.neqsim.process.measurementdevice
import jneqsim.neqsim.util
import typing



class ControllerDeviceInterface(java.io.Serializable):
    def equals(self, object: typing.Any) -> bool: ...
    def getMeasuredValue(self) -> float: ...
    def getResponse(self) -> float: ...
    def getUnit(self) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def isActive(self) -> bool: ...
    def isReverseActing(self) -> bool: ...
    @typing.overload
    def runTransient(self, double: float, double2: float, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float, double2: float) -> None: ...
    def setActive(self, boolean: bool) -> None: ...
    def setControllerParameters(self, double: float, double2: float, double3: float) -> None: ...
    def setControllerSetPoint(self, double: float) -> None: ...
    def setReverseActing(self, boolean: bool) -> None: ...
    def setTransmitter(self, measurementDeviceInterface: jneqsim.neqsim.process.measurementdevice.MeasurementDeviceInterface) -> None: ...
    def setUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...

class ControllerDeviceBaseClass(jneqsim.neqsim.util.NamedBaseClass, ControllerDeviceInterface):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def getKp(self) -> float: ...
    def getMeasuredValue(self) -> float: ...
    def getResponse(self) -> float: ...
    def getTd(self) -> float: ...
    def getTi(self) -> float: ...
    def getUnit(self) -> java.lang.String: ...
    def isActive(self) -> bool: ...
    def isReverseActing(self) -> bool: ...
    @typing.overload
    def runTransient(self, double: float, double2: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, double2: float, uUID: java.util.UUID) -> None: ...
    def setActive(self, boolean: bool) -> None: ...
    def setControllerParameters(self, double: float, double2: float, double3: float) -> None: ...
    def setControllerSetPoint(self, double: float) -> None: ...
    def setKp(self, double: float) -> None: ...
    def setReverseActing(self, boolean: bool) -> None: ...
    def setTd(self, double: float) -> None: ...
    def setTi(self, double: float) -> None: ...
    def setTransmitter(self, measurementDeviceInterface: jneqsim.neqsim.process.measurementdevice.MeasurementDeviceInterface) -> None: ...
    def setUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.controllerdevice")``.

    ControllerDeviceBaseClass: typing.Type[ControllerDeviceBaseClass]
    ControllerDeviceInterface: typing.Type[ControllerDeviceInterface]
