
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process
import jneqsim.neqsim.process.controllerdevice
import jneqsim.neqsim.process.equipment.absorber
import jneqsim.neqsim.process.equipment.adsorber
import jneqsim.neqsim.process.equipment.compressor
import jneqsim.neqsim.process.equipment.diffpressure
import jneqsim.neqsim.process.equipment.distillation
import jneqsim.neqsim.process.equipment.ejector
import jneqsim.neqsim.process.equipment.expander
import jneqsim.neqsim.process.equipment.filter
import jneqsim.neqsim.process.equipment.flare
import jneqsim.neqsim.process.equipment.heatexchanger
import jneqsim.neqsim.process.equipment.manifold
import jneqsim.neqsim.process.equipment.membrane
import jneqsim.neqsim.process.equipment.mixer
import jneqsim.neqsim.process.equipment.pipeline
import jneqsim.neqsim.process.equipment.powergeneration
import jneqsim.neqsim.process.equipment.pump
import jneqsim.neqsim.process.equipment.reactor
import jneqsim.neqsim.process.equipment.reservoir
import jneqsim.neqsim.process.equipment.separator
import jneqsim.neqsim.process.equipment.splitter
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.equipment.subsea
import jneqsim.neqsim.process.equipment.tank
import jneqsim.neqsim.process.equipment.util
import jneqsim.neqsim.process.equipment.valve
import jneqsim.neqsim.process.mechanicaldesign
import jneqsim.neqsim.thermo.system
import typing



class EquipmentEnum(java.lang.Enum['EquipmentEnum']):
    Stream: typing.ClassVar['EquipmentEnum'] = ...
    ThrottlingValve: typing.ClassVar['EquipmentEnum'] = ...
    Compressor: typing.ClassVar['EquipmentEnum'] = ...
    Pump: typing.ClassVar['EquipmentEnum'] = ...
    Separator: typing.ClassVar['EquipmentEnum'] = ...
    HeatExchanger: typing.ClassVar['EquipmentEnum'] = ...
    Cooler: typing.ClassVar['EquipmentEnum'] = ...
    Heater: typing.ClassVar['EquipmentEnum'] = ...
    Mixer: typing.ClassVar['EquipmentEnum'] = ...
    Splitter: typing.ClassVar['EquipmentEnum'] = ...
    Reactor: typing.ClassVar['EquipmentEnum'] = ...
    Column: typing.ClassVar['EquipmentEnum'] = ...
    ThreePhaseSeparator: typing.ClassVar['EquipmentEnum'] = ...
    Recycle: typing.ClassVar['EquipmentEnum'] = ...
    Ejector: typing.ClassVar['EquipmentEnum'] = ...
    GORfitter: typing.ClassVar['EquipmentEnum'] = ...
    Adjuster: typing.ClassVar['EquipmentEnum'] = ...
    SetPoint: typing.ClassVar['EquipmentEnum'] = ...
    FlowRateAdjuster: typing.ClassVar['EquipmentEnum'] = ...
    Calculator: typing.ClassVar['EquipmentEnum'] = ...
    Expander: typing.ClassVar['EquipmentEnum'] = ...
    SimpleTEGAbsorber: typing.ClassVar['EquipmentEnum'] = ...
    Tank: typing.ClassVar['EquipmentEnum'] = ...
    ComponentSplitter: typing.ClassVar['EquipmentEnum'] = ...
    ReservoirCVDsim: typing.ClassVar['EquipmentEnum'] = ...
    ReservoirDiffLibsim: typing.ClassVar['EquipmentEnum'] = ...
    VirtualStream: typing.ClassVar['EquipmentEnum'] = ...
    ReservoirTPsim: typing.ClassVar['EquipmentEnum'] = ...
    SimpleReservoir: typing.ClassVar['EquipmentEnum'] = ...
    Manifold: typing.ClassVar['EquipmentEnum'] = ...
    Flare: typing.ClassVar['EquipmentEnum'] = ...
    def toString(self) -> java.lang.String: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'EquipmentEnum': ...
    @staticmethod
    def values() -> typing.MutableSequence['EquipmentEnum']: ...

class EquipmentFactory:
    def __init__(self): ...
    @staticmethod
    def createEquipment(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> 'ProcessEquipmentInterface': ...

class ProcessEquipmentInterface(jneqsim.neqsim.process.SimulationInterface):
    def displayResult(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getConditionAnalysisMessage(self) -> java.lang.String: ...
    def getController(self) -> jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    def getFluid(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getMassBalance(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign: ...
    @typing.overload
    def getPressure(self) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getReport_json(self) -> java.lang.String: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSpecification(self) -> java.lang.String: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def hashCode(self) -> int: ...
    def initMechanicalDesign(self) -> None: ...
    def needRecalculation(self) -> bool: ...
    def reportResults(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def runConditionAnalysis(self, processEquipmentInterface: 'ProcessEquipmentInterface') -> None: ...
    def setController(self, controllerDeviceInterface: jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setRegulatorOutSignal(self, double: float) -> None: ...
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTemperature(self, double: float) -> None: ...
    def toJson(self) -> java.lang.String: ...

class TwoPortInterface:
    def getInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInletPressure(self) -> float: ...
    def getInletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInletTemperature(self) -> float: ...
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutletPressure(self) -> float: ...
    def getOutletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutletTemperature(self) -> float: ...
    def setInletPressure(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setInletTemperature(self, double: float) -> None: ...
    def setOutletPressure(self, double: float) -> None: ...
    def setOutletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setOutletTemperature(self, double: float) -> None: ...

class ProcessEquipmentBaseClass(jneqsim.neqsim.process.SimulationBaseClass, ProcessEquipmentInterface):
    hasController: bool = ...
    report: typing.MutableSequence[typing.MutableSequence[java.lang.String]] = ...
    properties: java.util.HashMap = ...
    energyStream: jneqsim.neqsim.process.equipment.stream.EnergyStream = ...
    conditionAnalysisMessage: java.lang.String = ...
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def copy(self) -> ProcessEquipmentInterface: ...
    def displayResult(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getConditionAnalysisMessage(self) -> java.lang.String: ...
    def getController(self) -> jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface: ...
    def getEnergyStream(self) -> jneqsim.neqsim.process.equipment.stream.EnergyStream: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    def getMassBalance(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign: ...
    def getMinimumFlow(self) -> float: ...
    @typing.overload
    def getPressure(self) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getProperty(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def getReport_json(self) -> java.lang.String: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSpecification(self) -> java.lang.String: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def hashCode(self) -> int: ...
    def initMechanicalDesign(self) -> None: ...
    @typing.overload
    def isActive(self) -> bool: ...
    @typing.overload
    def isActive(self, boolean: bool) -> None: ...
    def isSetEnergyStream(self) -> bool: ...
    def reportResults(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def runConditionAnalysis(self, processEquipmentInterface: ProcessEquipmentInterface) -> None: ...
    @typing.overload
    def run_step(self) -> None: ...
    @typing.overload
    def run_step(self, uUID: java.util.UUID) -> None: ...
    def setController(self, controllerDeviceInterface: jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface) -> None: ...
    @typing.overload
    def setEnergyStream(self, boolean: bool) -> None: ...
    @typing.overload
    def setEnergyStream(self, energyStream: jneqsim.neqsim.process.equipment.stream.EnergyStream) -> None: ...
    def setFlowValveController(self, controllerDeviceInterface: jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface) -> None: ...
    def setMinimumFlow(self, double: float) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setRegulatorOutSignal(self, double: float) -> None: ...
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTemperature(self, double: float) -> None: ...
    def solved(self) -> bool: ...
    def toJson(self) -> java.lang.String: ...

class TwoPortEquipment(ProcessEquipmentBaseClass, TwoPortInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getInletPressure(self) -> float: ...
    def getInletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInletTemperature(self) -> float: ...
    def getOutletPressure(self) -> float: ...
    def getOutletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutletTemperature(self) -> float: ...
    def setInletPressure(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setInletTemperature(self, double: float) -> None: ...
    def setOutletPressure(self, double: float) -> None: ...
    def setOutletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setOutletTemperature(self, double: float) -> None: ...
    def toJson(self) -> java.lang.String: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment")``.

    EquipmentEnum: typing.Type[EquipmentEnum]
    EquipmentFactory: typing.Type[EquipmentFactory]
    ProcessEquipmentBaseClass: typing.Type[ProcessEquipmentBaseClass]
    ProcessEquipmentInterface: typing.Type[ProcessEquipmentInterface]
    TwoPortEquipment: typing.Type[TwoPortEquipment]
    TwoPortInterface: typing.Type[TwoPortInterface]
    absorber: jneqsim.neqsim.process.equipment.absorber.__module_protocol__
    adsorber: jneqsim.neqsim.process.equipment.adsorber.__module_protocol__
    compressor: jneqsim.neqsim.process.equipment.compressor.__module_protocol__
    diffpressure: jneqsim.neqsim.process.equipment.diffpressure.__module_protocol__
    distillation: jneqsim.neqsim.process.equipment.distillation.__module_protocol__
    ejector: jneqsim.neqsim.process.equipment.ejector.__module_protocol__
    expander: jneqsim.neqsim.process.equipment.expander.__module_protocol__
    filter: jneqsim.neqsim.process.equipment.filter.__module_protocol__
    flare: jneqsim.neqsim.process.equipment.flare.__module_protocol__
    heatexchanger: jneqsim.neqsim.process.equipment.heatexchanger.__module_protocol__
    manifold: jneqsim.neqsim.process.equipment.manifold.__module_protocol__
    membrane: jneqsim.neqsim.process.equipment.membrane.__module_protocol__
    mixer: jneqsim.neqsim.process.equipment.mixer.__module_protocol__
    pipeline: jneqsim.neqsim.process.equipment.pipeline.__module_protocol__
    powergeneration: jneqsim.neqsim.process.equipment.powergeneration.__module_protocol__
    pump: jneqsim.neqsim.process.equipment.pump.__module_protocol__
    reactor: jneqsim.neqsim.process.equipment.reactor.__module_protocol__
    reservoir: jneqsim.neqsim.process.equipment.reservoir.__module_protocol__
    separator: jneqsim.neqsim.process.equipment.separator.__module_protocol__
    splitter: jneqsim.neqsim.process.equipment.splitter.__module_protocol__
    stream: jneqsim.neqsim.process.equipment.stream.__module_protocol__
    subsea: jneqsim.neqsim.process.equipment.subsea.__module_protocol__
    tank: jneqsim.neqsim.process.equipment.tank.__module_protocol__
    util: jneqsim.neqsim.process.equipment.util.__module_protocol__
    valve: jneqsim.neqsim.process.equipment.valve.__module_protocol__
