
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.mixer
import jneqsim.neqsim.process.equipment.stream
import typing



class DistillationInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def setNumberOfTrays(self, int: int) -> None: ...

class TrayInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface):
    def addStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def setHeatInput(self, double: float) -> None: ...

class DistillationColumn(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass, DistillationInterface):
    def __init__(self, string: typing.Union[java.lang.String, str], int: int, boolean: bool, boolean2: bool): ...
    def addFeedStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, int: int) -> None: ...
    def componentMassBalanceCheck(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def displayResult(self) -> None: ...
    def energyBalanceCheck(self) -> None: ...
    def getCondenser(self) -> 'Condenser': ...
    def getCondenserTemperature(self) -> float: ...
    def getEnergyBalanceError(self) -> float: ...
    def getEnthalpyBalanceTolerance(self) -> float: ...
    def getFsFactor(self) -> float: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInternalDiameter(self) -> float: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getMassBalanceError(self) -> float: ...
    def getMassBalanceTolerance(self) -> float: ...
    def getNumerOfTrays(self) -> int: ...
    def getReboiler(self) -> 'Reboiler': ...
    def getReboilerTemperature(self) -> float: ...
    def getTemperatureTolerance(self) -> float: ...
    def getTray(self, int: int) -> 'SimpleTray': ...
    def init(self) -> None: ...
    def isDoInitializion(self) -> bool: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def massBalanceCheck(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runBroyden(self, uUID: java.util.UUID) -> None: ...
    def setBottomPressure(self, double: float) -> None: ...
    def setCondenserTemperature(self, double: float) -> None: ...
    def setDoInitializion(self, boolean: bool) -> None: ...
    def setEnthalpyBalanceTolerance(self, double: float) -> None: ...
    def setInternalDiameter(self, double: float) -> None: ...
    def setMassBalanceTolerance(self, double: float) -> None: ...
    def setMaxNumberOfIterations(self, int: int) -> None: ...
    def setNumberOfTrays(self, int: int) -> None: ...
    def setReboilerTemperature(self, double: float) -> None: ...
    def setTemperatureTolerance(self, double: float) -> None: ...
    def setTopCondenserDuty(self, double: float) -> None: ...
    def setTopPressure(self, double: float) -> None: ...
    def solved(self) -> bool: ...
    def toJson(self) -> java.lang.String: ...

class SimpleTray(jneqsim.neqsim.process.equipment.mixer.Mixer, TrayInterface):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def TPflash(self) -> None: ...
    def calcMixStreamEnthalpy(self) -> float: ...
    def calcMixStreamEnthalpy0(self) -> float: ...
    def getFeedRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    def getVaporFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def guessTemperature(self) -> float: ...
    def init(self) -> None: ...
    def massBalance(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def run2(self) -> None: ...
    def setHeatInput(self, double: float) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setTemperature(self, double: float) -> None: ...

class Condenser(SimpleTray):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def getDuty(self) -> float: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidProductStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getProductOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getRefluxRatio(self) -> float: ...
    def isSeparation_with_liquid_reflux(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setRefluxRatio(self, double: float) -> None: ...
    def setSeparation_with_liquid_reflux(self, boolean: bool, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTotalCondenser(self, boolean: bool) -> None: ...

class Reboiler(SimpleTray):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def getDuty(self) -> float: ...
    def getRefluxRatio(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setRefluxRatio(self, double: float) -> None: ...

class VLSolidTray(SimpleTray):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def calcMixStreamEnthalpy(self) -> float: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    def init(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setHeatInput(self, double: float) -> None: ...
    def setTemperature(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.distillation")``.

    Condenser: typing.Type[Condenser]
    DistillationColumn: typing.Type[DistillationColumn]
    DistillationInterface: typing.Type[DistillationInterface]
    Reboiler: typing.Type[Reboiler]
    SimpleTray: typing.Type[SimpleTray]
    TrayInterface: typing.Type[TrayInterface]
    VLSolidTray: typing.Type[VLSolidTray]
