
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import typing



class HeaterInterface(jneqsim.neqsim.process.SimulationInterface):
    def setOutPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setOutTP(self, double: float, double2: float) -> None: ...
    def setOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setdT(self, double: float) -> None: ...

class MultiStreamHeatExchangerInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface):
    def addInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcThermalEffectiveness(self, double: float, double2: float) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getDeltaT(self) -> float: ...
    def getDuty(self) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFlowArrangement(self) -> java.lang.String: ...
    def getGuessOutTemperature(self) -> float: ...
    def getHotColdDutyBalance(self) -> float: ...
    def getInStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInTemperature(self, int: int) -> float: ...
    def getMassBalance(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getOutStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutTemperature(self, int: int) -> float: ...
    def getThermalEffectiveness(self) -> float: ...
    def getUAvalue(self) -> float: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def runConditionAnalysis(self) -> None: ...
    @typing.overload
    def runConditionAnalysis(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    def setDeltaT(self, double: float) -> None: ...
    def setFeedStream(self, int: int, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setFlowArrangement(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setGuessOutTemperature(self, double: float) -> None: ...
    @typing.overload
    def setGuessOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setHotColdDutyBalance(self, double: float) -> None: ...
    def setOutTemperature(self, double: float) -> None: ...
    def setThermalEffectiveness(self, double: float) -> None: ...
    def setUAvalue(self, double: float) -> None: ...
    def setUseDeltaT(self, boolean: bool) -> None: ...
    def setdT(self, double: float) -> None: ...
    def toJson(self) -> java.lang.String: ...

class ReBoiler(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getReboilerDuty(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setReboilerDuty(self, double: float) -> None: ...

class HeatExchangerInterface(HeaterInterface):
    def getOutStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...

class Heater(jneqsim.neqsim.process.equipment.TwoPortEquipment, HeaterInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getDuty(self) -> float: ...
    @typing.overload
    def getDuty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEnergyInput(self) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    def getPressureDrop(self) -> float: ...
    def isSetEnergyInput(self) -> bool: ...
    def needRecalculation(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setDuty(self, double: float) -> None: ...
    def setEnergyInput(self, double: float) -> None: ...
    @typing.overload
    def setOutPressure(self, double: float) -> None: ...
    @typing.overload
    def setOutPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setOutStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setOutTP(self, double: float, double2: float) -> None: ...
    @typing.overload
    def setOutTemperature(self, double: float) -> None: ...
    @typing.overload
    def setOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressureDrop(self, double: float) -> None: ...
    def setSetEnergyInput(self, boolean: bool) -> None: ...
    def setdT(self, double: float) -> None: ...
    def toJson(self) -> java.lang.String: ...

class Cooler(Heater):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def toJson(self) -> java.lang.String: ...

class HeatExchanger(Heater, HeatExchangerInterface):
    guessOutTemperature: float = ...
    guessOutTemperatureUnit: java.lang.String = ...
    thermalEffectiveness: float = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def addInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcThermalEffectivenes(self, double: float, double2: float) -> float: ...
    def displayResult(self) -> None: ...
    def getDeltaT(self) -> float: ...
    @typing.overload
    def getDuty(self) -> float: ...
    @typing.overload
    def getDuty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFlowArrangement(self) -> java.lang.String: ...
    def getGuessOutTemperature(self) -> float: ...
    def getHotColdDutyBalance(self) -> float: ...
    @typing.overload
    def getInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getInStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInTemperature(self, int: int) -> float: ...
    def getMassBalance(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getOutStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutTemperature(self, int: int) -> float: ...
    def getThermalEffectiveness(self) -> float: ...
    def getUAvalue(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runConditionAnalysis(self) -> None: ...
    @typing.overload
    def runConditionAnalysis(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    def runDeltaT(self, uUID: java.util.UUID) -> None: ...
    def runSpecifiedStream(self, uUID: java.util.UUID) -> None: ...
    def setDeltaT(self, double: float) -> None: ...
    def setFeedStream(self, int: int, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setFlowArrangement(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setGuessOutTemperature(self, double: float) -> None: ...
    @typing.overload
    def setGuessOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setHotColdDutyBalance(self, double: float) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setOutStream(self, int: int, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    @typing.overload
    def setOutStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    @typing.overload
    def setOutTemperature(self, double: float) -> None: ...
    @typing.overload
    def setOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThermalEffectiveness(self, double: float) -> None: ...
    def setUAvalue(self, double: float) -> None: ...
    def setUseDeltaT(self, boolean: bool) -> None: ...
    def setdT(self, double: float) -> None: ...
    def toJson(self) -> java.lang.String: ...

class MultiStreamHeatExchanger(Heater, MultiStreamHeatExchangerInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], list: java.util.List[jneqsim.neqsim.process.equipment.stream.StreamInterface]): ...
    def addInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcThermalEffectiveness(self, double: float, double2: float) -> float: ...
    def displayResult(self) -> None: ...
    def getDeltaT(self) -> float: ...
    @typing.overload
    def getDuty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDuty(self) -> float: ...
    @typing.overload
    def getDuty(self, int: int) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFlowArrangement(self) -> java.lang.String: ...
    def getGuessOutTemperature(self) -> float: ...
    def getHotColdDutyBalance(self) -> float: ...
    @typing.overload
    def getInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getInStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInTemperature(self, int: int) -> float: ...
    def getMassBalance(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getOutStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutTemperature(self, int: int) -> float: ...
    def getTemperatureApproach(self) -> float: ...
    def getThermalEffectiveness(self) -> float: ...
    def getUAvalue(self) -> float: ...
    def numerOfFeedStreams(self) -> int: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runConditionAnalysis(self) -> None: ...
    @typing.overload
    def runConditionAnalysis(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    def runSpecifiedStream(self, uUID: java.util.UUID) -> None: ...
    def setDeltaT(self, double: float) -> None: ...
    def setFeedStream(self, int: int, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setFlowArrangement(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setGuessOutTemperature(self, double: float) -> None: ...
    @typing.overload
    def setGuessOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setHotColdDutyBalance(self, double: float) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setOutTemperature(self, double: float) -> None: ...
    def setTemperatureApproach(self, double: float) -> None: ...
    def setThermalEffectiveness(self, double: float) -> None: ...
    def setUAvalue(self, double: float) -> None: ...
    def setUseDeltaT(self, boolean: bool) -> None: ...
    def setdT(self, double: float) -> None: ...
    def toJson(self) -> java.lang.String: ...

class MultiStreamHeatExchanger2(Heater, MultiStreamHeatExchangerInterface):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def addInStreamMSHE(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def calcThermalEffectiveness(self, double: float, double2: float) -> float: ...
    def calculateUA(self) -> float: ...
    def compositeCurve(self) -> java.util.Map[java.lang.String, java.util.List[java.util.Map[java.lang.String, typing.Any]]]: ...
    def displayResult(self) -> None: ...
    def energyDiff(self) -> float: ...
    def getCompositeCurve(self) -> java.util.Map[java.lang.String, java.util.List[java.util.Map[java.lang.String, typing.Any]]]: ...
    def getDeltaT(self) -> float: ...
    @typing.overload
    def getDuty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDuty(self) -> float: ...
    def getFlowArrangement(self) -> java.lang.String: ...
    def getGuessOutTemperature(self) -> float: ...
    def getHotColdDutyBalance(self) -> float: ...
    @typing.overload
    def getInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getInStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInTemperature(self, int: int) -> float: ...
    @typing.overload
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getOutStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutTemperature(self, int: int) -> float: ...
    def getTemperatureApproach(self) -> float: ...
    def getThermalEffectiveness(self) -> float: ...
    def getUA(self) -> float: ...
    def getUAvalue(self) -> float: ...
    def oneUnknown(self) -> None: ...
    def pinch(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runConditionAnalysis(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    @typing.overload
    def runConditionAnalysis(self) -> None: ...
    def setDeltaT(self, double: float) -> None: ...
    def setFeedStream(self, int: int, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setFlowArrangement(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setGuessOutTemperature(self, double: float) -> None: ...
    @typing.overload
    def setGuessOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setHotColdDutyBalance(self, double: float) -> None: ...
    def setTemperatureApproach(self, double: float) -> None: ...
    def setThermalEffectiveness(self, double: float) -> None: ...
    def setUAvalue(self, double: float) -> None: ...
    def setUseDeltaT(self, boolean: bool) -> None: ...
    def threeUnknowns(self) -> None: ...
    def toJson(self) -> java.lang.String: ...
    def twoUnknowns(self) -> None: ...

class NeqHeater(Heater):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def setOutTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setOutTemperature(self, double: float) -> None: ...

class SteamHeater(Heater):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getSteamFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setSteamInletTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSteamOutletTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSteamPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...

class AirCooler(Cooler):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getAirMassFlow(self) -> float: ...
    def getAirVolumeFlow(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setAirInletTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setAirOutletTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setRelativeHumidity(self, double: float) -> None: ...

class WaterCooler(Cooler):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getCoolingWaterFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setWaterInletTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setWaterOutletTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setWaterPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.heatexchanger")``.

    AirCooler: typing.Type[AirCooler]
    Cooler: typing.Type[Cooler]
    HeatExchanger: typing.Type[HeatExchanger]
    HeatExchangerInterface: typing.Type[HeatExchangerInterface]
    Heater: typing.Type[Heater]
    HeaterInterface: typing.Type[HeaterInterface]
    MultiStreamHeatExchanger: typing.Type[MultiStreamHeatExchanger]
    MultiStreamHeatExchanger2: typing.Type[MultiStreamHeatExchanger2]
    MultiStreamHeatExchangerInterface: typing.Type[MultiStreamHeatExchangerInterface]
    NeqHeater: typing.Type[NeqHeater]
    ReBoiler: typing.Type[ReBoiler]
    SteamHeater: typing.Type[SteamHeater]
    WaterCooler: typing.Type[WaterCooler]
