
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.compressor
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.thermo.system
import typing



class PumpChartInterface(java.lang.Cloneable):
    def addCurve(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def getEfficiency(self, double: float, double2: float) -> float: ...
    def getHead(self, double: float, double2: float) -> float: ...
    def getHeadUnit(self) -> java.lang.String: ...
    def getSpeed(self, double: float, double2: float) -> int: ...
    def isUsePumpChart(self) -> bool: ...
    def plot(self) -> None: ...
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setHeadUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferenceConditions(self, double: float, double2: float, double3: float, double4: float) -> None: ...
    def setUsePumpChart(self, boolean: bool) -> None: ...
    def setUseRealKappa(self, boolean: bool) -> None: ...
    def useRealKappa(self) -> bool: ...

class PumpCurve(java.io.Serializable):
    flow: typing.MutableSequence[float] = ...
    head: typing.MutableSequence[float] = ...
    efficiency: typing.MutableSequence[float] = ...
    speed: float = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]): ...

class PumpInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, jneqsim.neqsim.process.equipment.TwoPortInterface):
    def equals(self, object: typing.Any) -> bool: ...
    def getEnergy(self) -> float: ...
    def getPower(self) -> float: ...
    def hashCode(self) -> int: ...
    def setPumpChartType(self, string: typing.Union[java.lang.String, str]) -> None: ...

class Pump(jneqsim.neqsim.process.equipment.TwoPortEquipment, PumpInterface):
    isentropicEfficiency: float = ...
    powerSet: bool = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def calculateAsCompressor(self, boolean: bool) -> None: ...
    def displayResult(self) -> None: ...
    def getDuty(self) -> float: ...
    def getEnergy(self) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getIsentropicEfficiency(self) -> float: ...
    def getMinimumFlow(self) -> float: ...
    def getMolarFlow(self) -> float: ...
    def getOutTemperature(self) -> float: ...
    @typing.overload
    def getPower(self) -> float: ...
    @typing.overload
    def getPower(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getPumpChart(self) -> PumpChartInterface: ...
    def getSpeed(self) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setIsentropicEfficiency(self, double: float) -> None: ...
    def setMinimumFlow(self, double: float) -> None: ...
    def setMolarFlow(self, double: float) -> None: ...
    def setOutTemperature(self, double: float) -> None: ...
    @typing.overload
    def setOutletPressure(self, double: float) -> None: ...
    @typing.overload
    def setOutletPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPumpChartType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSpeed(self, double: float) -> None: ...
    def toJson(self) -> java.lang.String: ...

class PumpChart(PumpChartInterface, java.io.Serializable):
    def __init__(self): ...
    def addCurve(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def checkStoneWall(self, double: float, double2: float) -> bool: ...
    def checkSurge1(self, double: float, double2: float) -> bool: ...
    def checkSurge2(self, double: float, double2: float) -> bool: ...
    def efficiency(self, double: float, double2: float) -> float: ...
    def fitReducedCurve(self) -> None: ...
    def getEfficiency(self, double: float, double2: float) -> float: ...
    def getHead(self, double: float, double2: float) -> float: ...
    def getHeadUnit(self) -> java.lang.String: ...
    def getSpeed(self, double: float, double2: float) -> int: ...
    def isUsePumpChart(self) -> bool: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def plot(self) -> None: ...
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setHeadUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferenceConditions(self, double: float, double2: float, double3: float, double4: float) -> None: ...
    def setUsePumpChart(self, boolean: bool) -> None: ...
    def setUseRealKappa(self, boolean: bool) -> None: ...
    def useRealKappa(self) -> bool: ...

class PumpChartAlternativeMapLookupExtrapolate(jneqsim.neqsim.process.equipment.compressor.CompressorChartAlternativeMapLookupExtrapolate, PumpChartInterface):
    def __init__(self): ...
    def getEfficiency(self, double: float, double2: float) -> float: ...
    def getHead(self, double: float, double2: float) -> float: ...
    def isUsePumpChart(self) -> bool: ...
    def setUsePumpChart(self, boolean: bool) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.pump")``.

    Pump: typing.Type[Pump]
    PumpChart: typing.Type[PumpChart]
    PumpChartAlternativeMapLookupExtrapolate: typing.Type[PumpChartAlternativeMapLookupExtrapolate]
    PumpChartInterface: typing.Type[PumpChartInterface]
    PumpCurve: typing.Type[PumpCurve]
    PumpInterface: typing.Type[PumpInterface]
