
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import typing



class GibbsReactor(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def calculateMixtureEnthalpy(self, list: java.util.List[typing.Union[java.lang.String, str]], list2: java.util.List[float], double: float, map: typing.Union[java.util.Map[typing.Union[java.lang.String, str], 'GibbsReactor.GibbsComponent'], typing.Mapping[typing.Union[java.lang.String, str], 'GibbsReactor.GibbsComponent']]) -> float: ...
    @typing.overload
    def calculateMixtureEnthalpy(self, list: java.util.List[typing.Union[java.lang.String, str]], list2: java.util.List[float], map: typing.Union[java.util.Map[typing.Union[java.lang.String, str], 'GibbsReactor.GibbsComponent'], typing.Mapping[typing.Union[java.lang.String, str], 'GibbsReactor.GibbsComponent']], double: float) -> float: ...
    def calculateMixtureEnthalpyStandard(self, list: java.util.List[typing.Union[java.lang.String, str]], list2: java.util.List[float], map: typing.Union[java.util.Map[typing.Union[java.lang.String, str], 'GibbsReactor.GibbsComponent'], typing.Mapping[typing.Union[java.lang.String, str], 'GibbsReactor.GibbsComponent']]) -> float: ...
    def calculateMixtureGibbsEnergy(self, list: java.util.List[typing.Union[java.lang.String, str]], list2: java.util.List[float], map: typing.Union[java.util.Map[typing.Union[java.lang.String, str], 'GibbsReactor.GibbsComponent'], typing.Mapping[typing.Union[java.lang.String, str], 'GibbsReactor.GibbsComponent']], double: float) -> float: ...
    def getActualIterations(self) -> int: ...
    def getConvergenceTolerance(self) -> float: ...
    def getDampingComposition(self) -> float: ...
    def getDetailedMoleBalance(self) -> java.util.Map[java.lang.String, java.util.Map[java.lang.String, float]]: ...
    def getElementMoleBalanceDiff(self) -> typing.MutableSequence[float]: ...
    def getElementMoleBalanceIn(self) -> typing.MutableSequence[float]: ...
    def getElementMoleBalanceOut(self) -> typing.MutableSequence[float]: ...
    def getElementNames(self) -> typing.MutableSequence[java.lang.String]: ...
    def getEnergyMode(self) -> 'GibbsReactor.EnergyMode': ...
    def getEnthalpyOfReactions(self) -> float: ...
    def getFinalConvergenceError(self) -> float: ...
    def getFugacityCoefficient(self, object: typing.Any) -> typing.MutableSequence[float]: ...
    def getInletMole(self) -> java.util.List[float]: ...
    def getInletMoles(self) -> java.util.List[float]: ...
    def getJacobianColLabels(self) -> java.util.List[java.lang.String]: ...
    def getJacobianInverse(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getJacobianMatrix(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getJacobianRowLabels(self) -> java.util.List[java.lang.String]: ...
    def getLagrangeContributions(self) -> java.util.Map[java.lang.String, float]: ...
    def getLagrangeMultiplierContributions(self) -> java.util.Map[java.lang.String, java.util.Map[java.lang.String, float]]: ...
    def getLagrangianMultipliers(self) -> typing.MutableSequence[float]: ...
    def getMassBalanceConverged(self) -> bool: ...
    def getMassBalanceError(self) -> float: ...
    def getMaxIterations(self) -> int: ...
    def getMethod(self) -> java.lang.String: ...
    def getMixtureEnthalpy(self) -> float: ...
    def getMixtureGibbsEnergy(self) -> float: ...
    def getObjectiveFunctionValues(self) -> java.util.Map[java.lang.String, float]: ...
    def getObjectiveMinimizationVector(self) -> typing.MutableSequence[float]: ...
    def getObjectiveMinimizationVectorLabels(self) -> java.util.List[java.lang.String]: ...
    def getOutletMole(self) -> java.util.List[float]: ...
    def getOutletMoles(self) -> java.util.List[float]: ...
    @typing.overload
    def getPower(self) -> float: ...
    @typing.overload
    def getPower(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTemperatureChange(self) -> float: ...
    def getUseAllDatabaseSpecies(self) -> bool: ...
    def hasConverged(self) -> bool: ...
    def performIterationUpdate(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], double2: float) -> bool: ...
    def performNewtonRaphsonIteration(self) -> typing.MutableSequence[float]: ...
    def printDatabaseComponents(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setConvergenceTolerance(self, double: float) -> None: ...
    def setDampingComposition(self, double: float) -> None: ...
    @typing.overload
    def setEnergyMode(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setEnergyMode(self, energyMode: 'GibbsReactor.EnergyMode') -> None: ...
    def setLagrangeMultiplier(self, int: int, double: float) -> None: ...
    def setMaxIterations(self, int: int) -> None: ...
    def setMethod(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setUseAllDatabaseSpecies(self, boolean: bool) -> None: ...
    @typing.overload
    def solveGibbsEquilibrium(self) -> bool: ...
    @typing.overload
    def solveGibbsEquilibrium(self, double: float) -> bool: ...
    def verifyJacobianInverse(self) -> bool: ...
    class EnergyMode(java.lang.Enum['GibbsReactor.EnergyMode']):
        ISOTHERMAL: typing.ClassVar['GibbsReactor.EnergyMode'] = ...
        ADIABATIC: typing.ClassVar['GibbsReactor.EnergyMode'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: typing.Union[java.lang.String, str]) -> 'GibbsReactor.EnergyMode': ...
        @staticmethod
        def values() -> typing.MutableSequence['GibbsReactor.EnergyMode']: ...
    class GibbsComponent:
        def __init__(self, gibbsReactor: 'GibbsReactor', string: typing.Union[java.lang.String, str], doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], double3: float, double4: float, double5: float, double6: float, double7: float, double8: float, double9: float, double10: float, double11: float, double12: float, double13: float, double14: float, double15: float, double16: float, double17: float): ...
        def calculateEnthalpy(self, double: float, int: int) -> float: ...
        def calculateEntropy(self, double: float, int: int) -> float: ...
        def calculateGibbsEnergy(self, double: float, int: int) -> float: ...
        def calculateHeatCapacity(self, double: float, int: int) -> float: ...
        def getDeltaGf298(self) -> float: ...
        def getDeltaHf298(self) -> float: ...
        def getDeltaSf298(self) -> float: ...
        def getElements(self) -> typing.MutableSequence[float]: ...
        def getHeatCapacityCoeffs(self) -> typing.MutableSequence[float]: ...
        def getMolecule(self) -> java.lang.String: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.reactor")``.

    GibbsReactor: typing.Type[GibbsReactor]
