
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.separator.sectiontype
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.mechanicaldesign.separator
import jneqsim.neqsim.thermo.system
import typing



class SeparatorInterface(jneqsim.neqsim.process.SimulationInterface):
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def setInternalDiameter(self, double: float) -> None: ...
    def setLiquidLevel(self, double: float) -> None: ...

class Separator(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass, SeparatorInterface):
    numberOfInputStreams: int = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def addSeparatorSection(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def addStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def displayResult(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def getDeRatedGasLoadFactor(self) -> float: ...
    @typing.overload
    def getDeRatedGasLoadFactor(self, int: int) -> float: ...
    def getDesignLiquidLevelFraction(self) -> float: ...
    def getEfficiency(self) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    def getFeedStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getGas(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getGasCarryunderFraction(self) -> float: ...
    @typing.overload
    def getGasLoadFactor(self) -> float: ...
    @typing.overload
    def getGasLoadFactor(self, int: int) -> float: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getGasSuperficialVelocity(self) -> float: ...
    def getInternalDiameter(self) -> float: ...
    def getLiquid(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidCarryoverFraction(self) -> float: ...
    def getLiquidLevel(self) -> float: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getMassBalance(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.SeparatorMechanicalDesign: ...
    def getOrientation(self) -> java.lang.String: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getPressure(self) -> float: ...
    def getPressureDrop(self) -> float: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSeparatorLength(self) -> float: ...
    @typing.overload
    def getSeparatorSection(self, int: int) -> jneqsim.neqsim.process.equipment.separator.sectiontype.SeparatorSection: ...
    @typing.overload
    def getSeparatorSection(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.separator.sectiontype.SeparatorSection: ...
    def getSeparatorSections(self) -> java.util.ArrayList[jneqsim.neqsim.process.equipment.separator.sectiontype.SeparatorSection]: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def hashCode(self) -> int: ...
    def initMechanicalDesign(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setDesignLiquidLevelFraction(self, double: float) -> None: ...
    def setEfficiency(self, double: float) -> None: ...
    def setGasCarryunderFraction(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setInternalDiameter(self, double: float) -> None: ...
    def setLiquidCarryoverFraction(self, double: float) -> None: ...
    def setLiquidLevel(self, double: float) -> None: ...
    def setOrientation(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressureDrop(self, double: float) -> None: ...
    def setSeparatorLength(self, double: float) -> None: ...
    def setTempPres(self, double: float, double2: float) -> None: ...
    def toJson(self) -> java.lang.String: ...

class GasScrubber(Separator):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.GasScrubberMechanicalDesign: ...

class GasScrubberSimple(Separator):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def calcLiquidCarryoverFraction(self) -> float: ...
    def getGas(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquid(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.GasScrubberMechanicalDesign: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...

class Hydrocyclone(Separator):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getOilOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getWaterOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...

class NeqGasScrubber(Separator):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def addScrubberSection(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def displayResult(self) -> None: ...
    def getGas(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquid(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.GasScrubberMechanicalDesign: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...

class ThreePhaseSeparator(Separator):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    def getOilOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getWaterOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setEntrainment(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str]) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def toJson(self) -> java.lang.String: ...

class TwoPhaseSeparator(Separator):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.separator")``.

    GasScrubber: typing.Type[GasScrubber]
    GasScrubberSimple: typing.Type[GasScrubberSimple]
    Hydrocyclone: typing.Type[Hydrocyclone]
    NeqGasScrubber: typing.Type[NeqGasScrubber]
    Separator: typing.Type[Separator]
    SeparatorInterface: typing.Type[SeparatorInterface]
    ThreePhaseSeparator: typing.Type[ThreePhaseSeparator]
    TwoPhaseSeparator: typing.Type[TwoPhaseSeparator]
    sectiontype: jneqsim.neqsim.process.equipment.separator.sectiontype.__module_protocol__
