
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jneqsim.neqsim.process.equipment.separator
import jneqsim.neqsim.process.mechanicaldesign.separator.sectiontype
import jneqsim.neqsim.util
import typing



class SeparatorSection(jneqsim.neqsim.util.NamedBaseClass):
    separator: jneqsim.neqsim.process.equipment.separator.Separator = ...
    outerDiameter: float = ...
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    def calcEfficiency(self) -> float: ...
    def getEfficiency(self) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.sectiontype.SepDesignSection: ...
    def getMinimumLiquidSealHeight(self) -> float: ...
    def getOuterDiameter(self) -> float: ...
    def getPressureDrop(self) -> float: ...
    def getSeparator(self) -> jneqsim.neqsim.process.equipment.separator.Separator: ...
    def isCalcEfficiency(self) -> bool: ...
    def setCalcEfficiency(self, boolean: bool) -> None: ...
    def setEfficiency(self, double: float) -> None: ...
    def setOuterDiameter(self, double: float) -> None: ...
    def setPressureDrop(self, double: float) -> None: ...
    def setSeparator(self, separator: jneqsim.neqsim.process.equipment.separator.Separator) -> None: ...

class ManwaySection(SeparatorSection):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    def calcEfficiency(self) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.sectiontype.MechManwaySection: ...

class MeshSection(SeparatorSection):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    def calcEfficiency(self) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.sectiontype.MecMeshSection: ...

class NozzleSection(SeparatorSection):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    def calcEfficiency(self) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.sectiontype.MechNozzleSection: ...

class PackedSection(SeparatorSection):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    def calcEfficiency(self) -> float: ...

class ValveSection(SeparatorSection):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    def calcEfficiency(self) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.sectiontype.DistillationTraySection: ...

class VaneSection(SeparatorSection):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    def calcEfficiency(self) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.separator.sectiontype.MechVaneSection: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.separator.sectiontype")``.

    ManwaySection: typing.Type[ManwaySection]
    MeshSection: typing.Type[MeshSection]
    NozzleSection: typing.Type[NozzleSection]
    PackedSection: typing.Type[PackedSection]
    SeparatorSection: typing.Type[SeparatorSection]
    ValveSection: typing.Type[ValveSection]
    VaneSection: typing.Type[VaneSection]
