
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.standards.gasquality
import jneqsim.neqsim.thermo.system
import typing



class EnergyStream(java.io.Serializable, java.lang.Cloneable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def clone(self) -> 'EnergyStream': ...
    def equals(self, object: typing.Any) -> bool: ...
    def getDuty(self) -> float: ...
    def getName(self) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def setDuty(self, double: float) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...

class StreamInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface):
    def CCB(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def CCT(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def GCV(self) -> float: ...
    def LCV(self) -> float: ...
    def TVP(self, double: float, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def clone(self) -> 'StreamInterface': ...
    @typing.overload
    def clone(self, string: typing.Union[java.lang.String, str]) -> 'StreamInterface': ...
    def equals(self, object: typing.Any) -> bool: ...
    def flashStream(self) -> None: ...
    def getFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getGCV(self, string: typing.Union[java.lang.String, str], double: float, double2: float) -> float: ...
    def getHydrateEquilibriumTemperature(self) -> float: ...
    def getHydrocarbonDewPoint(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> float: ...
    def getISO6976(self, string: typing.Union[java.lang.String, str], double: float, double2: float) -> jneqsim.neqsim.standards.gasquality.Standard_ISO6976: ...
    def getMolarRate(self) -> float: ...
    @typing.overload
    def getPressure(self) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getRVP(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getRVP(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> float: ...
    def getTVP(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getWI(self, string: typing.Union[java.lang.String, str], double: float, double2: float) -> float: ...
    def hashCode(self) -> int: ...
    def runTPflash(self) -> None: ...
    def setEmptyThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFluid(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setThermoSystemFromPhase(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, string: typing.Union[java.lang.String, str]) -> None: ...

class VirtualStream(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: StreamInterface): ...
    def getOutStream(self) -> StreamInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setComposition(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], string: typing.Union[java.lang.String, str]) -> None: ...
    def setFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferenceStream(self, streamInterface: StreamInterface) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def solved(self) -> bool: ...

class Stream(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass, StreamInterface, java.lang.Cloneable):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: StreamInterface): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def CCB(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def CCT(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def GCV(self) -> float: ...
    def LCV(self) -> float: ...
    def TVP(self, double: float, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def clone(self) -> 'Stream': ...
    @typing.overload
    def clone(self, string: typing.Union[java.lang.String, str]) -> 'Stream': ...
    def displayResult(self) -> None: ...
    def flashStream(self) -> None: ...
    def getFluid(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getGCV(self, string: typing.Union[java.lang.String, str], double: float, double2: float) -> float: ...
    def getGasQuality(self) -> float: ...
    def getHydrateEquilibriumTemperature(self) -> float: ...
    def getHydrocarbonDewPoint(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> float: ...
    def getISO6976(self, string: typing.Union[java.lang.String, str], double: float, double2: float) -> jneqsim.neqsim.standards.gasquality.Standard_ISO6976: ...
    def getMolarRate(self) -> float: ...
    def getOutletStream(self) -> StreamInterface: ...
    @typing.overload
    def getProperty(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    @typing.overload
    def getProperty(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str]) -> typing.Any: ...
    @typing.overload
    def getRVP(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getRVP(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> float: ...
    def getReport(self) -> java.util.ArrayList[typing.MutableSequence[java.lang.String]]: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSolidFormationTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTVP(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getWI(self, string: typing.Union[java.lang.String, str], double: float, double2: float) -> float: ...
    def needRecalculation(self) -> bool: ...
    def phaseEnvelope(self) -> None: ...
    def reportResults(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runController(self, double: float, uUID: java.util.UUID) -> None: ...
    def runTPflash(self) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setEmptyThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFluid(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setGasQuality(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: StreamInterface) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setStream(self, streamInterface: StreamInterface) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setThermoSystemFromPhase(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, string: typing.Union[java.lang.String, str]) -> None: ...
    def toJson(self) -> java.lang.String: ...

class EquilibriumStream(Stream):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def clone(self) -> 'EquilibriumStream': ...
    @typing.overload
    def clone(self, string: typing.Union[java.lang.String, str]) -> 'EquilibriumStream': ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class IronIonSaturationStream(Stream):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: StreamInterface): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def clone(self) -> 'IronIonSaturationStream': ...
    @typing.overload
    def clone(self, string: typing.Union[java.lang.String, str]) -> 'IronIonSaturationStream': ...
    def displayResult(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class NeqStream(Stream):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: StreamInterface): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def clone(self) -> 'NeqStream': ...
    @typing.overload
    def clone(self, string: typing.Union[java.lang.String, str]) -> 'NeqStream': ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class ScalePotentialCheckStream(Stream):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: StreamInterface): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def clone(self) -> 'ScalePotentialCheckStream': ...
    @typing.overload
    def clone(self, string: typing.Union[java.lang.String, str]) -> 'ScalePotentialCheckStream': ...
    def displayResult(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.stream")``.

    EnergyStream: typing.Type[EnergyStream]
    EquilibriumStream: typing.Type[EquilibriumStream]
    IronIonSaturationStream: typing.Type[IronIonSaturationStream]
    NeqStream: typing.Type[NeqStream]
    ScalePotentialCheckStream: typing.Type[ScalePotentialCheckStream]
    Stream: typing.Type[Stream]
    StreamInterface: typing.Type[StreamInterface]
    VirtualStream: typing.Type[VirtualStream]
