
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.mixer
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.equipment.valve
import jneqsim.neqsim.process.processmodel
import jneqsim.neqsim.thermo.system
import typing



class Adjuster(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def displayResult(self) -> None: ...
    def getError(self) -> float: ...
    def getMaxAdjustedValue(self) -> float: ...
    def getMinAdjustedValue(self) -> float: ...
    def getTolerance(self) -> float: ...
    def isActivateWhenLess(self) -> bool: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setActivateWhenLess(self, boolean: bool) -> None: ...
    @typing.overload
    def setAdjustedVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setAdjustedVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setError(self, double: float) -> None: ...
    def setMaxAdjustedValue(self, double: float) -> None: ...
    def setMinAdjustedValue(self, double: float) -> None: ...
    @typing.overload
    def setTargetVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTargetVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTargetVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str]) -> None: ...
    def setTolerance(self, double: float) -> None: ...
    def solved(self) -> bool: ...

class Calculator(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    def getOutputVariable(self) -> jneqsim.neqsim.process.equipment.ProcessEquipmentInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runAntiSurgeCalc(self, uUID: java.util.UUID) -> None: ...
    def setOutputVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...

class FlowRateAdjuster(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    desiredGasFlow: float = ...
    desiredOilFlow: float = ...
    desiredWaterFlow: float = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def setAdjustedFlowRates(self, double: float, double2: float, double3: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setAdjustedFlowRates(self, double: float, double2: float, string: typing.Union[java.lang.String, str]) -> None: ...

class FlowSetter(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def createReferenceProcess(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> jneqsim.neqsim.process.processmodel.ProcessSystem: ...
    def getGasFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getOilFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getReferenceProcess(self) -> jneqsim.neqsim.process.processmodel.ProcessSystem: ...
    def getWaterFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setGasFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setOilFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSeparationPT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], string: typing.Union[java.lang.String, str], doubleArray2: typing.Union[typing.List[float], jpype.JArray], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setWaterFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...

class GORfitter(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getGFV(self) -> float: ...
    def getGOR(self) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getPressure(self) -> float: ...
    def getReferenceConditions(self) -> java.lang.String: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    def isFitAsGVF(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setFitAsGVF(self, boolean: bool) -> None: ...
    def setGOR(self, double: float) -> None: ...
    def setGVF(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferenceConditions(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...

class MPFMfitter(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getGFV(self) -> float: ...
    def getGOR(self) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getPressure(self) -> float: ...
    def getReferenceConditions(self) -> java.lang.String: ...
    def getReferenceFluidPackage(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    def isFitAsGVF(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setFitAsGVF(self, boolean: bool) -> None: ...
    def setGOR(self, double: float) -> None: ...
    def setGVF(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferenceConditions(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferenceFluidPackage(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...

class MoleFractionControllerUtil(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getMolesChange(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setComponentRate(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setMoleFraction(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def setRelativeMoleFractionReduction(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...

class NeqSimUnit(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    numberOfNodes: int = ...
    interfacialArea: float = ...
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    def getEquipment(self) -> java.lang.String: ...
    def getID(self) -> float: ...
    def getInterfacialArea(self) -> float: ...
    def getLength(self) -> float: ...
    def getNumberOfNodes(self) -> int: ...
    def getOuterTemperature(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runAnnular(self) -> None: ...
    def runDroplet(self) -> None: ...
    def runStratified(self) -> None: ...
    def setEquipment(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setID(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setLength(self, double: float) -> None: ...
    def setNumberOfNodes(self, int: int) -> None: ...
    def setOuterTemperature(self, double: float) -> None: ...

class PressureDrop(jneqsim.neqsim.process.equipment.valve.ThrottlingValve):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setPressureDrop(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...

class Recycle(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass, jneqsim.neqsim.process.equipment.mixer.MixerInterface):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcMixStreamEnthalpy(self) -> float: ...
    def compositionBalanceCheck(self) -> float: ...
    def displayResult(self) -> None: ...
    def flowBalanceCheck(self) -> float: ...
    def getCompositionTolerance(self) -> float: ...
    def getDownstreamProperty(self) -> java.util.ArrayList[java.lang.String]: ...
    def getErrorComposition(self) -> float: ...
    def getErrorFlow(self) -> float: ...
    def getErrorPressure(self) -> float: ...
    def getErrorTemperature(self) -> float: ...
    def getFlowTolerance(self) -> float: ...
    def getMinimumFlow(self) -> float: ...
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getPriority(self) -> int: ...
    def getStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getTemperatureTolerance(self) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def guessTemperature(self) -> float: ...
    def initiateDownstreamProperties(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def mixStream(self) -> None: ...
    def pressureBalanceCheck(self) -> float: ...
    def removeInputStream(self, int: int) -> None: ...
    def replaceStream(self, int: int, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def resetIterations(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setCompositionTolerance(self, double: float) -> None: ...
    def setDownstreamProperties(self) -> None: ...
    @typing.overload
    def setDownstreamProperty(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setDownstreamProperty(self, arrayList: java.util.ArrayList[typing.Union[java.lang.String, str]]) -> None: ...
    def setErrorCompositon(self, double: float) -> None: ...
    def setErrorFlow(self, double: float) -> None: ...
    def setErrorPressure(self, double: float) -> None: ...
    def setErrorTemperature(self, double: float) -> None: ...
    def setFlowTolerance(self, double: float) -> None: ...
    def setMinimumFlow(self, double: float) -> None: ...
    def setOutletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setPriority(self, int: int) -> None: ...
    def setTemperature(self, double: float) -> None: ...
    def setTemperatureTolerance(self, double: float) -> None: ...
    def setTolerance(self, double: float) -> None: ...
    def solved(self) -> bool: ...
    def temperatureBalanceCheck(self) -> float: ...
    def toJson(self) -> java.lang.String: ...

class RecycleController(java.io.Serializable):
    def __init__(self): ...
    def addRecycle(self, recycle: Recycle) -> None: ...
    def clear(self) -> None: ...
    def doSolveRecycle(self, recycle: Recycle) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getCurrentPriorityLevel(self) -> int: ...
    def hasHigherPriorityLevel(self) -> bool: ...
    def hasLoverPriorityLevel(self) -> bool: ...
    def hashCode(self) -> int: ...
    def init(self) -> None: ...
    def isHighestPriority(self, recycle: Recycle) -> bool: ...
    def nextPriorityLevel(self) -> None: ...
    def resetPriorityLevel(self) -> None: ...
    def setCurrentPriorityLevel(self, int: int) -> None: ...
    def solvedAll(self) -> bool: ...
    def solvedCurrentPriorityLevel(self) -> bool: ...

class SetPoint(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string2: typing.Union[java.lang.String, str], processEquipmentInterface2: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface): ...
    def displayResult(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def setSourceVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    @typing.overload
    def setSourceVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTargetVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    @typing.overload
    def setTargetVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTargetVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTargetVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTargetVariable(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str]) -> None: ...

class Setter(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addParameter(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addTargetEquipment(self, list: java.util.List[jneqsim.neqsim.process.equipment.ProcessEquipmentInterface]) -> None: ...
    @typing.overload
    def addTargetEquipment(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    def getParameters(self) -> java.util.List[java.util.Map[java.lang.String, typing.Any]]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class StreamSaturatorUtil(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def isMultiPhase(self) -> bool: ...
    def needRecalculation(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setApprachToSaturation(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setMultiPhase(self, boolean: bool) -> None: ...

class StreamTransition(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.util")``.

    Adjuster: typing.Type[Adjuster]
    Calculator: typing.Type[Calculator]
    FlowRateAdjuster: typing.Type[FlowRateAdjuster]
    FlowSetter: typing.Type[FlowSetter]
    GORfitter: typing.Type[GORfitter]
    MPFMfitter: typing.Type[MPFMfitter]
    MoleFractionControllerUtil: typing.Type[MoleFractionControllerUtil]
    NeqSimUnit: typing.Type[NeqSimUnit]
    PressureDrop: typing.Type[PressureDrop]
    Recycle: typing.Type[Recycle]
    RecycleController: typing.Type[RecycleController]
    SetPoint: typing.Type[SetPoint]
    Setter: typing.Type[Setter]
    StreamSaturatorUtil: typing.Type[StreamSaturatorUtil]
    StreamTransition: typing.Type[StreamTransition]
