
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.mechanicaldesign.valve
import jneqsim.neqsim.thermo.system
import typing



class ValveInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, jneqsim.neqsim.process.equipment.TwoPortInterface):
    def equals(self, object: typing.Any) -> bool: ...
    def getCg(self) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getKv(self) -> float: ...
    def getPercentValveOpening(self) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def hashCode(self) -> int: ...
    def isIsoThermal(self) -> bool: ...
    @typing.overload
    def setCv(self, double: float) -> None: ...
    @typing.overload
    def setCv(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setIsoThermal(self, boolean: bool) -> None: ...
    def setKv(self, double: float) -> None: ...
    def setPercentValveOpening(self, double: float) -> None: ...

class ThrottlingValve(jneqsim.neqsim.process.equipment.TwoPortEquipment, ValveInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def calcKv(self) -> None: ...
    def calculateMolarFlow(self) -> float: ...
    def calculateOutletPressure(self, double: float) -> float: ...
    def displayResult(self) -> None: ...
    def getCg(self) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDeltaPressure(self) -> float: ...
    @typing.overload
    def getDeltaPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    def getFp(self) -> float: ...
    def getInletPressure(self) -> float: ...
    def getKv(self) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.valve.ValveMechanicalDesign: ...
    def getOutletPressure(self) -> float: ...
    def getPercentValveOpening(self) -> float: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def initMechanicalDesign(self) -> None: ...
    def isAcceptNegativeDP(self) -> bool: ...
    def isAllowChoked(self) -> bool: ...
    def isAllowLaminar(self) -> bool: ...
    def isGasValve(self) -> bool: ...
    def isIsoThermal(self) -> bool: ...
    def isValveKvSet(self) -> bool: ...
    def needRecalculation(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runController(self, double: float, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setAcceptNegativeDP(self, boolean: bool) -> None: ...
    def setAllowChoked(self, boolean: bool) -> None: ...
    def setAllowLaminar(self, boolean: bool) -> None: ...
    @typing.overload
    def setCv(self, double: float) -> None: ...
    @typing.overload
    def setCv(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDeltaPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFp(self, double: float) -> None: ...
    def setGasValve(self, boolean: bool) -> None: ...
    def setIsCalcOutPressure(self, boolean: bool) -> None: ...
    def setIsoThermal(self, boolean: bool) -> None: ...
    def setKv(self, double: float) -> None: ...
    def setMinimumValveOpening(self, double: float) -> None: ...
    @typing.overload
    def setOutletPressure(self, double: float) -> None: ...
    @typing.overload
    def setOutletPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPercentValveOpening(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setValveKvSet(self, boolean: bool) -> None: ...
    def toJson(self) -> java.lang.String: ...

class SafetyValve(ThrottlingValve):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getFullOpenPressure(self) -> float: ...
    def getPressureSpec(self) -> float: ...
    def setFullOpenPressure(self, double: float) -> None: ...
    def setPressureSpec(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.valve")``.

    SafetyValve: typing.Type[SafetyValve]
    ThrottlingValve: typing.Type[ThrottlingValve]
    ValveInterface: typing.Type[ValveInterface]
