
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jneqsim.neqsim.process.costestimation
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.mechanicaldesign.absorber
import jneqsim.neqsim.process.mechanicaldesign.adsorber
import jneqsim.neqsim.process.mechanicaldesign.compressor
import jneqsim.neqsim.process.mechanicaldesign.designstandards
import jneqsim.neqsim.process.mechanicaldesign.pipeline
import jneqsim.neqsim.process.mechanicaldesign.separator
import jneqsim.neqsim.process.mechanicaldesign.valve
import jneqsim.neqsim.process.processmodel
import typing



class MechanicalDesign(java.io.Serializable):
    maxDesignVolumeFlow: float = ...
    minDesignVolumeFLow: float = ...
    maxDesignGassVolumeFlow: float = ...
    minDesignGassVolumeFLow: float = ...
    maxDesignOilVolumeFlow: float = ...
    minDesignOilFLow: float = ...
    maxDesignWaterVolumeFlow: float = ...
    minDesignWaterVolumeFLow: float = ...
    innerDiameter: float = ...
    outerDiameter: float = ...
    wallThickness: float = ...
    tantanLength: float = ...
    weigthInternals: float = ...
    weightNozzle: float = ...
    weightPiping: float = ...
    weightElectroInstrument: float = ...
    weightStructualSteel: float = ...
    weightVessel: float = ...
    weigthVesselShell: float = ...
    moduleHeight: float = ...
    moduleWidth: float = ...
    moduleLength: float = ...
    designStandard: java.util.Hashtable = ...
    costEstimate: jneqsim.neqsim.process.costestimation.UnitCostEstimateBaseClass = ...
    def __init__(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface): ...
    def calcDesign(self) -> None: ...
    def displayResults(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getCompanySpecificDesignStandards(self) -> java.lang.String: ...
    def getConstrutionMaterial(self) -> java.lang.String: ...
    def getCorrosionAllowanse(self) -> float: ...
    def getCostEstimate(self) -> jneqsim.neqsim.process.costestimation.UnitCostEstimateBaseClass: ...
    def getDefaultLiquidDensity(self) -> float: ...
    def getDefaultLiquidViscosity(self) -> float: ...
    def getDesignStandard(self) -> java.util.Hashtable[java.lang.String, jneqsim.neqsim.process.mechanicaldesign.designstandards.DesignStandard]: ...
    def getInnerDiameter(self) -> float: ...
    def getJointEfficiency(self) -> float: ...
    def getMaterialDesignStandard(self) -> jneqsim.neqsim.process.mechanicaldesign.designstandards.MaterialPlateDesignStandard: ...
    def getMaterialPipeDesignStandard(self) -> jneqsim.neqsim.process.mechanicaldesign.designstandards.MaterialPipeDesignStandard: ...
    def getMaxAllowableStress(self) -> float: ...
    def getMaxDesignGassVolumeFlow(self) -> float: ...
    def getMaxDesignOilVolumeFlow(self) -> float: ...
    def getMaxDesignPressure(self) -> float: ...
    def getMaxDesignVolumeFlow(self) -> float: ...
    def getMaxDesignWaterVolumeFlow(self) -> float: ...
    def getMaxOperationPressure(self) -> float: ...
    def getMaxOperationTemperature(self) -> float: ...
    def getMinDesignGassVolumeFLow(self) -> float: ...
    def getMinDesignOilFLow(self) -> float: ...
    def getMinDesignPressure(self) -> float: ...
    def getMinDesignVolumeFLow(self) -> float: ...
    def getMinDesignWaterVolumeFLow(self) -> float: ...
    def getMinOperationPressure(self) -> float: ...
    def getMinOperationTemperature(self) -> float: ...
    def getModuleHeight(self) -> float: ...
    def getModuleLength(self) -> float: ...
    def getModuleWidth(self) -> float: ...
    def getOuterDiameter(self) -> float: ...
    def getPressureMarginFactor(self) -> float: ...
    def getProcessEquipment(self) -> jneqsim.neqsim.process.equipment.ProcessEquipmentInterface: ...
    def getTantanLength(self) -> float: ...
    def getTensileStrength(self) -> float: ...
    def getVolumeTotal(self) -> float: ...
    def getWallThickness(self) -> float: ...
    def getWeightElectroInstrument(self) -> float: ...
    def getWeightNozzle(self) -> float: ...
    def getWeightPiping(self) -> float: ...
    def getWeightStructualSteel(self) -> float: ...
    def getWeightTotal(self) -> float: ...
    def getWeightVessel(self) -> float: ...
    def getWeigthInternals(self) -> float: ...
    def getWeigthVesselShell(self) -> float: ...
    def hashCode(self) -> int: ...
    def isHasSetCompanySpecificDesignStandards(self) -> bool: ...
    def readDesignSpecifications(self) -> None: ...
    def setCompanySpecificDesignStandards(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setConstrutionMaterial(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCorrosionAllowanse(self, double: float) -> None: ...
    def setDefaultLiquidDensity(self, double: float) -> None: ...
    def setDefaultLiquidViscosity(self, double: float) -> None: ...
    def setDesign(self) -> None: ...
    def setDesignStandard(self, hashtable: java.util.Hashtable[typing.Union[java.lang.String, str], jneqsim.neqsim.process.mechanicaldesign.designstandards.DesignStandard]) -> None: ...
    def setHasSetCompanySpecificDesignStandards(self, boolean: bool) -> None: ...
    def setInnerDiameter(self, double: float) -> None: ...
    def setJointEfficiency(self, double: float) -> None: ...
    def setMaterialDesignStandard(self, materialPlateDesignStandard: jneqsim.neqsim.process.mechanicaldesign.designstandards.MaterialPlateDesignStandard) -> None: ...
    def setMaterialPipeDesignStandard(self, materialPipeDesignStandard: jneqsim.neqsim.process.mechanicaldesign.designstandards.MaterialPipeDesignStandard) -> None: ...
    def setMaxDesignGassVolumeFlow(self, double: float) -> None: ...
    def setMaxDesignOilVolumeFlow(self, double: float) -> None: ...
    def setMaxDesignVolumeFlow(self, double: float) -> None: ...
    def setMaxDesignWaterVolumeFlow(self, double: float) -> None: ...
    def setMaxOperationPressure(self, double: float) -> None: ...
    def setMaxOperationTemperature(self, double: float) -> None: ...
    def setMinDesignGassVolumeFLow(self, double: float) -> None: ...
    def setMinDesignOilFLow(self, double: float) -> None: ...
    def setMinDesignVolumeFLow(self, double: float) -> None: ...
    def setMinDesignWaterVolumeFLow(self, double: float) -> None: ...
    def setMinOperationPressure(self, double: float) -> None: ...
    def setMinOperationTemperature(self, double: float) -> None: ...
    def setModuleHeight(self, double: float) -> None: ...
    def setModuleLength(self, double: float) -> None: ...
    def setModuleWidth(self, double: float) -> None: ...
    def setOuterDiameter(self, double: float) -> None: ...
    def setPressureMarginFactor(self, double: float) -> None: ...
    def setProcessEquipment(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    def setTantanLength(self, double: float) -> None: ...
    def setTensileStrength(self, double: float) -> None: ...
    def setWallThickness(self, double: float) -> None: ...
    def setWeightElectroInstrument(self, double: float) -> None: ...
    def setWeightNozzle(self, double: float) -> None: ...
    def setWeightPiping(self, double: float) -> None: ...
    def setWeightStructualSteel(self, double: float) -> None: ...
    def setWeightTotal(self, double: float) -> None: ...
    def setWeightVessel(self, double: float) -> None: ...
    def setWeigthInternals(self, double: float) -> None: ...
    def setWeigthVesselShell(self, double: float) -> None: ...

class SystemMechanicalDesign(java.io.Serializable):
    def __init__(self, processSystem: jneqsim.neqsim.process.processmodel.ProcessSystem): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getMechanicalWeight(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getProcess(self) -> jneqsim.neqsim.process.processmodel.ProcessSystem: ...
    def getTotalNumberOfModules(self) -> int: ...
    def getTotalPlotSpace(self) -> float: ...
    def getTotalVolume(self) -> float: ...
    def getTotalWeight(self) -> float: ...
    def hashCode(self) -> int: ...
    def runDesignCalculation(self) -> None: ...
    def setCompanySpecificDesignStandards(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDesign(self) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.mechanicaldesign")``.

    MechanicalDesign: typing.Type[MechanicalDesign]
    SystemMechanicalDesign: typing.Type[SystemMechanicalDesign]
    absorber: jneqsim.neqsim.process.mechanicaldesign.absorber.__module_protocol__
    adsorber: jneqsim.neqsim.process.mechanicaldesign.adsorber.__module_protocol__
    compressor: jneqsim.neqsim.process.mechanicaldesign.compressor.__module_protocol__
    designstandards: jneqsim.neqsim.process.mechanicaldesign.designstandards.__module_protocol__
    pipeline: jneqsim.neqsim.process.mechanicaldesign.pipeline.__module_protocol__
    separator: jneqsim.neqsim.process.mechanicaldesign.separator.__module_protocol__
    valve: jneqsim.neqsim.process.mechanicaldesign.valve.__module_protocol__
