
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.equipment.valve
import jneqsim.neqsim.process.mechanicaldesign
import typing



class ControlValveSizingInterface:
    def calcValveSize(self, double: float) -> java.util.Map[java.lang.String, typing.Any]: ...
    def calculateFlowRateFromValveOpening(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def calculateValveOpeningFromFlowRate(self, double: float, double2: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def findOutletPressureForFixedKv(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def getxT(self) -> float: ...
    def isAllowChoked(self) -> bool: ...
    def setAllowChoked(self, boolean: bool) -> None: ...
    def setxT(self, double: float) -> None: ...

class ValveCharacteristic(java.io.Serializable):
    def getActualKv(self, double: float, double2: float) -> float: ...
    def getOpeningFactor(self, double: float) -> float: ...

class ValveMechanicalDesign(jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign):
    def __init__(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface): ...
    def calcDesign(self) -> None: ...
    def calcValveSize(self) -> java.util.Map[java.lang.String, typing.Any]: ...
    def displayResults(self) -> None: ...
    def getValveCharacterization(self) -> java.lang.String: ...
    def getValveCharacterizationMethod(self) -> ValveCharacteristic: ...
    def getValveSizingMethod(self) -> ControlValveSizingInterface: ...
    def getValveSizingStandard(self) -> java.lang.String: ...
    def readDesignSpecifications(self) -> None: ...
    def setValveCharacterization(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setValveCharacterizationMethod(self, valveCharacteristic: ValveCharacteristic) -> None: ...
    def setValveSizingStandard(self, string: typing.Union[java.lang.String, str]) -> None: ...

class ControlValveSizing(ControlValveSizingInterface, java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, valveMechanicalDesign: ValveMechanicalDesign): ...
    def calcKv(self, double: float) -> float: ...
    def calcValveSize(self, double: float) -> java.util.Map[java.lang.String, typing.Any]: ...
    def calculateFlowRateFromValveOpening(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def calculateMolarFlow(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def calculateOutletPressure(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def calculateValveOpeningFromFlowRate(self, double: float, double2: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def findOutletPressureForFixedKv(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def getValveMechanicalDesign(self) -> ValveMechanicalDesign: ...
    def getxT(self) -> float: ...
    def isAllowChoked(self) -> bool: ...
    def setAllowChoked(self, boolean: bool) -> None: ...
    def setxT(self, double: float) -> None: ...

class LinearCharacteristic(ValveCharacteristic):
    def __init__(self): ...
    def getActualKv(self, double: float, double2: float) -> float: ...
    def getOpeningFactor(self, double: float) -> float: ...

class ControlValveSizing_IEC_60534(ControlValveSizing):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, valveMechanicalDesign: ValveMechanicalDesign): ...
    def calcValveSize(self, double: float) -> java.util.Map[java.lang.String, typing.Any]: ...
    @typing.overload
    def calculateFlowRateFromKvAndValveOpeningGas(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float, double9: float, double10: float, boolean: bool) -> float: ...
    @typing.overload
    def calculateFlowRateFromKvAndValveOpeningGas(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def calculateFlowRateFromValveOpening(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def calculateFlowRateFromValveOpeningGas(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def calculateFlowRateFromValveOpeningLiquid(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float) -> float: ...
    @typing.overload
    def calculateFlowRateFromValveOpeningLiquid(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def calculateValveOpeningFromFlowRateGas(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float, double9: float, double10: float, double11: float, boolean: bool) -> float: ...
    @typing.overload
    def calculateValveOpeningFromFlowRateGas(self, double: float, double2: float, double3: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def calculateValveOpeningFromFlowRateLiquid(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float) -> float: ...
    @typing.overload
    def calculateValveOpeningFromFlowRateLiquid(self, double: float, double2: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def findOutletPressureForFixedKv(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def findOutletPressureForFixedKvGas(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float) -> float: ...
    @typing.overload
    def findOutletPressureForFixedKvGas(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def findOutletPressureForFixedKvLiquid(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float, double9: float, boolean: bool, boolean2: bool) -> float: ...
    @typing.overload
    def findOutletPressureForFixedKvLiquid(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def getD(self) -> float: ...
    def getD1(self) -> float: ...
    def getD2(self) -> float: ...
    def getFL(self) -> float: ...
    def getFd(self) -> float: ...
    def getValve(self) -> jneqsim.neqsim.process.equipment.valve.ValveInterface: ...
    def isAllowChoked(self) -> bool: ...
    def isAllowLaminar(self) -> bool: ...
    def isFullOutput(self) -> bool: ...
    def setAllowChoked(self, boolean: bool) -> None: ...
    def setAllowLaminar(self, boolean: bool) -> None: ...
    def setD(self, double: float) -> None: ...
    def setD1(self, double: float) -> None: ...
    def setD2(self, double: float) -> None: ...
    def setFL(self, double: float) -> None: ...
    def setFd(self, double: float) -> None: ...
    def setFullOutput(self, boolean: bool) -> None: ...
    def sizeControlValve(self, fluidType: 'ControlValveSizing_IEC_60534.FluidType', double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float, double9: float, double10: float, double11: float, double12: float, double13: float, double14: float, boolean: bool, boolean2: bool, boolean3: bool, double15: float) -> java.util.Map[java.lang.String, typing.Any]: ...
    def sizeControlValveGas(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float) -> java.util.Map[java.lang.String, typing.Any]: ...
    def sizeControlValveLiquid(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float) -> java.util.Map[java.lang.String, typing.Any]: ...
    class FluidType(java.lang.Enum['ControlValveSizing_IEC_60534.FluidType']):
        LIQUID: typing.ClassVar['ControlValveSizing_IEC_60534.FluidType'] = ...
        GAS: typing.ClassVar['ControlValveSizing_IEC_60534.FluidType'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: typing.Union[java.lang.String, str]) -> 'ControlValveSizing_IEC_60534.FluidType': ...
        @staticmethod
        def values() -> typing.MutableSequence['ControlValveSizing_IEC_60534.FluidType']: ...

class ControlValveSizing_simple(ControlValveSizing):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, valveMechanicalDesign: ValveMechanicalDesign): ...
    def calcKv(self, double: float) -> float: ...
    @typing.overload
    def calculateFlowRateFromValveOpening(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def calculateFlowRateFromValveOpening(self, double: float, double2: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def calculateMolarFlow(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def calculateOutletPressure(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def calculateValveOpeningFromFlowRate(self, double: float, double2: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def calculateValveOpeningFromFlowRate(self, double: float, double2: float, double3: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def findOutletPressureForFixedKv(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def findOutletPressureForFixedKv(self, double: float, double2: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...

class ControlValveSizing_IEC_60534_full(ControlValveSizing_IEC_60534):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, valveMechanicalDesign: ValveMechanicalDesign): ...
    def calculateFlowRateFromValveOpening(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def calculateValveOpeningFromFlowRate(self, double: float, double2: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    @typing.overload
    def calculateValveOpeningFromFlowRate(self, double: float, double2: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, streamInterface2: jneqsim.neqsim.process.equipment.stream.StreamInterface, double3: float) -> float: ...
    def findOutletPressureForFixedKv(self, double: float, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> float: ...
    def isFullTrim(self) -> bool: ...
    def setFullTrim(self, boolean: bool) -> None: ...
    def sizeControlValveGas(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float) -> java.util.Map[java.lang.String, typing.Any]: ...
    def sizeControlValveLiquid(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float) -> java.util.Map[java.lang.String, typing.Any]: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.mechanicaldesign.valve")``.

    ControlValveSizing: typing.Type[ControlValveSizing]
    ControlValveSizingInterface: typing.Type[ControlValveSizingInterface]
    ControlValveSizing_IEC_60534: typing.Type[ControlValveSizing_IEC_60534]
    ControlValveSizing_IEC_60534_full: typing.Type[ControlValveSizing_IEC_60534_full]
    ControlValveSizing_simple: typing.Type[ControlValveSizing_simple]
    LinearCharacteristic: typing.Type[LinearCharacteristic]
    ValveCharacteristic: typing.Type[ValveCharacteristic]
    ValveMechanicalDesign: typing.Type[ValveMechanicalDesign]
