
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.compressor
import jneqsim.neqsim.process.equipment.distillation
import jneqsim.neqsim.process.equipment.expander
import jneqsim.neqsim.process.equipment.heatexchanger
import jneqsim.neqsim.process.equipment.manifold
import jneqsim.neqsim.process.equipment.mixer
import jneqsim.neqsim.process.equipment.pipeline
import jneqsim.neqsim.process.equipment.pump
import jneqsim.neqsim.process.equipment.separator
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.equipment.tank
import jneqsim.neqsim.process.equipment.util
import jneqsim.neqsim.process.equipment.valve
import jneqsim.neqsim.process.measurementdevice
import jneqsim.neqsim.thermo.system
import typing



class BaseResponse:
    tagName: java.lang.String = ...
    name: java.lang.String = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface): ...
    @typing.overload
    def __init__(self, measurementDeviceInterface: jneqsim.neqsim.process.measurementdevice.MeasurementDeviceInterface): ...

class FluidComponentResponse:
    name: java.lang.String = ...
    properties: java.util.HashMap = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def print_(self) -> None: ...

class FluidResponse:
    name: java.lang.String = ...
    properties: java.util.HashMap = ...
    composition: java.util.HashMap = ...
    conditions: java.util.HashMap = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def print_(self) -> None: ...

class Value:
    value: java.lang.String = ...
    unit: java.lang.String = ...
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...

class WellAllocatorResponse:
    name: java.lang.String = ...
    data: java.util.HashMap = ...
    def __init__(self, wellAllocator: jneqsim.neqsim.process.measurementdevice.WellAllocator): ...

class CompressorResponse(BaseResponse):
    suctionTemperature: float = ...
    dischargeTemperature: float = ...
    suctionPressure: float = ...
    dischargePressure: float = ...
    polytropicHead: float = ...
    polytropicEfficiency: float = ...
    power: float = ...
    suctionVolumeFlow: float = ...
    internalVolumeFlow: float = ...
    dischargeVolumeFlow: float = ...
    molarMass: float = ...
    suctionMassDensity: float = ...
    dischargeMassDensity: float = ...
    massflow: float = ...
    stdFlow: float = ...
    speed: float = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, compressor: jneqsim.neqsim.process.equipment.compressor.Compressor): ...

class DistillationColumnResponse(BaseResponse):
    massBalanceError: float = ...
    trayTemperature: typing.MutableSequence[float] = ...
    trayPressure: typing.MutableSequence[float] = ...
    numberOfTrays: int = ...
    trayVaporFlowRate: typing.MutableSequence[float] = ...
    trayLiquidFlowRate: typing.MutableSequence[float] = ...
    trayFeedFlow: typing.MutableSequence[float] = ...
    trayMassBalance: typing.MutableSequence[float] = ...
    def __init__(self, distillationColumn: jneqsim.neqsim.process.equipment.distillation.DistillationColumn): ...

class HXResponse(BaseResponse):
    feedTemperature1: float = ...
    dischargeTemperature1: float = ...
    HXthermalEfectiveness: float = ...
    feedTemperature2: float = ...
    dischargeTemperature2: float = ...
    dutyBalance: float = ...
    duty: float = ...
    UAvalue: float = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, heatExchanger: jneqsim.neqsim.process.equipment.heatexchanger.HeatExchanger): ...

class HeaterResponse(BaseResponse):
    data: java.util.HashMap = ...
    def __init__(self, heater: jneqsim.neqsim.process.equipment.heatexchanger.Heater): ...

class MPMResponse(BaseResponse):
    massFLow: float = ...
    GOR: float = ...
    GOR_std: float = ...
    gasDensity: float = ...
    oilDensity: float = ...
    waterDensity: float = ...
    def __init__(self, multiPhaseMeter: jneqsim.neqsim.process.measurementdevice.MultiPhaseMeter): ...

class ManifoldResponse(BaseResponse):
    data: java.util.HashMap = ...
    def __init__(self, manifold: jneqsim.neqsim.process.equipment.manifold.Manifold): ...

class MixerResponse(BaseResponse):
    data: java.util.HashMap = ...
    def __init__(self, mixer: jneqsim.neqsim.process.equipment.mixer.Mixer): ...

class MultiStreamHeatExchanger2Response(BaseResponse):
    data: java.util.HashMap = ...
    temperatureApproach: float = ...
    compositeCurveResults: java.util.Map = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, multiStreamHeatExchanger2: jneqsim.neqsim.process.equipment.heatexchanger.MultiStreamHeatExchanger2): ...

class MultiStreamHeatExchangerResponse(BaseResponse):
    data: java.util.HashMap = ...
    feedTemperature: typing.MutableSequence[float] = ...
    dischargeTemperature: typing.MutableSequence[float] = ...
    duty: typing.MutableSequence[float] = ...
    flowRate: typing.MutableSequence[float] = ...
    def __init__(self, multiStreamHeatExchanger: jneqsim.neqsim.process.equipment.heatexchanger.MultiStreamHeatExchanger): ...

class PipeBeggsBrillsResponse(BaseResponse):
    inletPressure: float = ...
    outletPressure: float = ...
    inletTemperature: float = ...
    outletTemperature: float = ...
    inletDensity: float = ...
    outletDensity: float = ...
    inletVolumeFlow: float = ...
    outletVolumeFlow: float = ...
    inletMassFlow: float = ...
    outletMassFlow: float = ...
    def __init__(self, pipeBeggsAndBrills: jneqsim.neqsim.process.equipment.pipeline.PipeBeggsAndBrills): ...

class PumpResponse(BaseResponse):
    data: java.util.HashMap = ...
    suctionTemperature: float = ...
    dischargeTemperature: float = ...
    suctionPressure: float = ...
    dischargePressure: float = ...
    power: float = ...
    duty: float = ...
    suctionVolumeFlow: float = ...
    internalVolumeFlow: float = ...
    dischargeVolumeFlow: float = ...
    molarMass: float = ...
    suctionMassDensity: float = ...
    dischargeMassDensity: float = ...
    massflow: float = ...
    speed: int = ...
    def __init__(self, pump: jneqsim.neqsim.process.equipment.pump.Pump): ...

class RecycleResponse(BaseResponse):
    data: java.util.HashMap = ...
    def __init__(self, recycle: jneqsim.neqsim.process.equipment.util.Recycle): ...

class SeparatorResponse(BaseResponse):
    gasLoadFactor: float = ...
    feed: 'StreamResponse' = ...
    gas: 'StreamResponse' = ...
    liquid: 'StreamResponse' = ...
    oil: 'StreamResponse' = ...
    water: 'StreamResponse' = ...
    @typing.overload
    def __init__(self, separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    @typing.overload
    def __init__(self, threePhaseSeparator: jneqsim.neqsim.process.equipment.separator.ThreePhaseSeparator): ...

class StreamResponse(BaseResponse):
    properties: java.util.HashMap = ...
    conditions: java.util.HashMap = ...
    composition: java.util.HashMap = ...
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def print_(self) -> None: ...

class TankResponse(BaseResponse):
    data: java.util.HashMap = ...
    def __init__(self, tank: jneqsim.neqsim.process.equipment.tank.Tank): ...

class ThreePhaseSeparatorResponse(BaseResponse):
    gasLoadFactor: float = ...
    massflow: float = ...
    gasFluid: FluidResponse = ...
    oilFluid: FluidResponse = ...
    @typing.overload
    def __init__(self, separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    @typing.overload
    def __init__(self, threePhaseSeparator: jneqsim.neqsim.process.equipment.separator.ThreePhaseSeparator): ...

class TurboExpanderCompressorResponse(BaseResponse):
    def __init__(self, turboExpanderCompressor: jneqsim.neqsim.process.equipment.expander.TurboExpanderCompressor): ...

class ValveResponse(BaseResponse):
    data: java.util.HashMap = ...
    def __init__(self, valveInterface: jneqsim.neqsim.process.equipment.valve.ValveInterface): ...
    def print_(self) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.util.monitor")``.

    BaseResponse: typing.Type[BaseResponse]
    CompressorResponse: typing.Type[CompressorResponse]
    DistillationColumnResponse: typing.Type[DistillationColumnResponse]
    FluidComponentResponse: typing.Type[FluidComponentResponse]
    FluidResponse: typing.Type[FluidResponse]
    HXResponse: typing.Type[HXResponse]
    HeaterResponse: typing.Type[HeaterResponse]
    MPMResponse: typing.Type[MPMResponse]
    ManifoldResponse: typing.Type[ManifoldResponse]
    MixerResponse: typing.Type[MixerResponse]
    MultiStreamHeatExchanger2Response: typing.Type[MultiStreamHeatExchanger2Response]
    MultiStreamHeatExchangerResponse: typing.Type[MultiStreamHeatExchangerResponse]
    PipeBeggsBrillsResponse: typing.Type[PipeBeggsBrillsResponse]
    PumpResponse: typing.Type[PumpResponse]
    RecycleResponse: typing.Type[RecycleResponse]
    SeparatorResponse: typing.Type[SeparatorResponse]
    StreamResponse: typing.Type[StreamResponse]
    TankResponse: typing.Type[TankResponse]
    ThreePhaseSeparatorResponse: typing.Type[ThreePhaseSeparatorResponse]
    TurboExpanderCompressorResponse: typing.Type[TurboExpanderCompressorResponse]
    Value: typing.Type[Value]
    ValveResponse: typing.Type[ValveResponse]
    WellAllocatorResponse: typing.Type[WellAllocatorResponse]
