
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import jneqsim.neqsim.pvtsimulation.simulation
import typing



class TuningInterface:
    def getSimulation(self) -> jneqsim.neqsim.pvtsimulation.simulation.SimulationInterface: ...
    def run(self) -> None: ...
    def setSaturationConditions(self, double: float, double2: float) -> None: ...

class BaseTuningClass(TuningInterface):
    saturationTemperature: float = ...
    saturationPressure: float = ...
    def __init__(self, simulationInterface: jneqsim.neqsim.pvtsimulation.simulation.SimulationInterface): ...
    def getSimulation(self) -> jneqsim.neqsim.pvtsimulation.simulation.SimulationInterface: ...
    def isTunePlusMolarMass(self) -> bool: ...
    def isTuneVolumeCorrection(self) -> bool: ...
    def run(self) -> None: ...
    def setSaturationConditions(self, double: float, double2: float) -> None: ...
    def setTunePlusMolarMass(self, boolean: bool) -> None: ...
    def setTuneVolumeCorrection(self, boolean: bool) -> None: ...

class TuneToSaturation(BaseTuningClass):
    def __init__(self, simulationInterface: jneqsim.neqsim.pvtsimulation.simulation.SimulationInterface): ...
    def run(self) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.pvtsimulation.modeltuning")``.

    BaseTuningClass: typing.Type[BaseTuningClass]
    TuneToSaturation: typing.Type[TuneToSaturation]
    TuningInterface: typing.Type[TuningInterface]
