
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.statistics.parameterfitting.nonlinearparameterfitting
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations
import typing



class SimulationInterface:
    def getBaseThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getOptimizer(self) -> jneqsim.neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def run(self) -> None: ...
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...

class BasePVTsimulation(SimulationInterface):
    thermoOps: jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations = ...
    pressures: typing.MutableSequence[float] = ...
    temperature: float = ...
    optimizer: jneqsim.neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt = ...
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getBaseThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getOptimizer(self) -> jneqsim.neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt: ...
    def getPressure(self) -> float: ...
    def getPressures(self) -> typing.MutableSequence[float]: ...
    def getSaturationPressure(self) -> float: ...
    def getSaturationTemperature(self) -> float: ...
    def getTemperature(self) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getZsaturation(self) -> float: ...
    def run(self) -> None: ...
    def setExperimentalData(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...

class ConstantMassExpansion(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcSaturationConditions(self) -> None: ...
    def getBg(self) -> typing.MutableSequence[float]: ...
    def getDensity(self) -> typing.MutableSequence[float]: ...
    def getIsoThermalCompressibility(self) -> typing.MutableSequence[float]: ...
    def getLiquidRelativeVolume(self) -> typing.MutableSequence[float]: ...
    def getRelativeVolume(self) -> typing.MutableSequence[float]: ...
    def getSaturationIsoThermalCompressibility(self) -> float: ...
    def getSaturationPressure(self) -> float: ...
    def getViscosity(self) -> typing.MutableSequence[float]: ...
    def getYfactor(self) -> typing.MutableSequence[float]: ...
    def getZgas(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def runTuning(self) -> None: ...
    def setTemperaturesAndPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class ConstantVolumeDepletion(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcSaturationConditions(self) -> None: ...
    def getCummulativeMolePercDepleted(self) -> typing.MutableSequence[float]: ...
    def getLiquidRelativeVolume(self) -> typing.MutableSequence[float]: ...
    def getRelativeVolume(self) -> typing.MutableSequence[float]: ...
    def getSaturationPressure(self) -> float: ...
    def getZgas(self) -> typing.MutableSequence[float]: ...
    def getZmix(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def runTuning(self) -> None: ...
    def setTemperaturesAndPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class DensitySim(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getAqueousDensity(self) -> typing.MutableSequence[float]: ...
    def getGasDensity(self) -> typing.MutableSequence[float]: ...
    def getOilDensity(self) -> typing.MutableSequence[float]: ...
    def getWaxFraction(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def runTuning(self) -> None: ...
    def setTemperaturesAndPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class DifferentialLiberation(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcSaturationConditions(self) -> None: ...
    def getBg(self) -> typing.MutableSequence[float]: ...
    def getBo(self) -> typing.MutableSequence[float]: ...
    def getGasStandardVolume(self) -> typing.MutableSequence[float]: ...
    def getOilDensity(self) -> typing.MutableSequence[float]: ...
    def getRelGasGravity(self) -> typing.MutableSequence[float]: ...
    def getRelativeVolume(self) -> typing.MutableSequence[float]: ...
    def getRs(self) -> typing.MutableSequence[float]: ...
    def getSaturationPressure(self) -> float: ...
    def getZgas(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...

class GOR(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getBofactor(self) -> typing.MutableSequence[float]: ...
    def getGOR(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def setTemperaturesAndPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class SaturationPressure(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcSaturationPressure(self) -> float: ...
    def getSaturationPressure(self) -> float: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def run(self) -> None: ...

class SaturationTemperature(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcSaturationTemperature(self) -> float: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def run(self) -> None: ...

class SeparatorTest(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getBofactor(self) -> typing.MutableSequence[float]: ...
    def getGOR(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def setSeparatorConditions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class SlimTubeSim(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getNumberOfSlimTubeNodes(self) -> int: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def run(self) -> None: ...
    def setNumberOfSlimTubeNodes(self, int: int) -> None: ...

class SwellingTest(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getPressures(self) -> typing.MutableSequence[float]: ...
    def getRelativeOilVolume(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def setCummulativeMolePercentGasInjected(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setInjectionGas(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setRelativeOilVolume(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class ViscositySim(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getAqueousViscosity(self) -> typing.MutableSequence[float]: ...
    def getGasViscosity(self) -> typing.MutableSequence[float]: ...
    def getOilViscosity(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def runTuning(self) -> None: ...
    def setTemperaturesAndPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class ViscosityWaxOilSim(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getAqueousViscosity(self) -> typing.MutableSequence[float]: ...
    def getGasViscosity(self) -> typing.MutableSequence[float]: ...
    def getOilViscosity(self) -> typing.MutableSequence[float]: ...
    def getOilwaxDispersionViscosity(self) -> typing.MutableSequence[float]: ...
    def getShareRate(self) -> typing.MutableSequence[float]: ...
    def getWaxFraction(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def runTuning(self) -> None: ...
    def setShareRate(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setTemperaturesAndPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class WaxFractionSim(BasePVTsimulation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getBofactor(self) -> typing.MutableSequence[float]: ...
    def getGOR(self) -> typing.MutableSequence[float]: ...
    def getWaxFraction(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def runCalc(self) -> None: ...
    def runTuning(self) -> None: ...
    def setTemperaturesAndPressures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.pvtsimulation.simulation")``.

    BasePVTsimulation: typing.Type[BasePVTsimulation]
    ConstantMassExpansion: typing.Type[ConstantMassExpansion]
    ConstantVolumeDepletion: typing.Type[ConstantVolumeDepletion]
    DensitySim: typing.Type[DensitySim]
    DifferentialLiberation: typing.Type[DifferentialLiberation]
    GOR: typing.Type[GOR]
    SaturationPressure: typing.Type[SaturationPressure]
    SaturationTemperature: typing.Type[SaturationTemperature]
    SeparatorTest: typing.Type[SeparatorTest]
    SimulationInterface: typing.Type[SimulationInterface]
    SlimTubeSim: typing.Type[SlimTubeSim]
    SwellingTest: typing.Type[SwellingTest]
    ViscositySim: typing.Type[ViscositySim]
    ViscosityWaxOilSim: typing.Type[ViscosityWaxOilSim]
    WaxFractionSim: typing.Type[WaxFractionSim]
