
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.standards
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.system
import typing



class BestPracticeHydrocarbonDewPoint(jneqsim.neqsim.standards.Standard):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calculate(self) -> None: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...

class Draft_GERG2004(jneqsim.neqsim.standards.Standard):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calculate(self) -> None: ...
    def createTable(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...

class Draft_ISO18453(jneqsim.neqsim.standards.Standard):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calculate(self) -> None: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...

class GasChromotograpyhBase(jneqsim.neqsim.standards.Standard):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calculate(self) -> None: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...

class Standard_ISO15403(jneqsim.neqsim.standards.Standard):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calculate(self) -> None: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...

class Standard_ISO6578(jneqsim.neqsim.standards.Standard):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calculate(self) -> None: ...
    def getCorrFactor1(self) -> float: ...
    def getCorrFactor2(self) -> float: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...
    def setCorrectionFactors(self) -> None: ...
    def useISO6578VolumeCorrectionFacotrs(self, boolean: bool) -> None: ...

class Standard_ISO6976(jneqsim.neqsim.standards.Standard, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float, string: typing.Union[java.lang.String, str]): ...
    def calculate(self) -> None: ...
    def checkReferenceCondition(self) -> None: ...
    def createTable(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getAverageCarbonNumber(self) -> float: ...
    def getComponentsNotDefinedByStandard(self) -> java.util.ArrayList[java.lang.String]: ...
    def getEnergyRefP(self) -> float: ...
    def getEnergyRefT(self) -> float: ...
    def getReferenceType(self) -> java.lang.String: ...
    def getTotalMolesOfInerts(self) -> float: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def getVolRefT(self) -> float: ...
    def isOnSpec(self) -> bool: ...
    def removeInertsButNitrogen(self) -> None: ...
    def setEnergyRefP(self, double: float) -> None: ...
    def setEnergyRefT(self, double: float) -> None: ...
    def setReferenceType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setVolRefT(self, double: float) -> None: ...

class SulfurSpecificationMethod(jneqsim.neqsim.standards.Standard):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calculate(self) -> None: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...

class UKspecifications_ICF_SI(jneqsim.neqsim.standards.Standard):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcPropaneNumber(self) -> float: ...
    def calcWithNitrogenAsInert(self) -> float: ...
    def calculate(self) -> None: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...

class Standard_ISO6974(GasChromotograpyhBase):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...

class Standard_ISO6976_2016(Standard_ISO6976):
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float, string: typing.Union[java.lang.String, str]): ...
    def calculate(self) -> None: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.standards.gasquality")``.

    BestPracticeHydrocarbonDewPoint: typing.Type[BestPracticeHydrocarbonDewPoint]
    Draft_GERG2004: typing.Type[Draft_GERG2004]
    Draft_ISO18453: typing.Type[Draft_ISO18453]
    GasChromotograpyhBase: typing.Type[GasChromotograpyhBase]
    Standard_ISO15403: typing.Type[Standard_ISO15403]
    Standard_ISO6578: typing.Type[Standard_ISO6578]
    Standard_ISO6974: typing.Type[Standard_ISO6974]
    Standard_ISO6976: typing.Type[Standard_ISO6976]
    Standard_ISO6976_2016: typing.Type[Standard_ISO6976_2016]
    SulfurSpecificationMethod: typing.Type[SulfurSpecificationMethod]
    UKspecifications_ICF_SI: typing.Type[UKspecifications_ICF_SI]
