
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import jpype
import neqsim
import jneqsim.neqsim.thermo.system
import typing



class Characterise(java.io.Serializable, java.lang.Cloneable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def characterisePlusFraction(self) -> None: ...
    def clone(self) -> 'Characterise': ...
    def getLumpingModel(self) -> 'LumpingModelInterface': ...
    def getPlusFractionModel(self) -> 'PlusFractionModelInterface': ...
    def getTBPModel(self) -> 'TBPModelInterface': ...
    def setLumpingModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPlusFractionModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTBPModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...

class CharacteriseInterface:
    PVTsimMolarMass: typing.ClassVar[typing.MutableSequence[float]] = ...
    def addCharacterizedPlusFraction(self) -> None: ...
    def addHeavyEnd(self) -> None: ...
    def addTBPFractions(self) -> None: ...
    def generatePlusFractions(self, int: int, int2: int, double: float, double2: float) -> None: ...
    def generateTBPFractions(self) -> None: ...
    def getCoef(self, int: int) -> float: ...
    def getCoefs(self) -> typing.MutableSequence[float]: ...
    def getDensLastTBP(self) -> float: ...
    def getDensPlus(self) -> float: ...
    def getFirstPlusFractionNumber(self) -> int: ...
    def getLastPlusFractionNumber(self) -> int: ...
    def getMPlus(self) -> float: ...
    @typing.overload
    def getPlusCoefs(self, int: int) -> float: ...
    @typing.overload
    def getPlusCoefs(self) -> typing.MutableSequence[float]: ...
    def getZPlus(self) -> float: ...
    def groupTBPfractions(self) -> bool: ...
    def hasPlusFraction(self) -> bool: ...
    def isPseudocomponents(self) -> bool: ...
    def removeTBPfraction(self) -> None: ...
    @typing.overload
    def setCoefs(self, double: float, int: int) -> None: ...
    @typing.overload
    def setCoefs(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setDensLastTBP(self, double: float) -> None: ...
    def setMPlus(self, double: float) -> None: ...
    def setNumberOfPseudocomponents(self, int: int) -> None: ...
    def setPlusCoefs(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setPseudocomponents(self, boolean: bool) -> None: ...
    def setZPlus(self, double: float) -> None: ...
    def solve(self) -> None: ...

class LumpingModelInterface:
    def generateLumpedComposition(self, characterise: Characterise) -> None: ...
    def getFractionOfHeavyEnd(self, int: int) -> float: ...
    def getLumpedComponentName(self, int: int) -> java.lang.String: ...
    def getLumpedComponentNames(self) -> typing.MutableSequence[java.lang.String]: ...
    def getName(self) -> java.lang.String: ...
    def getNumberOfLumpedComponents(self) -> int: ...
    def getNumberOfPseudoComponents(self) -> int: ...
    def setNumberOfLumpedComponents(self, int: int) -> None: ...
    def setNumberOfPseudoComponents(self, int: int) -> None: ...

class NewtonSolveAB(java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, tBPCharacterize: 'TBPCharacterize'): ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...
    def solve(self) -> None: ...

class NewtonSolveABCD(java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, tBPCharacterize: 'TBPCharacterize'): ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...
    def solve(self) -> None: ...

class NewtonSolveCDplus(java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, plusCharacterize: 'PlusCharacterize'): ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...
    def solve(self) -> None: ...

class PedersenPlusModelSolver(java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, pedersenPlusModel: 'PlusFractionModel.PedersenPlusModel'): ...
    def setJacAB(self) -> None: ...
    def setJacCD(self) -> None: ...
    def setfvecAB(self) -> None: ...
    def setfvecCD(self) -> None: ...
    def solve(self) -> None: ...

class PlusFractionModel(java.io.Serializable):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getModel(self, string: typing.Union[java.lang.String, str]) -> 'PlusFractionModelInterface': ...
    class PedersenPlusModel: ...

class PlusFractionModelInterface(java.io.Serializable):
    def characterizePlusFraction(self, tBPModelInterface: 'TBPModelInterface') -> bool: ...
    def getCoef(self, int: int) -> float: ...
    def getCoefs(self) -> typing.MutableSequence[float]: ...
    def getDens(self) -> typing.MutableSequence[float]: ...
    def getDensPlus(self) -> float: ...
    def getFirstPlusFractionNumber(self) -> int: ...
    def getFirstTBPFractionNumber(self) -> int: ...
    def getLastPlusFractionNumber(self) -> int: ...
    def getM(self) -> typing.MutableSequence[float]: ...
    def getMPlus(self) -> float: ...
    def getMaxPlusMolarMass(self) -> float: ...
    def getName(self) -> java.lang.String: ...
    def getNumberOfPlusPseudocomponents(self) -> float: ...
    def getPlusComponentNumber(self) -> int: ...
    def getZ(self) -> typing.MutableSequence[float]: ...
    def getZPlus(self) -> float: ...
    def hasPlusFraction(self) -> bool: ...
    def setLastPlusFractionNumber(self, int: int) -> None: ...

class Recombine:
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getGOR(self) -> float: ...
    def getOilDesnity(self) -> float: ...
    def getRecombinedSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def runRecombination(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def setGOR(self, double: float) -> None: ...
    def setOilDesnity(self, double: float) -> None: ...

class TBPModelInterface:
    def calcAcentricFactor(self, double: float, double2: float) -> float: ...
    def calcAcentricFactorKeslerLee(self, double: float, double2: float) -> float: ...
    def calcCriticalViscosity(self, double: float, double2: float) -> float: ...
    def calcCriticalVolume(self, double: float, double2: float) -> float: ...
    def calcPC(self, double: float, double2: float) -> float: ...
    def calcParachorParameter(self, double: float, double2: float) -> float: ...
    def calcRacketZ(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float) -> float: ...
    def calcTB(self, double: float, double2: float) -> float: ...
    def calcTC(self, double: float, double2: float) -> float: ...
    def calcWatsonCharacterizationFactor(self, double: float, double2: float) -> float: ...
    def calcm(self, double: float, double2: float) -> float: ...
    def getName(self) -> java.lang.String: ...
    def isCalcm(self) -> bool: ...
    def setBoilingPoint(self, double: float) -> None: ...

class WaxModelInterface(java.io.Serializable, java.lang.Cloneable):
    def addTBPWax(self) -> None: ...
    def clone(self) -> 'WaxModelInterface': ...
    def getParameterWaxHeatOfFusion(self) -> typing.MutableSequence[float]: ...
    def getParameterWaxTriplePointTemperature(self) -> typing.MutableSequence[float]: ...
    def getWaxParameters(self) -> typing.MutableSequence[float]: ...
    def removeWax(self) -> None: ...
    @typing.overload
    def setParameterWaxHeatOfFusion(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setParameterWaxHeatOfFusion(self, int: int, double: float) -> None: ...
    @typing.overload
    def setParameterWaxTriplePointTemperature(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setParameterWaxTriplePointTemperature(self, int: int, double: float) -> None: ...
    def setWaxParameter(self, int: int, double: float) -> None: ...
    def setWaxParameters(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class PlusCharacterize(java.io.Serializable, CharacteriseInterface):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def addCharacterizedPlusFraction(self) -> None: ...
    def addHeavyEnd(self) -> None: ...
    def addPseudoTBPfraction(self, int: int, int2: int) -> None: ...
    def addTBPFractions(self) -> None: ...
    def characterizePlusFraction(self) -> None: ...
    def generatePlusFractions(self, int: int, int2: int, double: float, double2: float) -> None: ...
    def generateTBPFractions(self) -> None: ...
    def getCarbonNumberVector(self) -> typing.MutableSequence[int]: ...
    def getCoef(self, int: int) -> float: ...
    def getCoefs(self) -> typing.MutableSequence[float]: ...
    def getDensLastTBP(self) -> float: ...
    def getDensPlus(self) -> float: ...
    def getFirstPlusFractionNumber(self) -> int: ...
    def getLastPlusFractionNumber(self) -> int: ...
    def getLength(self) -> int: ...
    def getMPlus(self) -> float: ...
    def getNumberOfPseudocomponents(self) -> int: ...
    @typing.overload
    def getPlusCoefs(self, int: int) -> float: ...
    @typing.overload
    def getPlusCoefs(self) -> typing.MutableSequence[float]: ...
    def getStartPlus(self) -> int: ...
    def getZPlus(self) -> float: ...
    def groupTBPfractions(self) -> bool: ...
    def hasPlusFraction(self) -> bool: ...
    def isPseudocomponents(self) -> bool: ...
    def removeTBPfraction(self) -> None: ...
    def setCarbonNumberVector(self, intArray: typing.Union[typing.List[int], jpype.JArray]) -> None: ...
    @typing.overload
    def setCoefs(self, double: float, int: int) -> None: ...
    @typing.overload
    def setCoefs(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setDensLastTBP(self, double: float) -> None: ...
    def setDensPlus(self, double: float) -> None: ...
    def setFirstPlusFractionNumber(self, int: int) -> None: ...
    def setHeavyTBPtoPlus(self) -> None: ...
    def setMPlus(self, double: float) -> None: ...
    def setNumberOfPseudocomponents(self, int: int) -> None: ...
    def setPlusCoefs(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setPseudocomponents(self, boolean: bool) -> None: ...
    def setZPlus(self, double: float) -> None: ...
    def solve(self) -> None: ...

class TBPCharacterize(PlusCharacterize):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def addHeavyEnd(self) -> None: ...
    def addPlusFraction(self) -> None: ...
    def addTBPFractions(self) -> None: ...
    def getCalcTBPfractions(self) -> typing.MutableSequence[float]: ...
    def getCarbonNumberVector(self) -> typing.MutableSequence[int]: ...
    def getDensPlus(self) -> float: ...
    def getLength(self) -> int: ...
    @typing.overload
    def getPlusCoefs(self, int: int) -> float: ...
    @typing.overload
    def getPlusCoefs(self) -> typing.MutableSequence[float]: ...
    def getTBP_M(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getTBPdens(self, int: int) -> float: ...
    @typing.overload
    def getTBPdens(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getTBPfractions(self, int: int) -> float: ...
    @typing.overload
    def getTBPfractions(self) -> typing.MutableSequence[float]: ...
    def groupTBPfractions(self) -> bool: ...
    def isPseudocomponents(self) -> bool: ...
    def saveCharacterizedFluid(self) -> bool: ...
    def setCalcTBPfractions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setCarbonNumberVector(self, intArray: typing.Union[typing.List[int], jpype.JArray]) -> None: ...
    @typing.overload
    def setCoefs(self, double: float, int: int) -> None: ...
    @typing.overload
    def setCoefs(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setDensPlus(self, double: float) -> None: ...
    def setPlusCoefs(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setTBP_M(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setTBPdens(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setTBPfractions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def solve(self) -> None: ...
    def solveAB(self) -> None: ...

class LumpingModel(java.io.Serializable):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getModel(self, string: typing.Union[java.lang.String, str]) -> LumpingModelInterface: ...
    class NoLumpingModel(jneqsim.neqsim.thermo.characterization.LumpingModel.StandardLumpingModel):
        def __init__(self, lumpingModel: 'LumpingModel'): ...
        def generateLumpedComposition(self, characterise: Characterise) -> None: ...
        def getFractionOfHeavyEnd(self, int: int) -> float: ...
    class PVTLumpingModel(jneqsim.neqsim.thermo.characterization.LumpingModel.StandardLumpingModel):
        def __init__(self, lumpingModel: 'LumpingModel'): ...
        def generateLumpedComposition(self, characterise: Characterise) -> None: ...
        def getFractionOfHeavyEnd(self, int: int) -> float: ...
    class StandardLumpingModel(LumpingModelInterface, java.lang.Cloneable, java.io.Serializable):
        def __init__(self, lumpingModel: 'LumpingModel'): ...
        def generateLumpedComposition(self, characterise: Characterise) -> None: ...
        def getFractionOfHeavyEnd(self, int: int) -> float: ...
        def getLumpedComponentName(self, int: int) -> java.lang.String: ...
        def getLumpedComponentNames(self) -> typing.MutableSequence[java.lang.String]: ...
        def getName(self) -> java.lang.String: ...
        def getNumberOfLumpedComponents(self) -> int: ...
        def getNumberOfPseudoComponents(self) -> int: ...
        def setNumberOfLumpedComponents(self, int: int) -> None: ...
        def setNumberOfPseudoComponents(self, int: int) -> None: ...

class TBPfractionModel(java.io.Serializable):
    def __init__(self): ...
    def getModel(self, string: typing.Union[java.lang.String, str]) -> TBPModelInterface: ...
    class LeeKesler(jneqsim.neqsim.thermo.characterization.TBPfractionModel.TBPBaseModel):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
        def calcAcentricFactor(self, double: float, double2: float) -> float: ...
        def calcPC(self, double: float, double2: float) -> float: ...
        def calcTC(self, double: float, double2: float) -> float: ...
    class PedersenTBPModelPR(jneqsim.neqsim.thermo.characterization.TBPfractionModel.PedersenTBPModelSRK):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
    class PedersenTBPModelPR2(jneqsim.neqsim.thermo.characterization.TBPfractionModel.PedersenTBPModelSRK):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
        def calcTB(self, double: float, double2: float) -> float: ...
    class PedersenTBPModelPRHeavyOil(jneqsim.neqsim.thermo.characterization.TBPfractionModel.PedersenTBPModelPR):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
    class PedersenTBPModelSRK(jneqsim.neqsim.thermo.characterization.TBPfractionModel.TBPBaseModel):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
        def calcPC(self, double: float, double2: float) -> float: ...
        def calcRacketZ(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float) -> float: ...
        def calcTB(self, double: float, double2: float) -> float: ...
        def calcTC(self, double: float, double2: float) -> float: ...
        def calcm(self, double: float, double2: float) -> float: ...
    class PedersenTBPModelSRKHeavyOil(jneqsim.neqsim.thermo.characterization.TBPfractionModel.PedersenTBPModelSRK):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
    class RiaziDaubert(jneqsim.neqsim.thermo.characterization.TBPfractionModel.PedersenTBPModelSRK):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
        def calcAcentricFactor(self, double: float, double2: float) -> float: ...
        def calcAcentricFactor2(self, double: float, double2: float) -> float: ...
        def calcPC(self, double: float, double2: float) -> float: ...
        def calcTB(self, double: float, double2: float) -> float: ...
        def calcTC(self, double: float, double2: float) -> float: ...
    class TBPBaseModel(TBPModelInterface, java.lang.Cloneable, java.io.Serializable):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
        def calcAcentricFactor(self, double: float, double2: float) -> float: ...
        def calcAcentricFactorKeslerLee(self, double: float, double2: float) -> float: ...
        def calcCriticalViscosity(self, double: float, double2: float) -> float: ...
        def calcCriticalVolume(self, double: float, double2: float) -> float: ...
        def calcParachorParameter(self, double: float, double2: float) -> float: ...
        def calcRacketZ(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float) -> float: ...
        def calcTB(self, double: float, double2: float) -> float: ...
        def calcWatsonCharacterizationFactor(self, double: float, double2: float) -> float: ...
        def calcm(self, double: float, double2: float) -> float: ...
        def getBoilingPoint(self) -> float: ...
        def getName(self) -> java.lang.String: ...
        def isCalcm(self) -> bool: ...
        def setBoilingPoint(self, double: float) -> None: ...
    class TwuModel(jneqsim.neqsim.thermo.characterization.TBPfractionModel.TBPBaseModel):
        def __init__(self, tBPfractionModel: 'TBPfractionModel'): ...
        def calcCriticalVolume(self, double: float, double2: float) -> float: ...
        def calcPC(self, double: float, double2: float) -> float: ...
        def calcTC(self, double: float, double2: float) -> float: ...
        def calculateTfunc(self, double: float, double2: float) -> float: ...
        def computeGradient(self, double: float, double2: float) -> float: ...
        def solveMW(self, double: float) -> float: ...

class WaxCharacterise(java.io.Serializable, java.lang.Cloneable):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def clone(self) -> 'WaxCharacterise': ...
    @typing.overload
    def getModel(self) -> WaxModelInterface: ...
    @typing.overload
    def getModel(self, string: typing.Union[java.lang.String, str]) -> WaxModelInterface: ...
    def setModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setModelName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    class PedersenWaxModel(jneqsim.neqsim.thermo.characterization.WaxCharacterise.WaxBaseModel):
        def __init__(self, waxCharacterise: 'WaxCharacterise'): ...
        def addTBPWax(self) -> None: ...
        def calcHeatOfFusion(self, int: int) -> float: ...
        def calcPCwax(self, int: int, string: typing.Union[java.lang.String, str]) -> float: ...
        def calcParaffinDensity(self, int: int) -> float: ...
        def calcTriplePointTemperature(self, int: int) -> float: ...
        def removeWax(self) -> None: ...
    class WaxBaseModel(WaxModelInterface):
        def __init__(self, waxCharacterise: 'WaxCharacterise'): ...
        def addTBPWax(self) -> None: ...
        def clone(self) -> 'WaxCharacterise.WaxBaseModel': ...
        def getParameterWaxHeatOfFusion(self) -> typing.MutableSequence[float]: ...
        def getParameterWaxTriplePointTemperature(self) -> typing.MutableSequence[float]: ...
        def getWaxParameters(self) -> typing.MutableSequence[float]: ...
        @typing.overload
        def setParameterWaxHeatOfFusion(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
        @typing.overload
        def setParameterWaxHeatOfFusion(self, int: int, double: float) -> None: ...
        @typing.overload
        def setParameterWaxTriplePointTemperature(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
        @typing.overload
        def setParameterWaxTriplePointTemperature(self, int: int, double: float) -> None: ...
        def setWaxParameter(self, int: int, double: float) -> None: ...
        def setWaxParameters(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermo.characterization")``.

    Characterise: typing.Type[Characterise]
    CharacteriseInterface: typing.Type[CharacteriseInterface]
    LumpingModel: typing.Type[LumpingModel]
    LumpingModelInterface: typing.Type[LumpingModelInterface]
    NewtonSolveAB: typing.Type[NewtonSolveAB]
    NewtonSolveABCD: typing.Type[NewtonSolveABCD]
    NewtonSolveCDplus: typing.Type[NewtonSolveCDplus]
    PedersenPlusModelSolver: typing.Type[PedersenPlusModelSolver]
    PlusCharacterize: typing.Type[PlusCharacterize]
    PlusFractionModel: typing.Type[PlusFractionModel]
    PlusFractionModelInterface: typing.Type[PlusFractionModelInterface]
    Recombine: typing.Type[Recombine]
    TBPCharacterize: typing.Type[TBPCharacterize]
    TBPModelInterface: typing.Type[TBPModelInterface]
    TBPfractionModel: typing.Type[TBPfractionModel]
    WaxCharacterise: typing.Type[WaxCharacterise]
    WaxModelInterface: typing.Type[WaxModelInterface]
