
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.sql
import jneqsim.neqsim.util.util
import typing



class AspenIP21Database(jneqsim.neqsim.util.util.FileSystemSettings, java.io.Serializable):
    def __init__(self): ...
    @typing.overload
    def getResultSet(self, string: typing.Union[java.lang.String, str]) -> java.sql.ResultSet: ...
    @typing.overload
    def getResultSet(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> java.sql.ResultSet: ...
    def getStatement(self) -> java.sql.Statement: ...
    def openConnection(self, string: typing.Union[java.lang.String, str]) -> java.sql.Connection: ...
    def setStatement(self, statement: java.sql.Statement) -> None: ...

class NeqSimBlobDatabase(jneqsim.neqsim.util.util.FileSystemSettings, java.io.Serializable):
    dataBasePath: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def createTemporaryTables(self) -> bool: ...
    def execute(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getConnection(self) -> java.sql.Connection: ...
    @staticmethod
    def getConnectionString() -> java.lang.String: ...
    @staticmethod
    def getDataBaseType() -> java.lang.String: ...
    def getResultSet(self, string: typing.Union[java.lang.String, str]) -> java.sql.ResultSet: ...
    def getStatement(self) -> java.sql.Statement: ...
    def openConnection(self) -> java.sql.Connection: ...
    @staticmethod
    def setConnectionString(string: typing.Union[java.lang.String, str]) -> None: ...
    def setCreateTemporaryTables(self, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def setDataBaseType(string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def setDataBaseType(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @staticmethod
    def setPassword(string: typing.Union[java.lang.String, str]) -> None: ...
    def setStatement(self, statement: java.sql.Statement) -> None: ...
    @staticmethod
    def setUsername(string: typing.Union[java.lang.String, str]) -> None: ...

class NeqSimDataBase(jneqsim.neqsim.util.util.FileSystemSettings, java.io.Serializable, java.lang.AutoCloseable):
    dataBasePath: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def close(self) -> None: ...
    @staticmethod
    def createTemporaryTables() -> bool: ...
    def execute(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def executeQuery(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @staticmethod
    def getComponentNames() -> typing.MutableSequence[java.lang.String]: ...
    def getConnection(self) -> java.sql.Connection: ...
    @staticmethod
    def getConnectionString() -> java.lang.String: ...
    @staticmethod
    def getDataBaseType() -> java.lang.String: ...
    def getResultSet(self, string: typing.Union[java.lang.String, str]) -> java.sql.ResultSet: ...
    def getStatement(self) -> java.sql.Statement: ...
    @staticmethod
    def hasComponent(string: typing.Union[java.lang.String, str]) -> bool: ...
    @staticmethod
    def hasTempComponent(string: typing.Union[java.lang.String, str]) -> bool: ...
    @staticmethod
    def initH2DatabaseFromCSVfiles() -> None: ...
    def openConnection(self) -> java.sql.Connection: ...
    @staticmethod
    def replaceTable(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @staticmethod
    def setConnectionString(string: typing.Union[java.lang.String, str]) -> None: ...
    @staticmethod
    def setCreateTemporaryTables(boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def setDataBaseType(string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def setDataBaseType(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @staticmethod
    def setPassword(string: typing.Union[java.lang.String, str]) -> None: ...
    def setStatement(self, statement: java.sql.Statement) -> None: ...
    @staticmethod
    def setUsername(string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def updateTable(string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def updateTable(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...

class NeqSimExperimentDatabase(jneqsim.neqsim.util.util.FileSystemSettings, java.io.Serializable):
    dataBasePath: typing.ClassVar[java.lang.String] = ...
    username: typing.ClassVar[java.lang.String] = ...
    password: typing.ClassVar[java.lang.String] = ...
    connectionString: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def createTemporaryTables(self) -> bool: ...
    def execute(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getConnection(self) -> java.sql.Connection: ...
    @staticmethod
    def getConnectionString() -> java.lang.String: ...
    @staticmethod
    def getDataBaseType() -> java.lang.String: ...
    def getResultSet(self, string: typing.Union[java.lang.String, str]) -> java.sql.ResultSet: ...
    def getStatement(self) -> java.sql.Statement: ...
    def openConnection(self) -> java.sql.Connection: ...
    @staticmethod
    def setConnectionString(string: typing.Union[java.lang.String, str]) -> None: ...
    def setCreateTemporaryTables(self, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def setDataBaseType(string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def setDataBaseType(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @staticmethod
    def setPassword(string: typing.Union[java.lang.String, str]) -> None: ...
    def setStatement(self, statement: java.sql.Statement) -> None: ...
    @staticmethod
    def setUsername(string: typing.Union[java.lang.String, str]) -> None: ...

class NeqSimFluidDataBase(jneqsim.neqsim.util.util.FileSystemSettings, java.io.Serializable):
    useOnlineBase: typing.ClassVar[bool] = ...
    def __init__(self): ...
    def execute(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getConnection(self) -> java.sql.Connection: ...
    @typing.overload
    def getResultSet(self, string: typing.Union[java.lang.String, str]) -> java.sql.ResultSet: ...
    @typing.overload
    def getResultSet(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> java.sql.ResultSet: ...
    def openConnection(self, string: typing.Union[java.lang.String, str]) -> java.sql.Connection: ...

class NeqSimContractDataBase(NeqSimDataBase):
    dataBasePath: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @staticmethod
    def initH2DatabaseFromCSVfiles() -> None: ...
    @typing.overload
    @staticmethod
    def updateTable(string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def updateTable(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...

class NeqSimProcessDesignDataBase(NeqSimDataBase):
    dataBasePath: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @staticmethod
    def initH2DatabaseFromCSVfiles() -> None: ...
    @typing.overload
    @staticmethod
    def updateTable(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def updateTable(string: typing.Union[java.lang.String, str]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.util.database")``.

    AspenIP21Database: typing.Type[AspenIP21Database]
    NeqSimBlobDatabase: typing.Type[NeqSimBlobDatabase]
    NeqSimContractDataBase: typing.Type[NeqSimContractDataBase]
    NeqSimDataBase: typing.Type[NeqSimDataBase]
    NeqSimExperimentDatabase: typing.Type[NeqSimExperimentDatabase]
    NeqSimFluidDataBase: typing.Type[NeqSimFluidDataBase]
    NeqSimProcessDesignDataBase: typing.Type[NeqSimProcessDesignDataBase]
