# AI Features Documentation

## 📚 Main Documentation

**All AI features are now documented in one comprehensive guide:**

👉 **[PRAISONAI.md](./PRAISONAI.md)** - Complete PraisonAI Integration Guide

This single document contains everything you need:
- Quick Start
- Installation
- Features Overview
- Architecture
- Usage Examples
- Configuration
- Production Features
- API Reference
- Cost & Performance
- Testing
- Troubleshooting
- Advanced Topics

## 🚀 Quick Links

### Getting Started
- [Quick Start](./PRAISONAI.md#quick-start)
- [Installation](./PRAISONAI.md#installation)
- [Basic Usage](./PRAISONAI.md#usage-examples)

### Reference
- [API Reference](./PRAISONAI.md#api-reference)
- [Configuration](./PRAISONAI.md#configuration)
- [Troubleshooting](./PRAISONAI.md#troubleshooting)

### Advanced
- [Architecture](./PRAISONAI.md#architecture)
- [Production Features](./PRAISONAI.md#production-features)
- [Advanced Topics](./PRAISONAI.md#advanced-topics)

## 📋 Other Documentation

- **[CHANGELOG.md](./CHANGELOG.md)** - Version history and changes
- **[RELEASE_NOTES_v1.1.0.md](./RELEASE_NOTES_v1.1.0.md)** - Current release notes
- **[RELEASE_CHECKLIST.md](./RELEASE_CHECKLIST.md)** - Release process guide

## 💡 Quick Start

```bash
# Install with AI features
pip install praisonaiwp[ai]

# Set API key
export OPENAI_API_KEY="sk-..."

# Generate content
praisonaiwp ai generate "AI Trends 2025"

# Generate and publish
praisonaiwp ai generate "AI Trends" \
  --title "The Future of AI" \
  --auto-publish \
  --status publish
```

For complete documentation, see **[PRAISONAI.md](./PRAISONAI.md)**
