"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.oc_connection_cluster import OcConnectionCluster
from reconcile.gql_definitions.fragments.serviceaccount_token import ServiceAccountToken


DEFINITION = """
fragment CommonJumphostFields on ClusterJumpHost_v1 {
  hostname
  knownHosts
  user
  port
  remotePort
  identity {
    ... VaultSecret
  }
}

fragment OcConnectionCluster on Cluster_v1 {
  name
  serverUrl
  internal
  insecureSkipTLSVerify
  jumpHost {
    ...CommonJumphostFields
  }
  automationToken {
    ...VaultSecret
  }
  clusterAdminAutomationToken {
    ...VaultSecret
  }
  disable {
    integrations
  }
}

fragment ServiceAccountToken on ServiceAccountTokenSpec_v1 {
  name
  serviceAccountName
  namespace {
    name
    delete
    cluster {
      ...OcConnectionCluster
    }
  }
}

fragment VaultSecret on VaultSecret_v1 {
    path
    field
    version
    format
}

query ServiceAccountTokens {
  namespaces: namespaces_v1 {
    name
    delete
    cluster {
      ...OcConnectionCluster
    }
    sharedResources {
      openshiftServiceAccountTokens {
        ...ServiceAccountToken
      }
    }
    openshiftServiceAccountTokens {
      ...ServiceAccountToken
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class SharedResourcesV1(ConfiguredBaseModel):
    openshift_service_account_tokens: Optional[list[ServiceAccountToken]] = Field(..., alias="openshiftServiceAccountTokens")


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    delete: Optional[bool] = Field(..., alias="delete")
    cluster: OcConnectionCluster = Field(..., alias="cluster")
    shared_resources: Optional[list[SharedResourcesV1]] = Field(..., alias="sharedResources")
    openshift_service_account_tokens: Optional[list[ServiceAccountToken]] = Field(..., alias="openshiftServiceAccountTokens")


class ServiceAccountTokensQueryData(ConfiguredBaseModel):
    namespaces: Optional[list[NamespaceV1]] = Field(..., alias="namespaces")


def query(query_func: Callable, **kwargs: Any) -> ServiceAccountTokensQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        ServiceAccountTokensQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return ServiceAccountTokensQueryData(**raw_data)
