/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Client;

import com.google.gson.JsonObject;
import com.microsoft.Malmo.Client.ClientState;
import com.microsoft.Malmo.Client.MalmoEnvServer;
import com.microsoft.Malmo.Client.MalmoModClient;
import com.microsoft.Malmo.Client.VideoHook;
import com.microsoft.Malmo.Client.VideoProducedObserver;
import com.microsoft.Malmo.IState;
import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.IVideoProducer;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.Schemas.AgentSection;
import com.microsoft.Malmo.Schemas.AgentStart;
import com.microsoft.Malmo.Schemas.ClientAgentConnection;
import com.microsoft.Malmo.Schemas.MinecraftServerConnection;
import com.microsoft.Malmo.Schemas.Mission;
import com.microsoft.Malmo.Schemas.MissionDiagnostics;
import com.microsoft.Malmo.Schemas.MissionEnded;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.MissionResult;
import com.microsoft.Malmo.Schemas.ModSettings;
import com.microsoft.Malmo.Schemas.PosAndDirection;
import com.microsoft.Malmo.Schemas.Reward;
import com.microsoft.Malmo.StateEpisode;
import com.microsoft.Malmo.StateMachine;
import com.microsoft.Malmo.Utils.AddressHelper;
import com.microsoft.Malmo.Utils.AuthenticationHelper;
import com.microsoft.Malmo.Utils.SchemaHelper;
import com.microsoft.Malmo.Utils.ScoreHelper;
import com.microsoft.Malmo.Utils.ScreenHelper;
import com.microsoft.Malmo.Utils.TCPInputPoller;
import com.microsoft.Malmo.Utils.TCPSocketChannel;
import com.microsoft.Malmo.Utils.TCPUtils;
import com.microsoft.Malmo.Utils.TextureHelper;
import com.microsoft.Malmo.Utils.TimeHelper;
import com.mojang.authlib.properties.Property;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.xml.sax.SAXException;

public class ClientStateMachine
extends StateMachine
implements MalmoMod.IMalmoMessageListener {
    private static final int WAIT_MAX_TICKS = 2000;
    private static final int VIDEO_MAX_WAIT = 90000;
    private static final String MISSING_MCP_PORT_ERROR = "no_mcp";
    private static final String INFO_MCP_PORT = "info_mcp";
    private static final String INFO_RESERVE_STATUS = "info_reservation";
    private MissionInit currentMissionInit = null;
    private MissionBehaviour missionBehaviour = new MissionBehaviour();
    private String missionQuitCode = "";
    private MultidimensionalReward finalReward = new MultidimensionalReward(true);
    private MissionDiagnostics missionEndedData = new MissionDiagnostics();
    private ScreenHelper screenHelper = new ScreenHelper();
    protected MalmoModClient inputController;
    protected MalmoEnvServer envServer;
    protected TCPInputPoller missionPoller;
    protected TCPInputPoller controlInputPoller;
    protected int integratedServerPort;
    String reservationID = "";
    long reservationExpirationTime = 0L;
    private TCPSocketChannel missionControlSocket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveClient(String id) {
        String string = this.reservationID;
        synchronized (string) {
            this.getScreenHelper().clearFragment(INFO_RESERVE_STATUS);
            int separator = id.indexOf(":");
            if (separator == -1) {
                System.out.println("Error - malformed reservation request - client will not be reserved.");
                this.reservationID = "";
            } else {
                long duration = Long.valueOf(id.substring(0, separator));
                String expID = id.substring(separator + 1);
                this.reservationExpirationTime = System.currentTimeMillis() + duration;
                this.reservationID = "RESERVED" + expID;
                this.getScreenHelper().addFragment("Reserved: " + expID, ScreenHelper.TextCategory.TXT_INFO, (int)duration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReserved() {
        String string = this.reservationID;
        synchronized (string) {
            System.out.println("==== RES: " + this.reservationID + " - " + (this.reservationExpirationTime - System.currentTimeMillis()));
            return !this.reservationID.isEmpty() && this.reservationExpirationTime > System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAvailable(String id) {
        String string = this.reservationID;
        synchronized (string) {
            return this.reservationID.isEmpty() || this.reservationID.equals("RESERVED" + id) || System.currentTimeMillis() >= this.reservationExpirationTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelReservation() {
        String string = this.reservationID;
        synchronized (string) {
            this.reservationID = "";
            this.getScreenHelper().clearFragment(INFO_RESERVE_STATUS);
        }
    }

    protected TCPSocketChannel getMissionControlSocket() {
        return this.missionControlSocket;
    }

    protected void createMissionControlSocket() {
        TCPUtils.LogSection ls = new TCPUtils.LogSection("Creating MissionControlSocket");
        ClientAgentConnection cac = this.currentMissionInit().getClientAgentConnection();
        if (!(this.missionControlSocket != null && this.missionControlSocket.getPort() == cac.getAgentMissionControlPort() && this.missionControlSocket.getAddress() != null && this.missionControlSocket.isValid() && this.missionControlSocket.isOpen() && this.missionControlSocket.getAddress().equals(cac.getAgentIPAddress()))) {
            if (this.missionControlSocket != null) {
                this.missionControlSocket.close();
            }
            this.missionControlSocket = new TCPSocketChannel(cac.getAgentIPAddress(), cac.getAgentMissionControlPort(), "mcp");
        }
        ls.close();
    }

    public ClientStateMachine(ClientState initialState, MalmoModClient inputController) {
        super(initialState);
        this.inputController = inputController;
        MinecraftForge.EVENT_BUS.register((Object)this);
        MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_TEXT);
    }

    @Override
    public void clearErrorDetails() {
        super.clearErrorDetails();
        this.missionQuitCode = "";
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        this.updateState();
    }

    public ScreenHelper getScreenHelper() {
        return this.screenHelper;
    }

    @Override
    public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
        if (messageType == MalmoMod.MalmoMessageType.SERVER_TEXT) {
            String chat = data.get("chat");
            if (chat != null) {
                Minecraft.getMinecraft().ingameGUI.getChatGUI().printChatMessageWithOptionalDeletion((ITextComponent)new TextComponentString(chat), 1);
            } else {
                String text = data.get("text");
                ScreenHelper.TextCategory category = ScreenHelper.TextCategory.valueOf(data.get("category"));
                String strtime = data.get("displayTime");
                Integer time = strtime != null ? Integer.valueOf(strtime) : null;
                this.getScreenHelper().addFragment(text, category, time);
            }
        }
    }

    @Override
    protected String getName() {
        return "CLIENT";
    }

    @Override
    protected void onPreStateChange(IState toState) {
        this.getScreenHelper().addFragment("CLIENT: " + toState, ScreenHelper.TextCategory.TXT_CLIENT_STATE, "");
    }

    @Override
    protected StateEpisode getStateEpisodeForState(IState state) {
        if (!(state instanceof ClientState)) {
            return null;
        }
        ClientState cs = (ClientState)state;
        switch (cs) {
            case WAITING_FOR_MOD_READY: {
                return new InitialiseClientModEpisode(this);
            }
            case DORMANT: {
                return new DormantEpisode(this);
            }
            case CREATING_HANDLERS: {
                return new CreateHandlersEpisode(this);
            }
            case EVALUATING_WORLD_REQUIREMENTS: {
                return new EvaluateWorldRequirementsEpisode(this);
            }
            case PAUSING_OLD_SERVER: {
                return new PauseOldServerEpisode(this);
            }
            case CLOSING_OLD_SERVER: {
                return new CloseOldServerEpisode(this);
            }
            case CREATING_NEW_WORLD: {
                return new CreateWorldEpisode(this);
            }
            case WAITING_FOR_SERVER_READY: {
                return new WaitingForServerEpisode(this);
            }
            case RUNNING: {
                return new MissionRunningEpisode(this);
            }
            case IDLING: {
                return new MissionIdlingEpisode(this);
            }
            case MISSION_ENDED: {
                return new MissionEndedEpisode(this, MissionResult.ENDED, false, false, true);
            }
            case ERROR_DUFF_HANDLERS: {
                return new MissionEndedEpisode(this, MissionResult.MOD_FAILED_TO_INSTANTIATE_HANDLERS, true, true, true);
            }
            case ERROR_INTEGRATED_SERVER_UNREACHABLE: {
                return new MissionEndedEpisode(this, MissionResult.MOD_SERVER_UNREACHABLE, true, true, true);
            }
            case ERROR_NO_WORLD: {
                return new MissionEndedEpisode(this, MissionResult.MOD_HAS_NO_WORLD_LOADED, true, true, true);
            }
            case ERROR_CANNOT_CREATE_WORLD: {
                return new MissionEndedEpisode(this, MissionResult.MOD_FAILED_TO_CREATE_WORLD, true, true, true);
            }
            case ERROR_CANNOT_START_AGENT: 
            case ERROR_LOST_AGENT: 
            case ERROR_LOST_VIDEO: {
                return new MissionEndedEpisode(this, MissionResult.MOD_HAS_NO_AGENT_AVAILABLE, true, true, false);
            }
            case ERROR_LOST_NETWORK_CONNECTION: 
            case ERROR_CANNOT_CONNECT_TO_SERVER: {
                return new MissionEndedEpisode(this, MissionResult.MOD_CONNECTION_FAILED, true, false, true);
            }
            case ERROR_TIMED_OUT_WAITING_FOR_EPISODE_START: 
            case ERROR_TIMED_OUT_WAITING_FOR_EPISODE_PAUSE: 
            case ERROR_TIMED_OUT_WAITING_FOR_EPISODE_CLOSE: 
            case ERROR_TIMED_OUT_WAITING_FOR_MISSION_END: 
            case ERROR_TIMED_OUT_WAITING_FOR_WORLD_CREATE: {
                return new MissionEndedEpisode(this, MissionResult.MOD_CONNECTION_FAILED, true, true, true);
            }
            case MISSION_ABORTED: {
                return new MissionEndedEpisode(this, MissionResult.MOD_SERVER_ABORTED_MISSION, true, false, true);
            }
            case WAITING_FOR_SERVER_MISSION_END: {
                return new WaitingForServerMissionEndEpisode(this);
            }
        }
        return null;
    }

    protected MissionInit currentMissionInit() {
        return this.currentMissionInit;
    }

    protected MissionBehaviour currentMissionBehaviour() {
        return this.missionBehaviour;
    }

    protected MissionInitResult decodeMissionInit(String command) {
        MissionInitResult result = new MissionInitResult();
        if (command == null) {
            result.error = "Null command passed.";
            return result;
        }
        String rootNodeName = SchemaHelper.getRootNodeName(command);
        if (rootNodeName != null && rootNodeName.equals("MissionInit")) {
            result.wasMissionInit = true;
            try {
                result.missionInit = (MissionInit)SchemaHelper.deserialiseObject(command, "MissionInit.xsd", MissionInit.class);
            }
            catch (JAXBException e) {
                System.out.println("JAXB exception: " + (Object)((Object)e));
                result.error = e.getMessage() != null ? e.getMessage() : (e.getLinkedException() != null && e.getLinkedException().getMessage() != null ? e.getLinkedException().getMessage() : "Unspecified problem parsing MissionInit - check your Mission xml.");
            }
            catch (SAXException e) {
                System.out.println("SAX exception: " + e);
                result.error = e.getMessage();
            }
            catch (XMLStreamException e) {
                System.out.println("XMLStreamException: " + e);
                result.error = e.getMessage();
            }
        }
        return result;
    }

    protected boolean areMissionsEqual(Mission m1, Mission m2) {
        return true;
    }

    protected void initialiseComms() throws UnknownHostException {
        if (this.missionPoller != null) {
            this.missionPoller.stopServer();
        }
        this.missionPoller = new TCPInputPoller(AddressHelper.getMissionControlPortOverride(), 10000, 11000, true, "mcp"){

            @Override
            public void onError(String error, DataOutputStream dos) {
                System.out.println("SENDING ERROR: " + error);
                try {
                    dos.writeInt(error.length());
                    dos.writeBytes(error);
                    dos.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            private void reply(String reply, DataOutputStream dos) {
                System.out.println("REPLYING WITH: " + reply);
                try {
                    dos.writeInt(reply.length());
                    dos.writeBytes(reply);
                    dos.flush();
                }
                catch (IOException e) {
                    System.out.println("Failed to reply to message!");
                }
            }

            @Override
            public boolean onCommand(String command, String ipFrom, DataOutputStream dos) {
                System.out.println("Received from " + ipFrom + ":" + command.substring(0, Math.min(command.length(), 1024)));
                boolean keepProcessing = false;
                String reservePrefixGeneral = "MALMO_REQUEST_CLIENT:";
                String reservePrefix = reservePrefixGeneral + Loader.instance().activeModContainer().getVersion() + ":";
                String findServerPrefix = "MALMO_FIND_SERVER";
                String cancelRequestCommand = "MALMO_CANCEL_REQUEST";
                String killClientCommand = "MALMO_KILL_CLIENT";
                if (command.startsWith(reservePrefix)) {
                    IState currentState = ClientStateMachine.this.getStableState();
                    if (currentState != null && currentState.equals(ClientState.DORMANT) && !ClientStateMachine.this.isReserved()) {
                        ClientStateMachine.this.reserveClient(command.substring(reservePrefix.length()));
                        this.reply("MALMOOK", dos);
                    } else {
                        this.reply("MALMOBUSY", dos);
                    }
                } else if (command.startsWith(reservePrefixGeneral)) {
                    this.reply("MALMOERRORVERSIONMISMATCH in reservation string (Got " + command + ", expected " + reservePrefix + " - check your path for old versions of MalmoPython/MalmoJava/Malmo.lib etc)", dos);
                } else if (command.equals(cancelRequestCommand)) {
                    if (ClientStateMachine.this.isReserved()) {
                        ClientStateMachine.this.cancelReservation();
                        this.reply("MALMOOK", dos);
                    } else {
                        this.reply("MALMOERRORAttempt to cancel a reservation that was never made.", dos);
                    }
                } else if (command.startsWith(findServerPrefix)) {
                    String expID = command.substring(findServerPrefix.length());
                    if (ClientStateMachine.this.currentMissionInit() != null && ClientStateMachine.this.currentMissionInit().getExperimentUID().equals(expID)) {
                        MinecraftServerConnection msc = ClientStateMachine.this.currentMissionInit().getMinecraftServerConnection();
                        if (msc == null) {
                            this.reply("MALMONOSERVERYET", dos);
                        } else {
                            this.reply("MALMOS" + msc.getAddress().trim() + ":" + msc.getPort(), dos);
                        }
                    } else {
                        this.reply("MALMONOSERVER", dos);
                    }
                } else if (command.equals(killClientCommand)) {
                    IState currentState = ClientStateMachine.this.getStableState();
                    if (currentState != null && currentState.equals(ClientState.DORMANT) && !ClientStateMachine.this.isReserved()) {
                        Configuration config = MalmoMod.instance.getModSessionConfigFile();
                        if (config.getBoolean("replaceable", "runtype", false, "Will be replaced if killed")) {
                            this.reply("MALMOOK", dos);
                            ClientStateMachine.this.missionPoller.stopServer();
                            ClientStateMachine.exitJava();
                        } else {
                            this.reply("MALMOERRORNOTKILLABLE", dos);
                        }
                    } else {
                        this.reply("MALMOBUSY", dos);
                    }
                } else {
                    MissionInitResult missionInitResult = ClientStateMachine.this.decodeMissionInit(command);
                    if (missionInitResult.wasMissionInit && missionInitResult.missionInit == null) {
                        this.reply("MALMOERROR" + missionInitResult.error, dos);
                    } else if (missionInitResult.wasMissionInit && missionInitResult.missionInit != null) {
                        MissionInit missionInit = missionInitResult.missionInit;
                        String platformVersion = missionInit.getPlatformVersion();
                        String ourVersion = Loader.instance().activeModContainer().getVersion();
                        if (platformVersion == null || !platformVersion.equals(ourVersion)) {
                            this.reply("MALMOERRORVERSIONMISMATCH (Got " + platformVersion + ", expected " + ourVersion + " - check your path for old versions of MalmoPython/MalmoJava/Malmo.lib etc)", dos);
                        } else {
                            IState currentState = ClientStateMachine.this.getStableState();
                            if (currentState != null && currentState.equals(ClientState.DORMANT) && ClientStateMachine.this.isAvailable(missionInit.getExperimentUID())) {
                                this.reply("MALMOOK", dos);
                                keepProcessing = true;
                            } else {
                                this.reply("MALMOBUSY", dos);
                            }
                        }
                    }
                }
                return keepProcessing;
            }
        };
        int mcPort = 0;
        if (MalmoEnvServer.isEnv()) {
            System.out.println("***** Start MalmoEnvServer on port " + AddressHelper.getMissionControlPortOverride());
            this.envServer = new MalmoEnvServer(Loader.instance().activeModContainer().getVersion(), AddressHelper.getMissionControlPortOverride(), this.missionPoller);
            Thread thread = new Thread("MalmoEnvServer"){

                @Override
                public void run() {
                    try {
                        ClientStateMachine.this.envServer.serve();
                    }
                    catch (IOException ioe) {
                        System.out.println("MalmoEnvServer exist on " + ioe);
                    }
                }
            };
            thread.start();
        } else {
            this.missionPoller.start();
            mcPort = this.missionPoller.getPortBlocking();
        }
        AddressHelper.setMissionControlPort(mcPort);
        if (AddressHelper.getMissionControlPort() == -1) {
            System.out.println("**** NO MISSION CONTROL SOCKET CREATED - WAS THE PORT IN USE? (Check Mod GUI options) ****");
            this.getScreenHelper().addFragment("ERROR: Could not open a Mission Control Port - check the Mod GUI options.", ScreenHelper.TextCategory.TXT_CLIENT_WARNING, MISSING_MCP_PORT_ERROR);
        } else {
            this.getScreenHelper().clearFragment(MISSING_MCP_PORT_ERROR);
        }
        this.getScreenHelper().clearFragment(INFO_MCP_PORT);
        if (AddressHelper.getMissionControlPort() != -1) {
            this.getScreenHelper().addFragment("MCP: " + AddressHelper.getMissionControlPort(), ScreenHelper.TextCategory.TXT_INFO, INFO_MCP_PORT);
        }
    }

    public static void exitJava() {
        Thread deadMansHandle = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 10; i > 0; --i) {
                    try {
                        Thread.sleep(1000L);
                        System.out.println("Waiting to exit " + i + "...");
                        continue;
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted " + i + "...");
                    }
                }
                System.out.println("Attempting hard exit");
                FMLCommonHandler.instance().exitJava(0, true);
            }
        });
        deadMansHandle.setDaemon(true);
        deadMansHandle.start();
        FMLCommonHandler.instance().exitJava(0, false);
    }

    public class MissionEndedEpisode
    extends ConfigAwareStateEpisode {
        private MissionResult result;
        private boolean aborting;
        private boolean informServer;
        private boolean informAgent;
        private int totalTicks;

        public MissionEndedEpisode(ClientStateMachine machine, MissionResult mr, boolean aborting, boolean informServer, boolean informAgent) {
            super(machine);
            this.totalTicks = 0;
            this.result = mr;
            this.aborting = aborting;
            this.informServer = informServer;
            this.informAgent = informAgent;
        }

        @Override
        protected void execute() {
            this.totalTicks = 0;
            TimeHelper.SyncManager.setSynchronous(false);
            String errorFeedback = ClientStateMachine.this.getErrorDetails();
            String quitFeedback = ClientStateMachine.this.missionQuitCode;
            String concatenation = errorFeedback != null && !errorFeedback.isEmpty() && quitFeedback != null && !quitFeedback.isEmpty() ? ";\n" : "";
            String report = quitFeedback + concatenation + errorFeedback;
            if (this.informServer) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (Minecraft.getMinecraft().player != null) {
                    map.put("username", Minecraft.getMinecraft().player.getName());
                }
                map.put("error", ClientStateMachine.this.getErrorDetails());
                MalmoMod.network.sendToServer((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.CLIENT_BAILED, 0, map));
            }
            if (this.informAgent) {
                MissionEnded missionEnded = new MissionEnded();
                missionEnded.setStatus(this.result);
                if (ClientStateMachine.this.missionQuitCode != null && ClientStateMachine.this.missionQuitCode.equals("MALMO_AGENT_DIED")) {
                    missionEnded.setStatus(MissionResult.PLAYER_DIED);
                }
                missionEnded.setHumanReadableStatus(report);
                if (!ClientStateMachine.this.finalReward.isEmpty()) {
                    if (ClientStateMachine.this.envServer != null) {
                        ClientStateMachine.this.envServer.addRewards(ClientStateMachine.this.finalReward.getRewardTotal());
                    }
                    missionEnded.setReward(ClientStateMachine.this.finalReward.getAsReward());
                    ClientStateMachine.this.finalReward.clear();
                }
                missionEnded.setMissionDiagnostics(ClientStateMachine.this.missionEndedData);
                ClientStateMachine.this.missionEndedData = new MissionDiagnostics();
                System.out.println("inform the agent");
                this.sendMissionEnded(missionEnded);
            }
            if (this.aborting) {
                this.episodeHasCompleted(ClientState.DORMANT);
            }
        }

        private void sendMissionEnded(MissionEnded missionEnded) {
            String missionEndedString = null;
            try {
                missionEndedString = SchemaHelper.serialiseObject(missionEnded, MissionEnded.class);
                if (ScoreHelper.isScoring()) {
                    Reward reward = missionEnded.getReward();
                    if (reward == null) {
                        reward = new Reward();
                    }
                    ScoreHelper.logMissionEndRewards(reward);
                }
            }
            catch (JAXBException e) {
                TCPUtils.Log(Level.SEVERE, "Failed mission end XML serialization: " + (Object)((Object)e));
            }
            boolean sentOkay = false;
            if (missionEndedString != null) {
                if (AddressHelper.getMissionControlPort() == 0) {
                    sentOkay = true;
                    if (ClientStateMachine.this.envServer != null) {
                        ClientStateMachine.this.envServer.endMission();
                    }
                } else {
                    TCPSocketChannel sender = ClientStateMachine.this.getMissionControlSocket();
                    System.out.println(String.format("Sending mission ended message to %s:%d.", sender.getAddress(), sender.getPort()));
                    sentOkay = sender.sendTCPString(missionEndedString);
                    sender.close();
                }
            }
            if (!sentOkay) {
                ClientStateMachine.this.getScreenHelper().addFragment("ERROR: Could not send mission ended message - agent may need manually resetting.", ScreenHelper.TextCategory.TXT_CLIENT_WARNING, 10000);
            }
        }

        @Override
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (!this.aborting) {
                this.episodeHasCompleted(ClientState.WAITING_FOR_SERVER_MISSION_END);
            }
            if (++this.totalTicks > 2000) {
                String msg = "Too long waiting for server to end mission.";
                TCPUtils.Log(Level.SEVERE, msg);
                this.episodeHasCompletedWithErrors(ClientState.ERROR_TIMED_OUT_WAITING_FOR_MISSION_END, msg);
            }
        }
    }

    public class MissionRunningEpisode
    extends ConfigAwareStateEpisode
    implements VideoProducedObserver {
        public static final int FailedTCPSendCountTolerance = 3;
        boolean serverHasFiredStartingPistol;
        boolean playerDied;
        private int failedTCPRewardSendCount;
        private int failedTCPObservationSendCount;
        private boolean wantsToQuit;
        private List<VideoHook> videoHooks;
        private String quitCode;
        private TCPSocketChannel observationSocket;
        private TCPSocketChannel rewardSocket;
        private long lastPingSent;
        private long pingFrequencyMs;
        private long frameTimestamp;

        protected MissionRunningEpisode(ClientStateMachine machine) {
            super(machine);
            this.serverHasFiredStartingPistol = false;
            this.playerDied = false;
            this.failedTCPRewardSendCount = 0;
            this.failedTCPObservationSendCount = 0;
            this.wantsToQuit = false;
            this.videoHooks = new ArrayList<VideoHook>();
            this.quitCode = "";
            this.observationSocket = null;
            this.rewardSocket = null;
            this.lastPingSent = 0L;
            this.pingFrequencyMs = 1000L;
            this.frameTimestamp = 0L;
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_STOPAGENTS);
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_GO);
        }

        @Override
        public void frameProduced() {
            this.frameTimestamp = System.currentTimeMillis();
        }

        protected void onMissionStarted() {
            this.frameTimestamp = 0L;
            this.openSockets();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("username", Minecraft.getMinecraft().player.getName());
            MalmoMod.network.sendToServer((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.CLIENT_AGENTRUNNING, 0, map));
            if (ClientStateMachine.this.currentMissionBehaviour().commandHandler != null) {
                ClientStateMachine.this.currentMissionBehaviour().commandHandler.install(ClientStateMachine.this.currentMissionInit());
                ClientStateMachine.this.currentMissionBehaviour().commandHandler.setOverriding(true);
            }
            if (ClientStateMachine.this.currentMissionBehaviour().observationProducer != null) {
                ClientStateMachine.this.currentMissionBehaviour().observationProducer.prepare(ClientStateMachine.this.currentMissionInit());
            }
            if (ClientStateMachine.this.currentMissionBehaviour().quitProducer != null) {
                ClientStateMachine.this.currentMissionBehaviour().quitProducer.prepare(ClientStateMachine.this.currentMissionInit());
            }
            if (ClientStateMachine.this.currentMissionBehaviour().rewardProducer != null) {
                ClientStateMachine.this.currentMissionBehaviour().rewardProducer.prepare(ClientStateMachine.this.currentMissionInit());
            }
            for (IVideoProducer videoProducer : ClientStateMachine.this.currentMissionBehaviour().videoProducers) {
                VideoHook hook = new VideoHook();
                this.videoHooks.add(hook);
                this.frameProduced();
                hook.start(ClientStateMachine.this.currentMissionInit(), videoProducer, this, ClientStateMachine.this.envServer);
            }
            ClientStateMachine.this.inputController.setInputType(MalmoModClient.InputType.AI);
            Minecraft.getMinecraft().inGameHasFocus = true;
            ModSettings modsettings = ClientStateMachine.this.currentMissionInit().getMission().getModSettings();
            if (modsettings != null && modsettings.getMsPerTick() != null) {
                TimeHelper.setMinecraftClientClockSpeed(1000 / modsettings.getMsPerTick());
            }
            if (modsettings != null && modsettings.isPrioritiseOffscreenRendering() == Boolean.TRUE) {
                TimeHelper.displayGranularityMs = 1000L;
            }
            TimeHelper.unpause();
            if (ClientStateMachine.this.envServer != null) {
                if (!ClientStateMachine.this.envServer.doIWantToQuit(ClientStateMachine.this.currentMissionInit())) {
                    TimeHelper.SyncManager.setSynchronous(ClientStateMachine.this.envServer.isSynchronous());
                } else {
                    TimeHelper.SyncManager.setSynchronous(false);
                }
            }
        }

        protected void onMissionEnded(IState nextState, String errorReport) {
            if (ClientStateMachine.this.currentMissionBehaviour().rewardProducer != null) {
                ClientStateMachine.this.currentMissionBehaviour().rewardProducer.cleanup();
            }
            if (ClientStateMachine.this.currentMissionBehaviour().quitProducer != null) {
                ClientStateMachine.this.currentMissionBehaviour().quitProducer.cleanup();
            }
            if (ClientStateMachine.this.currentMissionBehaviour().observationProducer != null) {
                ClientStateMachine.this.currentMissionBehaviour().observationProducer.cleanup();
            }
            if (ClientStateMachine.this.currentMissionBehaviour().commandHandler != null) {
                ClientStateMachine.this.currentMissionBehaviour().commandHandler.setOverriding(false);
                ClientStateMachine.this.currentMissionBehaviour().commandHandler.deinstall(ClientStateMachine.this.currentMissionInit());
            }
            TimeHelper.SyncManager.setPistolFired(false);
            this.closeSockets();
            for (VideoHook hook : this.videoHooks) {
                hook.stop(ClientStateMachine.this.missionEndedData);
            }
            TimeHelper.setMinecraftClientClockSpeed(20.0f);
            TimeHelper.displayGranularityMs = 0L;
            TimeHelper.unpause();
            TimeHelper.SyncManager.setSynchronous(false);
            ClientStateMachine.this.missionQuitCode = this.quitCode;
            if (errorReport != null) {
                this.episodeHasCompletedWithErrors(nextState, errorReport);
            } else {
                this.episodeHasCompleted(nextState);
            }
        }

        @Override
        protected void execute() {
            this.onMissionStarted();
        }

        @Override
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (!TimeHelper.SyncManager.isSynchronous().booleanValue()) {
                this.onTick(false, event.phase);
            }
        }

        @Override
        public void onSyncTick(TimeHelper.SyncTickEvent ev) {
            this.onTick(true, ev.pos);
        }

        private synchronized void onTick(Boolean synchronous, TickEvent.Phase phase) {
            NetHandlerPlayClient npc;
            if (this.inAbortState()) {
                this.onMissionEnded(ClientState.MISSION_ABORTED, "Mission was aborted by server: " + ClientStateMachine.this.getErrorDetails());
            }
            if ((npc = Minecraft.getMinecraft().getConnection()) == null) {
                if (this.serverHasFiredStartingPistol) {
                    this.onMissionEnded(ClientState.ERROR_LOST_NETWORK_CONNECTION, "Server was closed");
                    return;
                }
            } else {
                NetworkManager netman = npc.getNetworkManager();
                if (netman != null && !netman.hasNoChannel() && !netman.isChannelOpen()) {
                    this.onMissionEnded(ClientState.ERROR_LOST_NETWORK_CONNECTION, "Client was kicked from server - " + netman.getExitMessage().getUnformattedText());
                }
            }
            if (System.currentTimeMillis() > this.lastPingSent + this.pingFrequencyMs) {
                this.lastPingSent = System.currentTimeMillis();
                if (!this.pingAgent(false)) {
                    if (!this.serverHasFiredStartingPistol) {
                        this.onMissionEnded(ClientState.ERROR_LOST_AGENT, "Lost contact with the agent");
                        return;
                    }
                    System.out.println("Error - agent is not responding to pings.");
                    this.wantsToQuit = true;
                    this.quitCode = "MALMO_AGENT_NOT_RESPONDING";
                }
            }
            if (this.frameTimestamp != 0L && System.currentTimeMillis() - this.frameTimestamp > 90000L && !synchronous.booleanValue()) {
                System.out.println("No video produced recently. Aborting mission.");
                if (!this.serverHasFiredStartingPistol) {
                    this.onMissionEnded(ClientState.ERROR_LOST_VIDEO, "No video produced recently.");
                } else {
                    System.out.println("Error - not receiving video.");
                    this.wantsToQuit = true;
                    this.quitCode = "MALMO_VIDEO_NOT_RESPONDING";
                }
            }
            if (Minecraft.getMinecraft().world == null) {
                if (this.serverHasFiredStartingPistol) {
                    this.onMissionEnded(ClientState.ERROR_NO_WORLD, "No world for client. Must be in main menu");
                }
                return;
            }
            if (!this.playerDied && Minecraft.getMinecraft().player.isDead) {
                this.playerDied = true;
                this.quitCode = "MALMO_AGENT_DIED";
            }
            TimeHelper.SyncManager.setPistolFired(this.serverHasFiredStartingPistol);
            if (!this.serverHasFiredStartingPistol) {
                return;
            }
            if (synchronous.booleanValue() && phase == TickEvent.Phase.START) {
                this.checkForControlCommand();
            }
            if (phase == TickEvent.Phase.END) {
                boolean quitHandlerFired;
                IWantToQuit quitHandler = ClientStateMachine.this.currentMissionBehaviour() != null ? ClientStateMachine.this.currentMissionBehaviour().quitProducer : null;
                boolean bl = quitHandlerFired = quitHandler != null && quitHandler.doIWantToQuit(ClientStateMachine.this.currentMissionInit());
                if (quitHandlerFired || this.wantsToQuit || this.playerDied) {
                    if (quitHandlerFired) {
                        this.quitCode = quitHandler.getOutcome();
                    }
                    try {
                        MalmoMod.getPropertiesForCurrentThread().put("QuitCode", this.quitCode);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to get properties - final reward may go missing.");
                    }
                    ClientAgentConnection cac = ClientStateMachine.this.currentMissionInit().getClientAgentConnection();
                    if (ClientStateMachine.this.currentMissionBehaviour() != null && ClientStateMachine.this.currentMissionBehaviour().rewardProducer != null && cac != null) {
                        ClientStateMachine.this.currentMissionBehaviour().rewardProducer.getReward(ClientStateMachine.this.currentMissionInit(), ClientStateMachine.this.finalReward);
                    }
                    List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
                    String agentName = agents.get(ClientStateMachine.this.currentMissionInit().getClientRole()).getName();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("agentname", agentName);
                    map.put("username", Minecraft.getMinecraft().player.getName());
                    map.put("quitcode", this.quitCode);
                    MalmoMod.network.sendToServer((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.CLIENT_AGENTFINISHEDMISSION, 0, map));
                    this.onMissionEnded(ClientState.IDLING, null);
                } else {
                    if (!synchronous.booleanValue()) {
                        this.checkForControlCommand();
                    }
                    this.sendData();
                }
            }
        }

        private void openSockets() {
            ClientAgentConnection cac = ClientStateMachine.this.currentMissionInit().getClientAgentConnection();
            this.observationSocket = new TCPSocketChannel(cac.getAgentIPAddress(), cac.getAgentObservationsPort(), "obs");
            this.rewardSocket = new TCPSocketChannel(cac.getAgentIPAddress(), cac.getAgentRewardsPort(), "rew");
        }

        private void closeSockets() {
            this.observationSocket.close();
            this.rewardSocket.close();
        }

        private void sendData() {
            TCPUtils.LogSection ls = new TCPUtils.LogSection("Sending data");
            Minecraft.getMinecraft().mcProfiler.startSection("malmoSendData");
            String data = "";
            Minecraft.getMinecraft().mcProfiler.startSection("malmoGatherObservationJSON");
            if (ClientStateMachine.this.currentMissionBehaviour() != null && ClientStateMachine.this.currentMissionBehaviour().observationProducer != null) {
                JsonObject json = new JsonObject();
                ClientStateMachine.this.currentMissionBehaviour().observationProducer.writeObservationsToJSON(json, ClientStateMachine.this.currentMissionInit());
                data = json.toString();
            }
            Minecraft.getMinecraft().mcProfiler.endSection();
            Minecraft.getMinecraft().mcProfiler.startSection("malmoSendTCPObservations");
            ClientAgentConnection cac = ClientStateMachine.this.currentMissionInit().getClientAgentConnection();
            if (data != null && data.length() > 2 && cac != null) {
                if (AddressHelper.getMissionControlPort() == 0) {
                    if (ClientStateMachine.this.envServer != null) {
                        ClientStateMachine.this.envServer.observation(data);
                    }
                } else if (this.observationSocket.sendTCPString(data)) {
                    this.failedTCPObservationSendCount = 0;
                } else {
                    ++this.failedTCPObservationSendCount;
                    TCPUtils.Log(Level.WARNING, "Observation signal delivery failure count at " + this.failedTCPObservationSendCount);
                    ClientStateMachine.this.getScreenHelper().addFragment("ERROR: Agent missed observation signal", ScreenHelper.TextCategory.TXT_CLIENT_WARNING, 5000);
                }
            }
            Minecraft.getMinecraft().mcProfiler.endSection();
            Minecraft.getMinecraft().mcProfiler.startSection("malmoGatherRewardSignal");
            if (ClientStateMachine.this.currentMissionBehaviour() != null && ClientStateMachine.this.currentMissionBehaviour().rewardProducer != null && cac != null) {
                MultidimensionalReward reward = new MultidimensionalReward();
                ClientStateMachine.this.currentMissionBehaviour().rewardProducer.getReward(ClientStateMachine.this.currentMissionInit(), reward);
                if (!reward.isEmpty()) {
                    String strReward = reward.getAsSimpleString();
                    Minecraft.getMinecraft().mcProfiler.startSection("malmoSendTCPReward");
                    ScoreHelper.logReward(strReward);
                    if (AddressHelper.getMissionControlPort() == 0) {
                        if (ClientStateMachine.this.envServer != null) {
                            ClientStateMachine.this.envServer.addRewards(reward.getRewardTotal());
                        }
                    } else if (this.rewardSocket.sendTCPString(strReward)) {
                        this.failedTCPRewardSendCount = 0;
                    } else {
                        ++this.failedTCPRewardSendCount;
                        TCPUtils.Log(Level.WARNING, "Reward signal delivery failure count at " + this.failedTCPRewardSendCount);
                        ClientStateMachine.this.getScreenHelper().addFragment("ERROR: Agent missed reward signal", ScreenHelper.TextCategory.TXT_CLIENT_WARNING, 5000);
                    }
                    Minecraft.getMinecraft().mcProfiler.endSection();
                }
            }
            Minecraft.getMinecraft().mcProfiler.endSection();
            Minecraft.getMinecraft().mcProfiler.endSection();
            int maxFailedTCPSendCount = 0;
            for (VideoHook hook : this.videoHooks) {
                if (hook.failedTCPSendCount <= maxFailedTCPSendCount) continue;
                maxFailedTCPSendCount = hook.failedTCPSendCount;
            }
            if (maxFailedTCPSendCount > 0) {
                TCPUtils.Log(Level.WARNING, "Video signal failure count at " + maxFailedTCPSendCount);
            }
            int maxFailed = Math.max(this.failedTCPRewardSendCount, maxFailedTCPSendCount);
            if ((maxFailed = Math.max(maxFailed, this.failedTCPObservationSendCount)) > 3) {
                System.out.println("ERROR: TCP messages are not getting through - quitting mission.");
                this.wantsToQuit = true;
                this.quitCode = "MALMO_AGENT_NOT_RESPONDING";
            }
            ls.close();
        }

        public void checkForControlCommand() {
            Minecraft.getMinecraft().mcProfiler.endStartSection("malmoCommandHandling");
            boolean quitHandlerFired = false;
            IWantToQuit quitHandler = ClientStateMachine.this.currentMissionBehaviour() != null ? ClientStateMachine.this.currentMissionBehaviour().quitProducer : null;
            String command = ClientStateMachine.this.envServer != null ? ClientStateMachine.this.envServer.getCommand() : ClientStateMachine.this.controlInputPoller.getCommand();
            while (command != null && command.length() > 0 && !quitHandlerFired) {
                Minecraft.getMinecraft().mcProfiler.startSection("malmoCommandAct");
                boolean handled = this.handleCommand(command);
                command = ClientStateMachine.this.envServer != null ? ClientStateMachine.this.envServer.getCommand() : ClientStateMachine.this.controlInputPoller.getCommand();
                Minecraft.getMinecraft().mcProfiler.endStartSection("malmoCommandRecheckQuitHandlers");
                if (command != null && command.length() > 0 && handled) {
                    quitHandlerFired = quitHandler != null && quitHandler.doIWantToQuit(ClientStateMachine.this.currentMissionInit());
                }
                Minecraft.getMinecraft().mcProfiler.endSection();
            }
        }

        private boolean handleCommand(String command) {
            if (ClientStateMachine.this.currentMissionBehaviour() != null && ClientStateMachine.this.currentMissionBehaviour().commandHandler != null) {
                return ClientStateMachine.this.currentMissionBehaviour().commandHandler.execute(command, ClientStateMachine.this.currentMissionInit());
            }
            return false;
        }

        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            super.onMessage(messageType, data);
            if (messageType == MalmoMod.MalmoMessageType.SERVER_STOPAGENTS) {
                this.quitCode = data.containsKey("QuitCode") ? data.get("QuitCode") : "";
                try {
                    MalmoMod.getPropertiesForCurrentThread().put("QuitCode", this.quitCode);
                }
                catch (Exception e) {
                    System.out.println("Failed to get properties - final reward may go missing.");
                }
                ClientAgentConnection cac = ClientStateMachine.this.currentMissionInit().getClientAgentConnection();
                if (ClientStateMachine.this.currentMissionBehaviour() != null && ClientStateMachine.this.currentMissionBehaviour().rewardProducer != null && cac != null) {
                    ClientStateMachine.this.currentMissionBehaviour().rewardProducer.getReward(ClientStateMachine.this.currentMissionInit(), ClientStateMachine.this.finalReward);
                }
                this.onMissionEnded(ClientState.MISSION_ENDED, null);
            } else if (messageType == MalmoMod.MalmoMessageType.SERVER_GO) {
                List lel = Minecraft.getMinecraft().world.loadedEntityList;
                for (int i = 0; i < lel.size(); ++i) {
                    Entity entity = (Entity)lel.get(i);
                    Chunk chunk = Minecraft.getMinecraft().world.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ);
                    ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>();
                    for (int k = 0; k < chunk.getEntityLists().length; ++k) {
                        for (Entity chunkent : chunk.getEntityLists()[k]) {
                            if (chunkent.getEntityId() != entity.getEntityId()) continue;
                            entitiesToRemove.add(chunkent);
                        }
                    }
                    for (Entity removeEnt : entitiesToRemove) {
                        chunk.removeEntity(removeEnt);
                    }
                    entity.addedToChunk = false;
                    if (entity instanceof EntityLivingBase) {
                        ((EntityLivingBase)entity).renderYawOffset = entity.rotationYaw;
                        ((EntityLivingBase)entity).prevRenderYawOffset = entity.rotationYaw;
                    }
                    if (!(entity instanceof EntityPlayerSP)) continue;
                    entity.setInvisible(false);
                }
                this.serverHasFiredStartingPistol = true;
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_STOPAGENTS);
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_GO);
        }
    }

    public class MissionIdlingEpisode
    extends ConfigAwareStateEpisode {
        int totalTicks;

        protected MissionIdlingEpisode(ClientStateMachine machine) {
            super(machine);
            this.totalTicks = 0;
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_STOPAGENTS);
        }

        @Override
        protected void execute() {
            this.totalTicks = 0;
            TimeHelper.SyncManager.numTicks = 0L;
        }

        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            super.onMessage(messageType, data);
            if (messageType == MalmoMod.MalmoMessageType.SERVER_STOPAGENTS) {
                this.episodeHasCompleted(ClientState.MISSION_ENDED);
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_STOPAGENTS);
        }

        @Override
        public void onClientTick(TickEvent.ClientTickEvent ev) {
            if (this.inAbortState()) {
                this.episodeHasCompleted(ClientState.MISSION_ABORTED);
            }
            ++this.totalTicks;
        }
    }

    public class CreateWorldEpisode
    extends ConfigAwareStateEpisode {
        boolean serverStarted;
        boolean worldCreated;
        int totalTicks;

        CreateWorldEpisode(ClientStateMachine machine) {
            super(machine);
            this.serverStarted = false;
            this.worldCreated = false;
            this.totalTicks = 0;
        }

        @Override
        protected void execute() {
            try {
                this.totalTicks = 0;
                MissionBehaviour serverHandlers = MissionBehaviour.createServerHandlersFromMissionInit(ClientStateMachine.this.currentMissionInit());
                if (serverHandlers != null && serverHandlers.worldGenerator != null) {
                    if (serverHandlers.worldGenerator.createWorld(ClientStateMachine.this.currentMissionInit())) {
                        this.worldCreated = true;
                        if (Minecraft.getMinecraft().getIntegratedServer() != null) {
                            Minecraft.getMinecraft().getIntegratedServer().setOnlineMode(false);
                        }
                    } else {
                        this.episodeHasCompletedWithErrors(ClientState.ERROR_CANNOT_CREATE_WORLD, "Server world-creation handler failed to create a world: " + serverHandlers.worldGenerator.getErrorDetails());
                    }
                }
            }
            catch (Exception e) {
                this.episodeHasCompletedWithErrors(ClientState.ERROR_CANNOT_CREATE_WORLD, "Server world-creation handler failed to create a world: " + e.getMessage());
            }
        }

        @Override
        protected void onServerTick(TickEvent.ServerTickEvent ev) {
            if (this.worldCreated && !this.serverStarted) {
                this.serverStarted = true;
                MalmoMod.instance.initIntegratedServer(ClientStateMachine.this.currentMissionInit());
                this.episodeHasCompleted(ClientState.WAITING_FOR_SERVER_READY);
            }
        }

        @Override
        public void onClientTick(TickEvent.ClientTickEvent ev) {
            if (this.inAbortState()) {
                this.episodeHasCompleted(ClientState.MISSION_ABORTED);
            }
            if (++this.totalTicks > 2000) {
                String msg = "Too long waiting for world to be created.";
                TCPUtils.Log(Level.SEVERE, msg);
                this.episodeHasCompletedWithErrors(ClientState.ERROR_TIMED_OUT_WAITING_FOR_WORLD_CREATE, msg);
            }
        }
    }

    public class CloseOldServerEpisode
    extends ConfigAwareStateEpisode {
        int totalTicks;

        CloseOldServerEpisode(ClientStateMachine machine) {
            super(machine);
        }

        @Override
        protected void execute() {
            this.totalTicks = 0;
            if (Minecraft.getMinecraft().world != null) {
                Minecraft.getMinecraft().world.sendQuittingDisconnectingPacket();
                Minecraft.getMinecraft().loadWorld((WorldClient)null);
                Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new GuiMainMenu());
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void onClientTick(TickEvent.ClientTickEvent ev) {
            if (this.inAbortState()) {
                this.episodeHasCompleted(ClientState.MISSION_ABORTED);
            }
            if (ev.phase == TickEvent.Phase.END) {
                this.episodeHasCompleted(ClientState.CREATING_NEW_WORLD);
            }
            if (++this.totalTicks > 2000) {
                String msg = "Too long waiting for server episode to close.";
                TCPUtils.Log(Level.SEVERE, msg);
                this.episodeHasCompletedWithErrors(ClientState.ERROR_TIMED_OUT_WAITING_FOR_EPISODE_CLOSE, msg);
            }
        }
    }

    public class PauseOldServerEpisode
    extends ConfigAwareStateEpisode {
        int serverTickCount;
        int clientTickCount;
        int totalTicks;

        PauseOldServerEpisode(ClientStateMachine machine) {
            super(machine);
            this.serverTickCount = 0;
            this.clientTickCount = 0;
            this.totalTicks = 0;
        }

        @Override
        protected void execute() {
            this.serverTickCount = 0;
            this.clientTickCount = 0;
            this.totalTicks = 0;
            if (Minecraft.getMinecraft().getIntegratedServer() != null && Minecraft.getMinecraft().world != null) {
                if (Minecraft.getMinecraft().getIntegratedServer().getPublic() && !this.killPublicFlag(Minecraft.getMinecraft().getIntegratedServer())) {
                    this.episodeHasCompletedWithErrors(ClientState.ERROR_CANNOT_CREATE_WORLD, "Can not pause the old server since it's open to LAN; no way to safely create new world.");
                }
                Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new GuiIngameMenu());
            }
        }

        private boolean killPublicFlag(IntegratedServer server) {
            boolean devEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
            String isPublicMemberName = devEnv ? "isPublic" : "field_71346_p";
            try {
                Field isPublic = IntegratedServer.class.getDeclaredField(isPublicMemberName);
                isPublic.setAccessible(true);
                isPublic.set(server, false);
                return true;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public void onClientTick(TickEvent.ClientTickEvent ev) {
            if (this.inAbortState()) {
                this.episodeHasCompleted(ClientState.MISSION_ABORTED);
            }
            if ((Minecraft.getMinecraft().isGamePaused() || Minecraft.getMinecraft().player == null) && ev != null && ev.phase == TickEvent.Phase.END && this.clientTickCount == this.serverTickCount && this.clientTickCount <= 2) {
                ++this.clientTickCount;
                Minecraft.getMinecraft().getIntegratedServer().addScheduledTask(new Runnable(){

                    @Override
                    public void run() {
                        ++PauseOldServerEpisode.this.serverTickCount;
                    }
                });
            }
            if (this.serverTickCount > 2) {
                this.episodeHasCompleted(ClientState.CLOSING_OLD_SERVER);
            } else if (++this.totalTicks > 2000) {
                String msg = "Too long waiting for server episode to pause.";
                TCPUtils.Log(Level.SEVERE, msg);
                this.episodeHasCompletedWithErrors(ClientState.ERROR_TIMED_OUT_WAITING_FOR_EPISODE_PAUSE, msg);
            }
        }
    }

    public class EvaluateWorldRequirementsEpisode
    extends ConfigAwareStateEpisode {
        EvaluateWorldRequirementsEpisode(ClientStateMachine machine) {
            super(machine);
        }

        @Override
        protected void execute() {
            boolean worldCurrentlyExists;
            MissionBehaviour serverHandlers = null;
            try {
                serverHandlers = MissionBehaviour.createServerHandlersFromMissionInit(ClientStateMachine.this.currentMissionInit());
            }
            catch (Exception e) {
                this.episodeHasCompletedWithErrors(ClientState.ERROR_DUFF_HANDLERS, "Could not create server mission handlers: " + e.getMessage());
            }
            World world = null;
            if (Minecraft.getMinecraft().getIntegratedServer() != null) {
                world = Minecraft.getMinecraft().getIntegratedServer().getEntityWorld();
            }
            boolean needsNewWorld = serverHandlers != null && serverHandlers.worldGenerator != null && serverHandlers.worldGenerator.shouldCreateWorld(ClientStateMachine.this.currentMissionInit(), world);
            boolean bl = worldCurrentlyExists = world != null;
            if (worldCurrentlyExists) {
                List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
                String agentName = agents.get(ClientStateMachine.this.currentMissionInit().getClientRole()).getName();
                if (Minecraft.getMinecraft().player != null && !Minecraft.getMinecraft().player.getName().equals(agentName)) {
                    needsNewWorld = true;
                }
            }
            if (needsNewWorld && worldCurrentlyExists) {
                this.episodeHasCompleted(ClientState.PAUSING_OLD_SERVER);
            } else if (needsNewWorld && !worldCurrentlyExists) {
                this.episodeHasCompleted(ClientState.CREATING_NEW_WORLD);
            } else if (!needsNewWorld && worldCurrentlyExists) {
                Minecraft.getMinecraft().getIntegratedServer().addScheduledTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MalmoMod.instance.sendMissionInitDirectToServer(ClientStateMachine.this.currentMissionInit);
                        }
                        catch (Exception e) {
                            EvaluateWorldRequirementsEpisode.this.episodeHasCompletedWithErrors(ClientState.ERROR_INTEGRATED_SERVER_UNREACHABLE, "Could not send MissionInit to our integrated server: " + e.getMessage());
                        }
                    }
                });
                this.episodeHasCompleted(ClientState.WAITING_FOR_SERVER_READY);
            } else if (!needsNewWorld && !worldCurrentlyExists) {
                this.episodeHasCompletedWithErrors(ClientState.ERROR_NO_WORLD, "We have no world to play in - check that your ServerHandlers section contains a world generator");
            }
        }
    }

    public class WaitingForServerMissionEndEpisode
    extends ConfigAwareStateEpisode {
        protected WaitingForServerMissionEndEpisode(ClientStateMachine machine) {
            super(machine);
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_MISSIONOVER);
        }

        @Override
        protected void execute() throws Exception {
            List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
            if (agents == null || agents.size() <= ClientStateMachine.this.currentMissionInit().getClientRole()) {
                throw new Exception("No agent section for us!");
            }
            String agentName = agents.get(ClientStateMachine.this.currentMissionInit().getClientRole()).getName();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("agentname", agentName);
            MalmoMod.network.sendToServer((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.CLIENT_AGENTSTOPPED, 0, map));
        }

        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            super.onMessage(messageType, data);
            if (messageType == MalmoMod.MalmoMessageType.SERVER_MISSIONOVER) {
                this.episodeHasCompleted(ClientState.DORMANT);
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_MISSIONOVER);
        }

        @Override
        protected void onAbort(Map<String, String> errorData) {
            this.episodeHasCompleted(ClientState.MISSION_ABORTED);
        }
    }

    public class WaitingForServerEpisode
    extends ConfigAwareStateEpisode {
        String agentName;
        int ticksUntilNextPing;
        int totalTicks;
        boolean waitingForChunk;
        boolean waitingForPlayer;

        protected WaitingForServerEpisode(ClientStateMachine machine) {
            super(machine);
            this.ticksUntilNextPing = 0;
            this.totalTicks = 0;
            this.waitingForChunk = false;
            this.waitingForPlayer = true;
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_ALLPLAYERSJOINED);
        }

        private boolean isChunkReady() {
            List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
            if (agents == null || agents.size() <= ClientStateMachine.this.currentMissionInit().getClientRole()) {
                return true;
            }
            AgentSection as = agents.get(ClientStateMachine.this.currentMissionInit().getClientRole());
            if (as.getAgentStart() != null && as.getAgentStart().getPlacement() != null) {
                Chunk requestedChunk;
                Chunk actualChunk;
                PosAndDirection pos = as.getAgentStart().getPlacement();
                int x = MathHelper.floor((double)pos.getX().doubleValue()) >> 4;
                int z = MathHelper.floor((double)pos.getZ().doubleValue()) >> 4;
                ChunkProviderClient chunkprov = Minecraft.getMinecraft().world.getChunkProvider();
                EntityPlayerSP player = Minecraft.getMinecraft().player;
                if (player.addedToChunk && (actualChunk = chunkprov.provideChunk(player.chunkCoordX, player.chunkCoordZ)) == (requestedChunk = chunkprov.provideChunk(x, z)) && actualChunk != null && !actualChunk.isEmpty()) {
                    player.posX = pos.getX().doubleValue();
                    player.posY = pos.getY().doubleValue();
                    player.posZ = pos.getZ().doubleValue();
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        protected void onClientTick(TickEvent.ClientTickEvent ev) {
            GuiScreen screen;
            if (this.inAbortState()) {
                this.episodeHasCompleted(ClientState.MISSION_ABORTED);
            }
            if (this.waitingForPlayer) {
                if (Minecraft.getMinecraft().player != null) {
                    this.waitingForPlayer = false;
                    this.handleLan();
                } else {
                    return;
                }
            }
            ++this.totalTicks;
            if (this.ticksUntilNextPing == 0) {
                if (Minecraft.getMinecraft().player != null && !this.waitingForChunk) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("agentname", this.agentName);
                    map.put("username", Minecraft.getMinecraft().player.getName());
                    ClientStateMachine.this.currentMissionBehaviour().appendExtraServerInformation(map);
                    System.out.println("***Telling server we are ready - " + this.agentName);
                    MalmoMod.network.sendToServer((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.CLIENT_AGENTREADY, 0, map));
                }
                this.pingAgent(true);
                this.ticksUntilNextPing = 10;
            } else {
                --this.ticksUntilNextPing;
            }
            if (this.waitingForChunk && this.isChunkReady()) {
                this.proceed();
            }
            List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
            boolean completedWithErrors = false;
            if (agents.size() > 1 && ClientStateMachine.this.currentMissionInit().getClientRole() != 0 && (screen = Minecraft.getMinecraft().currentScreen) != null && screen instanceof GuiDisconnected) {
                String msg = "Unable to connect to Minecraft server in multi-agent mission.";
                TCPUtils.Log(Level.SEVERE, msg);
                this.episodeHasCompletedWithErrors(ClientState.ERROR_CANNOT_CONNECT_TO_SERVER, msg);
                completedWithErrors = true;
            }
            if (!completedWithErrors && this.totalTicks > 2000) {
                String msg = "Too long waiting for server episode to start.";
                TCPUtils.Log(Level.SEVERE, msg);
                this.episodeHasCompletedWithErrors(ClientState.ERROR_TIMED_OUT_WAITING_FOR_EPISODE_START, msg);
            }
        }

        @Override
        protected void execute() throws Exception {
            this.totalTicks = 0;
            Minecraft.getMinecraft().displayGuiScreen(null);
            List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
            this.agentName = agents.get(ClientStateMachine.this.currentMissionInit().getClientRole()).getName();
            if (agents.size() > 1 && ClientStateMachine.this.currentMissionInit().getClientRole() != 0) {
                boolean namesMatch;
                String address = ClientStateMachine.this.currentMissionInit().getMinecraftServerConnection().getAddress().trim();
                int port = ClientStateMachine.this.currentMissionInit().getMinecraftServerConnection().getPort();
                String targetIP = address + ":" + port;
                System.out.println("We should be joining " + targetIP);
                EntityPlayerSP player = Minecraft.getMinecraft().player;
                boolean bl = namesMatch = player == null || Minecraft.getMinecraft().player.getName().equals(this.agentName);
                if (!namesMatch) {
                    TCPUtils.Log(Level.WARNING, "Agent name does not match agent in game.");
                }
                if (Minecraft.getMinecraft().getCurrentServerData() == null || !Minecraft.getMinecraft().getCurrentServerData().serverIP.equals(targetIP)) {
                    FMLClientHandler.instance().connectToServerAtStartup(address, port);
                }
                this.waitingForPlayer = false;
            }
        }

        protected void handleLan() {
            List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
            this.agentName = agents.get(ClientStateMachine.this.currentMissionInit().getClientRole()).getName();
            if (agents.size() > 1 && ClientStateMachine.this.currentMissionInit().getClientRole() == 0) {
                MinecraftServerConnection msc = new MinecraftServerConnection();
                String address = ClientStateMachine.this.currentMissionInit().getClientAgentConnection().getClientIPAddress();
                if (Minecraft.getMinecraft().isSingleplayer() && !Minecraft.getMinecraft().getIntegratedServer().getPublic()) {
                    String portstr = Minecraft.getMinecraft().getIntegratedServer().shareToLAN(GameType.SURVIVAL, true);
                    ClientStateMachine.this.integratedServerPort = Integer.valueOf(portstr);
                }
                TCPUtils.Log(Level.INFO, "Integrated server port: " + ClientStateMachine.this.integratedServerPort);
                msc.setPort(ClientStateMachine.this.integratedServerPort);
                msc.setAddress(address);
                if (ClientStateMachine.this.envServer != null) {
                    ClientStateMachine.this.envServer.notifyIntegrationServerStarted(ClientStateMachine.this.integratedServerPort);
                }
                ClientStateMachine.this.currentMissionInit().setMinecraftServerConnection(msc);
            }
        }

        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            super.onMessage(messageType, data);
            if (messageType != MalmoMod.MalmoMessageType.SERVER_ALLPLAYERSJOINED) {
                return;
            }
            ArrayList<Object> handlers = new ArrayList<Object>();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                if (entry.getKey().equals("startPosition")) {
                    try {
                        AgentSection as;
                        AgentStart startSection;
                        String[] parts = entry.getValue().split(":");
                        Float x = Float.valueOf(parts[0]);
                        Float y = Float.valueOf(parts[1]);
                        Float z = Float.valueOf(parts[2]);
                        List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
                        if (agents == null || agents.size() <= ClientStateMachine.this.currentMissionInit().getClientRole() || (startSection = (as = agents.get(ClientStateMachine.this.currentMissionInit().getClientRole())).getAgentStart()) == null) continue;
                        PosAndDirection pos = startSection.getPlacement();
                        if (pos == null) {
                            pos = new PosAndDirection();
                        }
                        pos.setX(new BigDecimal(x.floatValue()));
                        pos.setY(new BigDecimal(y.floatValue()));
                        pos.setZ(new BigDecimal(z.floatValue()));
                        startSection.setPlacement(pos);
                        as.setAgentStart(startSection);
                    }
                    catch (Exception e) {
                        System.out.println("Couldn't interpret position data");
                    }
                    continue;
                }
                String extraHandler = entry.getValue();
                if (extraHandler == null || extraHandler.length() <= 0) continue;
                try {
                    Class<?> handlerClass = Class.forName(entry.getKey());
                    Object handler = SchemaHelper.deserialiseObject(extraHandler, "MissionInit.xsd", handlerClass);
                    handlers.add(handler);
                }
                catch (Exception e) {
                    System.out.println("Error trying to create extra handlers: " + e);
                }
            }
            if (!handlers.isEmpty()) {
                ClientStateMachine.this.currentMissionBehaviour().addExtraHandlers(handlers);
            }
            this.waitingForChunk = true;
        }

        private void proceed() {
            String xml = null;
            boolean sentOkay = false;
            String errorReport = "";
            try {
                xml = SchemaHelper.serialiseObject(ClientStateMachine.this.currentMissionInit(), MissionInit.class);
                if (AddressHelper.getMissionControlPort() == 0) {
                    if (ClientStateMachine.this.envServer != null) {
                        // empty if block
                    }
                    sentOkay = true;
                } else {
                    sentOkay = ClientStateMachine.this.getMissionControlSocket().sendTCPString(xml, 1);
                }
            }
            catch (JAXBException e) {
                errorReport = e.getMessage();
            }
            if (sentOkay) {
                this.episodeHasCompleted(ClientState.RUNNING);
            } else {
                ClientStateMachine.this.getScreenHelper().addFragment("ERROR: Could not contact agent to start mission - mission will abort.", ScreenHelper.TextCategory.TXT_CLIENT_WARNING, 10000);
                if (!errorReport.isEmpty()) {
                    ClientStateMachine.this.getScreenHelper().addFragment("ERROR DETAILS: " + errorReport, ScreenHelper.TextCategory.TXT_CLIENT_WARNING, 10000);
                    errorReport = ": " + errorReport;
                }
                this.episodeHasCompletedWithErrors(ClientState.ERROR_CANNOT_START_AGENT, "Failed to send MissionInit back to agent" + errorReport);
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_ALLPLAYERSJOINED);
        }
    }

    public class CreateHandlersEpisode
    extends ConfigAwareStateEpisode {
        protected CreateHandlersEpisode(ClientStateMachine machine) {
            super(machine);
        }

        @Override
        protected void execute() throws Exception {
            ClientStateMachine.this.cancelReservation();
            try {
                ClientStateMachine.this.missionBehaviour = MissionBehaviour.createAgentHandlersFromMissionInit(ClientStateMachine.this.currentMissionInit());
                if (ClientStateMachine.this.envServer != null) {
                    ClientStateMachine.this.missionBehaviour.addQuitProducer(ClientStateMachine.this.envServer);
                }
            }
            catch (Exception e) {
                System.err.println("ERROR: Exception caught making agent handlers" + e.toString());
                e.printStackTrace();
            }
            TCPUtils.LogSection ls = new TCPUtils.LogSection("Initialise Command Input Poller");
            ClientAgentConnection cac = ClientStateMachine.this.currentMissionInit().getClientAgentConnection();
            int requestedPort = cac.getClientCommandsPort();
            if (requestedPort != 0 && ClientStateMachine.this.controlInputPoller != null && ClientStateMachine.this.controlInputPoller.getPort() != requestedPort) {
                System.out.println("Requested command port is not the same as the input poller port; the port was not free. Stopping server.");
                ClientStateMachine.this.controlInputPoller.stopServer();
                ClientStateMachine.this.controlInputPoller = null;
            }
            if (ClientStateMachine.this.controlInputPoller == null) {
                ClientStateMachine.this.controlInputPoller = requestedPort == 0 ? new TCPInputPoller(10100, 11000, true, "com") : new TCPInputPoller(requestedPort, "com");
                System.out.println("Starting command server.");
                ClientStateMachine.this.controlInputPoller.start();
            }
            cac.setClientCommandsPort(ClientStateMachine.this.controlInputPoller.getPortBlocking());
            ls.close();
            if (this.inAbortState()) {
                this.episodeHasCompleted(ClientState.MISSION_ABORTED);
            }
            List<AgentSection> agents = ClientStateMachine.this.currentMissionInit().getMission().getAgentSection();
            String agentName = agents.get(ClientStateMachine.this.currentMissionInit().getClientRole()).getName();
            AuthenticationHelper.setPlayerName(Minecraft.getMinecraft().getSession(), agentName);
            Minecraft.getMinecraft().getProfileProperties().put((Object)"dummy", (Object)new Property("dummy", "property"));
            if (ClientStateMachine.this.currentMissionInit().getClientRole() == 0) {
                this.episodeHasCompleted(ClientState.EVALUATING_WORLD_REQUIREMENTS);
            } else {
                this.episodeHasCompleted(ClientState.WAITING_FOR_SERVER_READY);
            }
        }
    }

    public class DormantEpisode
    extends ConfigAwareStateEpisode {
        private ClientStateMachine csMachine;

        protected DormantEpisode(ClientStateMachine machine) {
            super(machine);
            this.csMachine = machine;
        }

        @Override
        protected void execute() {
            TextureHelper.init();
            this.csMachine.currentMissionInit = null;
            ClientStateMachine.this.clearErrorDetails();
            if (ClientStateMachine.this.controlInputPoller != null) {
                ClientStateMachine.this.controlInputPoller.clearCommands();
            }
            System.gc();
        }

        @Override
        public void onClientTick(TickEvent.ClientTickEvent ev) throws Exception {
            Minecraft.getMinecraft().mcProfiler.startSection("malmoHandleMissionCommands");
            this.checkForMissionCommand();
            Minecraft.getMinecraft().mcProfiler.endSection();
        }

        private void checkForMissionCommand() throws Exception {
            if (ClientStateMachine.this.missionPoller == null) {
                return;
            }
            TCPInputPoller.CommandAndIPAddress comip = ClientStateMachine.this.missionPoller.getCommandAndIPAddress();
            if (comip == null) {
                return;
            }
            String missionMessage = comip.command;
            if (missionMessage == null || missionMessage.length() == 0) {
                return;
            }
            Minecraft.getMinecraft().mcProfiler.endSection();
            Minecraft.getMinecraft().mcProfiler.startSection("malmoDecodeMissionInit");
            MissionInitResult missionInitResult = ClientStateMachine.this.decodeMissionInit(missionMessage);
            Minecraft.getMinecraft().mcProfiler.endSection();
            MissionInit missionInit = missionInitResult.missionInit;
            if (missionInit == null) {
                throw new Exception("Failed to get valid MissionInit object from SchemaHelper.");
            }
            missionInit.getClientAgentConnection().setAgentIPAddress(comip.ipAddress);
            System.out.println("Mission received: " + missionInit.getMission().getAbout().getSummary());
            this.csMachine.currentMissionInit = missionInit;
            TimeHelper.SyncManager.numTicks = 0L;
            ScoreHelper.logMissionInit(missionInit);
            ClientStateMachine.this.createMissionControlSocket();
            this.episodeHasCompleted(ClientState.CREATING_HANDLERS);
        }
    }

    public class InitialiseClientModEpisode
    extends ConfigAwareStateEpisode {
        InitialiseClientModEpisode(ClientStateMachine machine) {
            super(machine);
        }

        @Override
        protected void execute() throws Exception {
            ClientStateMachine.this.initialiseComms();
            GameSettings settings = Minecraft.getMinecraft().gameSettings;
            settings.pauseOnLostFocus = false;
            ScreenHelper.hookIntoInGameGui();
        }

        @Override
        public void onRenderTick(TickEvent.RenderTickEvent ev) {
            this.episodeHasCompleted(ClientState.DORMANT);
        }
    }

    public abstract class ConfigAwareStateEpisode
    extends ErrorAwareEpisode {
        ConfigAwareStateEpisode(ClientStateMachine machine) {
            super(machine);
        }

        @Override
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent ev) {
            if (ev.getConfigID().equals("malmoports")) {
                AddressHelper.update(MalmoMod.instance.getModSessionConfigFile());
                try {
                    ClientStateMachine.this.initialiseComms();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                ScreenHelper.update(MalmoMod.instance.getModPermanentConfigFile());
                TCPUtils.update(MalmoMod.instance.getModPermanentConfigFile());
            }
        }
    }

    public abstract class ErrorAwareEpisode
    extends StateEpisode
    implements MalmoMod.IMalmoMessageListener {
        protected Boolean errorFlag;
        protected Map<String, String> errorData;

        public ErrorAwareEpisode(ClientStateMachine machine) {
            super(machine);
            this.errorFlag = false;
            this.errorData = null;
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_ABORT);
        }

        protected boolean pingAgent(boolean abortIfFailed) {
            if (AddressHelper.getMissionControlPort() == 0) {
                return true;
            }
            boolean sentOkay = ClientStateMachine.this.getMissionControlSocket().sendTCPString("<?xml version=\"1.0\" encoding=\"UTF-8\"?><ping/>", 1);
            if (!sentOkay) {
                ClientStateMachine.this.getScreenHelper().addFragment("ERROR: Lost contact with agent - aborting mission", ScreenHelper.TextCategory.TXT_CLIENT_WARNING, 10000);
                if (abortIfFailed) {
                    this.episodeHasCompletedWithErrors(ClientState.ERROR_LOST_AGENT, "Lost contact with the agent");
                }
            }
            return sentOkay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            if (messageType == MalmoMod.MalmoMessageType.SERVER_ABORT) {
                Boolean bl = this.errorFlag;
                synchronized (bl) {
                    this.errorFlag = true;
                    this.errorData = data;
                    if (data != null) {
                        String message = data.get("message");
                        String user = data.get("username");
                        String error = data.get("error");
                        String report = "";
                        if (user != null) {
                            report = report + "From " + user + ": ";
                        }
                        if (error != null) {
                            report = report + error;
                        }
                        if (message != null) {
                            report = report + " (" + message + ")";
                        }
                        ClientStateMachine.this.saveErrorDetails(report);
                    }
                    this.onAbort(data);
                }
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_ABORT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean inAbortState() {
            Boolean bl = this.errorFlag;
            synchronized (bl) {
                return this.errorFlag;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> getErrorData() {
            Boolean bl = this.errorFlag;
            synchronized (bl) {
                return this.errorData;
            }
        }

        protected void onAbort(Map<String, String> errorData) {
        }
    }

    protected class MissionInitResult {
        public MissionInit missionInit = null;
        public boolean wasMissionInit = false;
        public String error = null;

        protected MissionInitResult() {
        }
    }
}

