/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Client;

import com.microsoft.Malmo.Client.InternalKey;
import java.util.ArrayList;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

public class KeyManager {
    private ArrayList<InternalKey> additionalKeys;

    public KeyManager(GameSettings settings, ArrayList<InternalKey> additionalKeys) {
        this.additionalKeys = additionalKeys;
        if (additionalKeys != null) {
            this.fixAdditionalKeyBindings(settings);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    private void fixAdditionalKeyBindings(GameSettings settings) {
        if (this.additionalKeys == null) {
            return;
        }
        KeyBinding[] bindings = (KeyBinding[])ArrayUtils.addAll((Object[])settings.keyBindings, (Object[])this.additionalKeys.toArray());
        settings.keyBindings = bindings;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        if (ev != null && ev.phase == TickEvent.Phase.START) {
            for (InternalKey binding : this.additionalKeys) {
                if (binding.isKeyDown()) {
                    binding.onKeyDown();
                }
                if (!binding.isPressed()) continue;
                binding.onPressed();
            }
        }
    }
}

