/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo;

import com.microsoft.Malmo.Client.MalmoEnvServer;
import com.microsoft.Malmo.Client.MalmoModClient;
import com.microsoft.Malmo.MissionHandlers.AbsoluteMovementCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.DiscreteMovementCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.EquipCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.InventoryCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.NearbyCraftCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.NearbySmeltCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.ObservationFromFullInventoryImplementation;
import com.microsoft.Malmo.MissionHandlers.ObservationFromGridImplementation;
import com.microsoft.Malmo.MissionHandlers.ObservationFromSystemImplementation;
import com.microsoft.Malmo.MissionHandlers.PlaceCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.SimpleCraftCommandsImplementation;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Server.MalmoModServer;
import com.microsoft.Malmo.Utils.AddressHelper;
import com.microsoft.Malmo.Utils.SchemaHelper;
import com.microsoft.Malmo.Utils.ScoreHelper;
import com.microsoft.Malmo.Utils.ScreenHelper;
import com.microsoft.Malmo.Utils.TCPUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="malmomod", guiFactory="com.microsoft.Malmo.MalmoModGuiOptions")
public class MalmoMod {
    public static final String MODID = "malmomod";
    public static final String SOCKET_CONFIGS = "malmoports";
    public static final String ENV_CONFIGS = "envtype";
    public static final String DIAGNOSTIC_CONFIGS = "malmodiags";
    public static final String AUTHENTICATION_CONFIGS = "malmologins";
    public static final String SCORING_CONFIGS = "malmoscore";
    public static final String AGENT_DEAD_QUIT_CODE = "MALMO_AGENT_DIED";
    public static final String AGENT_UNRESPONSIVE_CODE = "MALMO_AGENT_NOT_RESPONDING";
    public static final String VIDEO_UNRESPONSIVE_CODE = "MALMO_VIDEO_NOT_RESPONDING";
    protected static Hashtable<String, Object> clientProperties = new Hashtable();
    protected static Hashtable<String, Object> serverProperties = new Hashtable();
    MalmoModClient client = null;
    MalmoModServer server = null;
    Configuration sessionConfig = null;
    Configuration permanentConfig = null;
    @Mod.Instance(value="malmomod")
    public static MalmoMod instance;
    public static SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (!SchemaHelper.testSchemaVersionNumbers(Loader.instance().activeModContainer().getVersion())) {
            throw new RuntimeException("This mod has been incorrectly built; check schema version numbers.");
        }
        if (event.getModMetadata().version.equals("${version}")) {
            event.getModMetadata().version = Loader.instance().activeModContainer().getVersion();
        }
        File configDir = event.getModConfigurationDirectory();
        File sessionConfigFile = new File(configDir, MODID + event.getSide().toString() + ".cfg");
        File permanentConfigFile = new File(configDir, MODID + event.getSide().toString() + "Permanent.cfg");
        this.sessionConfig = new Configuration(sessionConfigFile);
        this.sessionConfig.load();
        this.permanentConfig = new Configuration(permanentConfigFile);
        this.permanentConfig.load();
        AddressHelper.update(this.sessionConfig);
        ScoreHelper.update(this.sessionConfig);
        ScreenHelper.update(this.permanentConfig);
        TCPUtils.update(this.permanentConfig);
        MalmoEnvServer.update(this.sessionConfig);
        network = NetworkRegistry.INSTANCE.newSimpleChannel("Malmo");
        network.registerMessage(ObservationFromGridImplementation.GridRequestMessageHandler.class, ObservationFromGridImplementation.GridRequestMessage.class, 2, Side.SERVER);
        network.registerMessage(MalmoMessageHandler.class, MalmoMessage.class, 3, Side.CLIENT);
        network.registerMessage(SimpleCraftCommandsImplementation.CraftMessageHandler.class, SimpleCraftCommandsImplementation.CraftMessage.class, 4, Side.SERVER);
        network.registerMessage(NearbyCraftCommandsImplementation.CraftNearbyMessageHandler.class, NearbyCraftCommandsImplementation.CraftNearbyMessage.class, 13, Side.SERVER);
        network.registerMessage(NearbySmeltCommandsImplementation.SmeltNearbyMessageHandler.class, NearbySmeltCommandsImplementation.SmeltNearbyMessage.class, 14, Side.SERVER);
        network.registerMessage(EquipCommandsImplementation.EquipMessageHandler.class, EquipCommandsImplementation.EquipMessage.class, 15, Side.SERVER);
        network.registerMessage(PlaceCommandsImplementation.PlaceMessageHandler.class, PlaceCommandsImplementation.PlaceMessage.class, 16, Side.SERVER);
        network.registerMessage(AbsoluteMovementCommandsImplementation.TeleportMessageHandler.class, AbsoluteMovementCommandsImplementation.TeleportMessage.class, 5, Side.SERVER);
        network.registerMessage(MalmoMessageHandler.class, MalmoMessage.class, 6, Side.SERVER);
        network.registerMessage(InventoryCommandsImplementation.InventoryMessageHandler.class, InventoryCommandsImplementation.InventoryMessage.class, 7, Side.SERVER);
        network.registerMessage(DiscreteMovementCommandsImplementation.UseActionMessageHandler.class, DiscreteMovementCommandsImplementation.UseActionMessage.class, 8, Side.SERVER);
        network.registerMessage(DiscreteMovementCommandsImplementation.AttackActionMessageHandler.class, DiscreteMovementCommandsImplementation.AttackActionMessage.class, 9, Side.SERVER);
        network.registerMessage(ObservationFromFullInventoryImplementation.InventoryRequestMessageHandler.class, ObservationFromFullInventoryImplementation.InventoryRequestMessage.class, 10, Side.SERVER);
        network.registerMessage(InventoryCommandsImplementation.InventoryChangeMessageHandler.class, InventoryCommandsImplementation.InventoryChangeMessage.class, 11, Side.CLIENT);
        network.registerMessage(ObservationFromSystemImplementation.SystemRequestMessageHandler.class, ObservationFromSystemImplementation.SystemRequestMessage.class, 12, Side.SERVER);
    }

    @Mod.EventHandler
    public void onMissingMappingsEvent(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            if (mapping.type != GameRegistry.Type.ITEM || !mapping.name.equals("minecraft:lit_furnace")) continue;
            mapping.ignore();
        }
    }

    public Configuration getModSessionConfigFile() {
        return this.sessionConfig;
    }

    public Configuration getModPermanentConfigFile() {
        return this.permanentConfig;
    }

    public static Hashtable<String, Object> getPropertiesForCurrentThread() throws Exception {
        if (Minecraft.getMinecraft().isCallingFromMinecraftThread()) {
            return clientProperties;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && server.isCallingFromMinecraftThread()) {
            return serverProperties;
        }
        throw new Exception("Request for properties made from unrecognised thread.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide().isClient()) {
            this.client = new MalmoModClient();
            this.client.init(event);
        }
        if (event.getSide().isServer()) {
            this.server = new MalmoModServer();
            this.server.init(event);
        }
    }

    public void initIntegratedServer(MissionInit minit) {
        this.server = new MalmoModServer();
        this.server.init(minit);
    }

    public void sendMissionInitDirectToServer(MissionInit minit) throws Exception {
        if (this.server == null) {
            throw new Exception("Trying to send a mission request directly when no server has been created!");
        }
        this.server.sendMissionInitDirectToServer(minit);
    }

    public float getServerTickRate() throws Exception {
        if (this.server == null) {
            throw new Exception("Trying to get the server tick rate when no server has been created!");
        }
        return this.server.getServerTickRate();
    }

    public static void safeSendToAll(MalmoMessageType malmoMessage) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (Object player : server.getPlayerList().getPlayers()) {
            if (player == null || !(player instanceof EntityPlayerMP)) continue;
            network.sendTo((IMessage)new MalmoMessage(malmoMessage, ""), (EntityPlayerMP)player);
        }
    }

    public static void safeSendToAll(MalmoMessageType malmoMessage, Map<String, String> data) {
        if (data == null) {
            MalmoMod.safeSendToAll(malmoMessage);
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (Object player : server.getPlayerList().getPlayers()) {
            if (player == null || !(player instanceof EntityPlayerMP)) continue;
            HashMap<String, String> dataCopy = new HashMap<String, String>();
            dataCopy.putAll(data);
            network.sendTo((IMessage)new MalmoMessage(malmoMessage, 0, dataCopy), (EntityPlayerMP)player);
        }
    }

    public static class MalmoMessageHandler
    implements IMessageHandler<MalmoMessage, IMessage> {
        private static Map<MalmoMessageType, List<IMalmoMessageListener>> listeners = new HashMap<MalmoMessageType, List<IMalmoMessageListener>>();

        public static boolean registerForMessage(IMalmoMessageListener listener, MalmoMessageType messageType) {
            if (!listeners.containsKey((Object)messageType)) {
                listeners.put(messageType, new ArrayList());
            }
            if (listeners.get((Object)messageType).contains(listener)) {
                return false;
            }
            listeners.get((Object)messageType).add(listener);
            return true;
        }

        public static boolean deregisterForMessage(IMalmoMessageListener listener, MalmoMessageType messageType) {
            if (!listeners.containsKey((Object)messageType)) {
                return false;
            }
            return listeners.get((Object)messageType).remove(listener);
        }

        public IMessage onMessage(final MalmoMessage message, MessageContext ctx) {
            final List<IMalmoMessageListener> interestedParties = listeners.get((Object)message.messageType);
            if (interestedParties != null && interestedParties.size() > 0) {
                Object mainThread = null;
                mainThread = ctx.side == Side.CLIENT ? Minecraft.getMinecraft() : (WorldServer)ctx.getServerHandler().playerEntity.world;
                mainThread.addScheduledTask(new Runnable(){

                    @Override
                    public void run() {
                        for (IMalmoMessageListener l : interestedParties) {
                            if (message.uid != 0 && System.identityHashCode(l) != message.uid) continue;
                            l.onMessage(message.messageType, message.data);
                        }
                    }
                });
            }
            return null;
        }
    }

    public static interface IMalmoMessageListener {
        public void onMessage(MalmoMessageType var1, Map<String, String> var2);
    }

    public static class MalmoMessage
    implements IMessage {
        private MalmoMessageType messageType = MalmoMessageType.SERVER_NULLMESSASGE;
        private int uid = 0;
        private Map<String, String> data = new HashMap<String, String>();

        public MalmoMessage() {
        }

        public MalmoMessage(MalmoMessageType messageType, String message) {
            this.messageType = messageType;
            this.uid = 0;
            this.data.put("message", message);
        }

        public MalmoMessage(MalmoMessageType messageType, int uid, Map<String, String> data) {
            this.messageType = messageType;
            this.uid = uid;
            this.data = data;
        }

        private String readLargeUTF(ByteBufInputStream bbis) throws IOException {
            int length = bbis.readInt();
            if (length == 0) {
                return "";
            }
            byte[] data = new byte[length];
            int length_read = bbis.read(data, 0, length);
            if (length_read != length) {
                throw new IOException("Failed to read whole message");
            }
            return new String(data, "utf-8");
        }

        private void writeLargeUTF(String s, ByteBufOutputStream bbos) throws IOException {
            byte[] data = s.getBytes("utf-8");
            bbos.writeInt(data.length);
            bbos.write(data);
        }

        public void fromBytes(ByteBuf buf) {
            int i = ByteBufUtils.readVarInt((ByteBuf)buf, (int)1);
            this.messageType = i >= 0 && i <= MalmoMessageType.values().length ? MalmoMessageType.values()[i] : MalmoMessageType.SERVER_NULLMESSASGE;
            this.uid = buf.readInt();
            int length = buf.readInt();
            this.data = new HashMap<String, String>();
            ByteBufInputStream bbis = new ByteBufInputStream(buf);
            for (i = 0; i < length; ++i) {
                try {
                    String key = bbis.readUTF();
                    String value = this.readLargeUTF(bbis);
                    this.data.put(key, value);
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Warning - failed to read message data");
                }
            }
            try {
                bbis.close();
            }
            catch (IOException e) {
                System.out.println("Warning - failed to read message data");
            }
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.messageType.ordinal(), (int)1);
            buf.writeInt(this.uid);
            ByteBufOutputStream bbos = new ByteBufOutputStream(buf);
            buf.writeInt(this.data.size());
            for (Map.Entry<String, String> e : this.data.entrySet()) {
                try {
                    bbos.writeUTF(e.getKey());
                    this.writeLargeUTF(e.getValue(), bbos);
                }
                catch (IOException e1) {
                    System.out.println("Warning - failed to write message data");
                }
            }
            try {
                bbos.close();
            }
            catch (IOException e1) {
                System.out.println("Warning - failed to write message data");
            }
        }
    }

    public static enum MalmoMessageType {
        SERVER_NULLMESSASGE,
        SERVER_ALLPLAYERSJOINED,
        SERVER_GO,
        SERVER_STOPAGENTS,
        SERVER_MISSIONOVER,
        SERVER_OBSERVATIONSREADY,
        SERVER_TEXT,
        SERVER_ABORT,
        SERVER_COLLECTITEM,
        SERVER_DISCARDITEM,
        SERVER_BUILDBATTLEREWARD,
        SERVER_SHARE_REWARD,
        SERVER_YOUR_TURN,
        SERVER_SOMEOTHERMESSAGE,
        CLIENT_AGENTREADY,
        CLIENT_AGENTRUNNING,
        CLIENT_AGENTSTOPPED,
        CLIENT_AGENTFINISHEDMISSION,
        CLIENT_BAILED,
        CLIENT_SHARE_REWARD,
        CLIENT_TURN_TAKEN,
        CLIENT_SOMEOTHERMESSAGE;

    }
}

