/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.CommandGroup;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.Schemas.AgentQuitFromReachingCommandQuota;
import com.microsoft.Malmo.Schemas.CommandQuota;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.List;

public class AgentQuitFromReachingCommandQuotaImplementation
extends HandlerBase
implements IWantToQuit {
    AgentQuitFromReachingCommandQuota quotaparams;
    String quitCode = "";
    int[] quotas;
    Integer totalQuota = 0;
    boolean quotaExceeded = false;

    @Override
    public boolean doIWantToQuit(MissionInit missionInit) {
        return this.quotaExceeded;
    }

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof AgentQuitFromReachingCommandQuota)) {
            return false;
        }
        this.quotaparams = (AgentQuitFromReachingCommandQuota)params;
        this.initialiseQuotas();
        return true;
    }

    private void initialiseQuotas() {
        this.totalQuota = this.quotaparams.getTotal();
        this.quotas = new int[this.quotaparams.getQuota().size()];
        int i = 0;
        for (CommandQuota cq : this.quotaparams.getQuota()) {
            this.quotas[i] = cq.getQuota();
            ++i;
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        MissionBehaviour mb = this.parentBehaviour();
        ICommandHandler oldch = mb.commandHandler;
        CommandGroup newch = new CommandGroup(){

            @Override
            protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
                boolean handled = super.onExecute(verb, parameter, missionInit);
                if (handled) {
                    AgentQuitFromReachingCommandQuotaImplementation.this.checkQuotas(verb, parameter);
                }
                return handled;
            }
        };
        newch.setOverriding(oldch != null ? oldch.isOverriding() : true);
        if (oldch != null) {
            newch.addCommandHandler(oldch);
        }
        mb.commandHandler = newch;
    }

    private void checkQuotas(String verb, String parameter) {
        if (this.totalQuota != null) {
            AgentQuitFromReachingCommandQuotaImplementation agentQuitFromReachingCommandQuotaImplementation = this;
            Integer n = agentQuitFromReachingCommandQuotaImplementation.totalQuota;
            Integer n2 = agentQuitFromReachingCommandQuotaImplementation.totalQuota = Integer.valueOf(agentQuitFromReachingCommandQuotaImplementation.totalQuota - 1);
            if (this.totalQuota == 0) {
                this.quotaExceeded = true;
                this.quitCode = this.quotaparams.getDescription();
                return;
            }
        }
        int i = 0;
        for (CommandQuota cq : this.quotaparams.getQuota()) {
            List<String> comms = cq.getCommands();
            if (comms != null && comms.contains(verb)) {
                int n = i;
                this.quotas[n] = this.quotas[n] - 1;
                if (this.quotas[i] == 0) {
                    this.quitCode = cq.getDescription();
                    this.quotaExceeded = true;
                    return;
                }
            }
            ++i;
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getOutcome() {
        return this.quitCode;
    }
}

