/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.AgentQuitFromReachingPosition;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.PointWithToleranceAndDescription;
import com.microsoft.Malmo.Utils.PositionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;

public class AgentQuitFromReachingPositionImplementation
extends HandlerBase
implements IWantToQuit {
    AgentQuitFromReachingPosition qrpparams;
    String quitCode = "";

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof AgentQuitFromReachingPosition)) {
            return false;
        }
        this.qrpparams = (AgentQuitFromReachingPosition)params;
        return true;
    }

    @Override
    public boolean doIWantToQuit(MissionInit missionInit) {
        if (missionInit == null || this.qrpparams == null) {
            return false;
        }
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        for (PointWithToleranceAndDescription goal : this.qrpparams.getMarker()) {
            float distance = PositionHelper.calcDistanceFromPlayerToPosition(player, goal);
            if (!(distance <= goal.getTolerance().floatValue())) continue;
            this.quitCode = goal.getDescription();
            return true;
        }
        return false;
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getOutcome() {
        return this.quitCode;
    }
}

