/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.RewardForItemBase;
import com.microsoft.Malmo.Schemas.AgentQuitFromSmeltingItem;
import com.microsoft.Malmo.Schemas.BlockOrItemSpecWithDescription;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AgentQuitFromSmeltingItemImplementation
extends HandlerBase
implements IWantToQuit {
    private AgentQuitFromSmeltingItem params;
    private HashMap<String, Integer> smeltedItems;
    private List<ItemQuitMatcher> matchers;
    private String quitCode = "";
    private boolean wantToQuit = false;

    @Override
    public boolean parseParameters(Object params) {
        if (!(params instanceof AgentQuitFromSmeltingItem)) {
            return false;
        }
        this.params = (AgentQuitFromSmeltingItem)params;
        this.matchers = new ArrayList<ItemQuitMatcher>();
        for (BlockOrItemSpecWithDescription bs : this.params.getItem()) {
            this.matchers.add(new ItemQuitMatcher(bs));
        }
        return true;
    }

    @Override
    public boolean doIWantToQuit(MissionInit missionInit) {
        return this.wantToQuit;
    }

    @Override
    public String getOutcome() {
        return this.quitCode;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.smeltedItems = new HashMap();
    }

    @Override
    public void cleanup() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemSmelt(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.smelting.isEmpty()) {
            this.checkForMatch(event.smelting);
        }
    }

    private boolean getVariant(ItemStack is) {
        for (RewardForItemBase.ItemMatcher itemMatcher : this.matchers) {
            if (!itemMatcher.allowedItemTypes.contains(is.getItem().getUnlocalizedName())) continue;
            if (itemMatcher.matchSpec.getColour() != null && itemMatcher.matchSpec.getColour().size() > 0) {
                return true;
            }
            if (itemMatcher.matchSpec.getVariant() == null || itemMatcher.matchSpec.getVariant().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private int getSmeltedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            return this.smeltedItems.get(is.getUnlocalizedName()) == null ? 0 : this.smeltedItems.get(is.getUnlocalizedName());
        }
        return this.smeltedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.smeltedItems.get(is.getItem().getUnlocalizedName());
    }

    private void addSmeltedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            int prev = this.smeltedItems.get(is.getUnlocalizedName()) == null ? 0 : this.smeltedItems.get(is.getUnlocalizedName());
            this.smeltedItems.put(is.getUnlocalizedName(), prev + is.getCount());
        } else {
            int prev = this.smeltedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.smeltedItems.get(is.getItem().getUnlocalizedName());
            this.smeltedItems.put(is.getItem().getUnlocalizedName(), prev + is.getCount());
        }
    }

    private void checkForMatch(ItemStack is) {
        int savedSmelted = this.getSmeltedItemCount(is);
        for (ItemQuitMatcher matcher : this.matchers) {
            if (!matcher.matches(is)) continue;
            if (savedSmelted != 0) {
                if (is.getCount() + savedSmelted < matcher.matchSpec.getAmount()) continue;
                this.quitCode = matcher.description();
                this.wantToQuit = true;
                continue;
            }
            if (is.getCount() < matcher.matchSpec.getAmount()) continue;
            this.quitCode = matcher.description();
            this.wantToQuit = true;
        }
        this.addSmeltedItemCount(is);
    }

    public static class ItemQuitMatcher
    extends RewardForItemBase.ItemMatcher {
        String description;

        ItemQuitMatcher(BlockOrItemSpecWithDescription spec) {
            super(spec);
            this.description = spec.getDescription();
        }

        String description() {
            return this.description;
        }
    }
}

