/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.DiscreteMovementCommandsImplementation;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.AgentQuitFromTouchingBlockType;
import com.microsoft.Malmo.Schemas.BlockSpec;
import com.microsoft.Malmo.Schemas.BlockSpecWithDescription;
import com.microsoft.Malmo.Schemas.BlockType;
import com.microsoft.Malmo.Schemas.Colour;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.Variation;
import com.microsoft.Malmo.Utils.PositionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AgentQuitFromTouchingBlockTypeImplementation
extends HandlerBase
implements IWantToQuit {
    AgentQuitFromTouchingBlockType params;
    List<String> blockTypeNames;
    String quitCode = "";
    boolean wantToQuit = false;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof AgentQuitFromTouchingBlockType)) {
            return false;
        }
        this.params = (AgentQuitFromTouchingBlockType)params;
        this.blockTypeNames = new ArrayList<String>();
        for (BlockSpec blockSpec : this.params.getBlock()) {
            for (BlockType bt : blockSpec.getType()) {
                Block b = Block.getBlockFromName((String)bt.value());
                this.blockTypeNames.add(b.getUnlocalizedName().toLowerCase());
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onDiscretePartialMoveEvent(DiscreteMovementCommandsImplementation.DiscretePartialMoveEvent event) {
        this.wantToQuit = this.doIWantToQuit(null);
    }

    @Override
    public boolean doIWantToQuit(MissionInit missionInit) {
        if (this.wantToQuit) {
            return true;
        }
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        List<BlockPos> touchingBlocks = PositionHelper.getTouchingBlocks(player);
        for (BlockPos pos : touchingBlocks) {
            IBlockState bs = player.world.getBlockState(pos);
            String blockname = bs.getBlock().getUnlocalizedName().toLowerCase();
            if (!this.blockTypeNames.contains(blockname)) continue;
            for (BlockSpecWithDescription blockspec : this.params.getBlock()) {
                if (!this.findMatch(blockspec, bs)) continue;
                this.quitCode = blockspec.getDescription();
                return true;
            }
        }
        return false;
    }

    private boolean findNameMatch(BlockSpec blockspec, String blockName) {
        for (BlockType bt : blockspec.getType()) {
            Block b = Block.getBlockFromName((String)bt.value());
            if (!b.getUnlocalizedName().equalsIgnoreCase(blockName)) continue;
            return true;
        }
        return false;
    }

    private boolean findColourMatch(BlockSpec blockspec, String blockColour) {
        if (blockspec.getColour() == null || blockspec.getColour().isEmpty()) {
            return true;
        }
        for (Colour c : blockspec.getColour()) {
            if (!c.value().equalsIgnoreCase(blockColour)) continue;
            return true;
        }
        return false;
    }

    private boolean findVariantMatch(BlockSpec blockspec, String blockVariant) {
        if (blockspec.getVariant() == null || blockspec.getVariant().isEmpty()) {
            return true;
        }
        for (Variation v : blockspec.getVariant()) {
            if (!v.getValue().equalsIgnoreCase(blockVariant)) continue;
            return true;
        }
        return false;
    }

    private boolean findMatch(BlockSpec blockspec, IBlockState blockstate) {
        String blockname = blockstate.getBlock().getUnlocalizedName().toLowerCase();
        if (!this.findNameMatch(blockspec, blockname)) {
            return false;
        }
        EnumDyeColor blockColour = null;
        for (IProperty prop : blockstate.getProperties().keySet()) {
            if (!prop.getName().equals("color") || prop.getValueClass() != EnumDyeColor.class) continue;
            blockColour = (EnumDyeColor)blockstate.getValue(prop);
        }
        if (blockColour != null && !this.findColourMatch(blockspec, blockColour.getName())) {
            return false;
        }
        Object blockVariant = null;
        for (IProperty prop : blockstate.getProperties().keySet()) {
            if (!prop.getName().equals("variant") || !prop.getValueClass().isEnum()) continue;
            blockVariant = blockstate.getValue(prop);
        }
        return blockVariant == null || this.findVariantMatch(blockspec, blockVariant.toString());
    }

    @Override
    public void prepare(MissionInit missionInit) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void cleanup() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public String getOutcome() {
        return this.quitCode;
    }
}

