/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldGenerator;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.BiomeGenerator;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.MapFileHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BiomeGeneratorImplementation
extends HandlerBase
implements IWorldGenerator {
    BiomeGenerator bparams;

    public BiomeGeneratorImplementation() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBiomeGenInit(WorldTypeEvent.InitBiomeGens event) {
        GenLayer[] replacement;
        if (this.bparams.getBiome() == -1) {
            return;
        }
        replacement = new GenLayer[]{new GenLayerConstant(this.bparams.getBiome()), replacement[0]};
        event.setNewBiomeGens(replacement);
    }

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof BiomeGenerator)) {
            return false;
        }
        this.bparams = (BiomeGenerator)params;
        return true;
    }

    public static long getWorldSeedFromString() {
        long seed = new Random().nextLong();
        return seed;
    }

    @Override
    public boolean createWorld(MissionInit missionInit) {
        long seed = BiomeGeneratorImplementation.getWorldSeedFromString();
        WorldType.WORLD_TYPES[0].onGUICreateWorldPress();
        WorldSettings worldsettings = new WorldSettings(seed, GameType.SURVIVAL, true, false, WorldType.WORLD_TYPES[0]);
        worldsettings.enableCommands();
        return MapFileHelper.createAndLaunchWorld(worldsettings, this.bparams.isDestroyAfterUse());
    }

    @Override
    public boolean shouldCreateWorld(MissionInit missionInit, World world) {
        if (this.bparams != null && this.bparams.isForceReset()) {
            return true;
        }
        if (Minecraft.getMinecraft().world == null || world == null) {
            return true;
        }
        String genOptions = world.getWorldInfo().getGeneratorOptions();
        return genOptions != null && !genOptions.isEmpty();
    }

    @Override
    public String getErrorDetails() {
        return "";
    }

    private class GenLayerConstant
    extends GenLayer {
        private final int value;

        public GenLayerConstant(int value) {
            super(0L);
            this.value = value;
        }

        public int[] getInts(int par1, int par2, int par3, int par4) {
            int[] aint2 = IntCache.getIntCache((int)(par3 * par4));
            for (int i = 0; i < aint2.length; ++i) {
                aint2[i] = this.value;
            }
            return aint2;
        }
    }
}

