/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldDecorator;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.BuildBattleDecorator;
import com.microsoft.Malmo.Schemas.DrawBlockBasedObjectType;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.UnnamedGridDefinition;
import com.microsoft.Malmo.Utils.BlockDrawingHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BuildBattleDecoratorImplementation
extends HandlerBase
implements IWorldDecorator {
    private UnnamedGridDefinition sourceBounds;
    private UnnamedGridDefinition destBounds;
    private BuildBattleDecorator params;
    private Vec3i delta;
    private int structureVolume;
    private BlockDrawingHelper.XMLBlockState blockTypeOnCorrectPlacement;
    private BlockDrawingHelper.XMLBlockState blockTypeOnIncorrectPlacement;
    private boolean structureHasBeenCompleted = false;
    private List<IBlockState> source;
    private List<IBlockState> dest;
    private int currentScore = 0;
    private boolean valid = true;
    private boolean initialised = false;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof BuildBattleDecorator)) {
            return false;
        }
        this.params = (BuildBattleDecorator)params;
        this.sourceBounds = this.params.getGoalStructureBounds();
        this.destBounds = this.params.getPlayerStructureBounds();
        this.delta = new Vec3i(this.destBounds.getMin().getX() - this.sourceBounds.getMin().getX(), this.destBounds.getMin().getY() - this.sourceBounds.getMin().getY(), this.destBounds.getMin().getZ() - this.sourceBounds.getMin().getZ());
        this.structureVolume = this.volumeOfBounds(this.sourceBounds);
        assert (this.structureVolume == this.volumeOfBounds(this.destBounds));
        this.dest = new ArrayList<IBlockState>(Collections.nCopies(this.structureVolume, null));
        this.source = new ArrayList<IBlockState>(Collections.nCopies(this.structureVolume, null));
        DrawBlockBasedObjectType tickBlock = this.params.getBlockTypeOnCorrectPlacement();
        DrawBlockBasedObjectType crossBlock = this.params.getBlockTypeOnIncorrectPlacement();
        this.blockTypeOnCorrectPlacement = tickBlock != null ? new BlockDrawingHelper.XMLBlockState(tickBlock.getType(), tickBlock.getColour(), tickBlock.getFace(), tickBlock.getVariant()) : null;
        this.blockTypeOnIncorrectPlacement = crossBlock != null ? new BlockDrawingHelper.XMLBlockState(crossBlock.getType(), crossBlock.getColour(), crossBlock.getFace(), crossBlock.getVariant()) : null;
        return true;
    }

    @Override
    public void buildOnWorld(MissionInit missionInit, World world) throws IWorldDecorator.DecoratorException {
    }

    @Override
    public boolean getExtraAgentHandlersAndData(List<Object> handlers, Map<String, String> data) {
        return false;
    }

    @Override
    public void update(World world) {
        if (!this.initialised) {
            this.initialised = true;
            this.updateAndScorePlayerVolume(world, false);
        } else if (!this.valid) {
            this.updateAndScorePlayerVolume(world, true);
        }
    }

    private boolean blockInBounds(BlockPos pos, UnnamedGridDefinition bounds) {
        return pos.getX() >= bounds.getMin().getX() && pos.getX() <= bounds.getMax().getX() && pos.getZ() >= bounds.getMin().getZ() && pos.getZ() <= bounds.getMax().getZ() && pos.getY() >= bounds.getMin().getY() && pos.getY() <= bounds.getMax().getY();
    }

    private int volumeOfBounds(UnnamedGridDefinition bounds) {
        return (1 + bounds.getMax().getX() - bounds.getMin().getX()) * (1 + bounds.getMax().getY() - bounds.getMin().getY()) * (1 + bounds.getMax().getZ() - bounds.getMin().getZ());
    }

    private int blockPosToIndex(BlockPos pos, UnnamedGridDefinition gd) {
        int depth = 1 + gd.getMax().getZ() - gd.getMin().getZ();
        int width = 1 + gd.getMax().getX() - gd.getMin().getX();
        int ind = pos.getX() - gd.getMin().getX() + (pos.getZ() - gd.getMin().getZ()) * width + (pos.getY() - gd.getMin().getY()) * width * depth;
        return ind;
    }

    private IBlockState getSourceBlockState(World w, BlockPos pos) {
        int ind = this.blockPosToIndex(pos, this.sourceBounds);
        if (ind < 0 || ind >= this.structureVolume) {
            return null;
        }
        IBlockState state = this.source.get(ind);
        if (state == null) {
            state = w.getBlockState(pos);
            this.source.set(ind, state);
        }
        return state;
    }

    private IBlockState getDestBlockState(World w, BlockPos pos) {
        int ind = this.blockPosToIndex(pos, this.destBounds);
        if (ind < 0 || ind >= this.structureVolume) {
            return null;
        }
        IBlockState state = this.dest.get(ind);
        if (state == null) {
            state = w.getBlockState(pos);
            this.dest.set(ind, state);
        }
        return state;
    }

    private void updateAndScorePlayerVolume(World w, boolean updateReward) {
        int wrongBlocks = 0;
        int rightBlocks = 0;
        int totalMatchingBlocks = 0;
        BlockDrawingHelper drawContext = new BlockDrawingHelper();
        drawContext.beginDrawing(w);
        for (int x = this.sourceBounds.getMin().getX(); x <= this.sourceBounds.getMax().getX(); ++x) {
            for (int y = this.sourceBounds.getMin().getY(); y <= this.sourceBounds.getMax().getY(); ++y) {
                for (int z = this.sourceBounds.getMin().getZ(); z <= this.sourceBounds.getMax().getZ(); ++z) {
                    IBlockState actualState;
                    BlockPos goalStructurePos = new BlockPos(x, y, z);
                    BlockPos playerStructurePos = goalStructurePos.add(this.delta);
                    IBlockState srcState = this.getSourceBlockState(w, goalStructurePos);
                    IBlockState dstState = this.getDestBlockState(w, playerStructurePos);
                    if (srcState == null || dstState == null) continue;
                    boolean destAir = w.isAirBlock(playerStructurePos);
                    if (srcState.equals(dstState)) {
                        if (!destAir) {
                            ++rightBlocks;
                        }
                        if (this.blockTypeOnCorrectPlacement != null && !w.isAirBlock(goalStructurePos)) {
                            drawContext.setBlockState(w, playerStructurePos, this.blockTypeOnCorrectPlacement);
                            drawContext.setBlockState(w, goalStructurePos, this.blockTypeOnCorrectPlacement);
                        }
                        ++totalMatchingBlocks;
                        continue;
                    }
                    if (!destAir) {
                        ++wrongBlocks;
                        if (this.blockTypeOnIncorrectPlacement != null) {
                            drawContext.setBlockState(w, playerStructurePos, this.blockTypeOnIncorrectPlacement);
                        }
                    }
                    if ((actualState = w.getBlockState(goalStructurePos)).equals(srcState)) continue;
                    drawContext.setBlockState(w, goalStructurePos, new BlockDrawingHelper.XMLBlockState(srcState));
                }
            }
        }
        drawContext.endDrawing(w);
        int score = rightBlocks - wrongBlocks;
        boolean sendData = false;
        boolean sendCompletionBonus = false;
        int reward = 0;
        if (updateReward && score != this.currentScore) {
            reward = score - this.currentScore;
            sendData = true;
        }
        this.currentScore = score;
        if (totalMatchingBlocks == this.structureVolume) {
            if (!this.structureHasBeenCompleted && updateReward) {
                sendCompletionBonus = true;
            }
            this.structureHasBeenCompleted = true;
        }
        this.valid = true;
        if (sendData) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("reward", Integer.toString(reward));
            data.put("completed", Boolean.toString(sendCompletionBonus));
            MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_BUILDBATTLEREWARD, data);
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (this.blockInBounds(event.getPos(), this.destBounds)) {
            this.valid = false;
            this.dest.set(this.blockPosToIndex(event.getPos(), this.destBounds), Blocks.AIR.getDefaultState());
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.PlaceEvent event) {
        if (this.blockInBounds(event.getPos(), this.destBounds)) {
            this.valid = false;
            this.dest.set(this.blockPosToIndex(event.getPos(), this.destBounds), event.getState());
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            if (this.blockInBounds(event.getPos(), this.sourceBounds)) {
                event.setCanceled(true);
            }
        } else if (event instanceof PlayerInteractEvent.RightClickBlock) {
            IBlockState iblockstate = event.getWorld().getBlockState(event.getPos());
            Block block = iblockstate.getBlock();
            EnumFacing side = event.getFace();
            BlockPos pos = event.getPos();
            if (block == Blocks.SNOW_LAYER && (Integer)iblockstate.getValue((IProperty)BlockSnow.LAYERS) < 1) {
                side = EnumFacing.UP;
            } else if (!block.isReplaceable((IBlockAccess)event.getWorld(), pos)) {
                pos = pos.offset(side);
            }
            if (this.blockInBounds(pos, this.sourceBounds)) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void cleanup() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public boolean targetedUpdate(String nextAgentName) {
        return false;
    }

    @Override
    public void getTurnParticipants(ArrayList<String> participants, ArrayList<Integer> participantSlots) {
    }
}

