/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.TimeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CameraCommandsImplementation
extends CommandBase {
    float currentYaw = -10000.0f;
    float currentPitch = -10000.0f;
    boolean overriding = false;

    @Override
    public void install(MissionInit missionInit) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void deinstall(MissionInit missionInit) {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public boolean isOverriding() {
        return this.overriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.overriding = b;
    }

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (!verb.equals("camera")) {
            return false;
        }
        try {
            String[] camParams = parameter.split(" ");
            float pitch = Float.parseFloat(camParams[0]);
            float yaw = Float.parseFloat(camParams[1]);
            EntityPlayerSP player = Minecraft.getMinecraft().player;
            if (player != null) {
                this.currentYaw = player.rotationYaw;
                this.currentPitch = player.rotationPitch;
                player.setPositionAndRotation(player.posX, player.posY, player.posZ, this.currentYaw + yaw, this.currentPitch + pitch);
                this.currentYaw = player.rotationYaw;
                this.currentPitch = player.rotationPitch;
            }
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR: Malformed parameter string (" + parameter + ") - " + e.getMessage());
            return false;
        }
        if (parameter.equals("1")) {
            TimeHelper.pause();
        } else if (parameter.equals("0")) {
            TimeHelper.unpause();
        }
        return true;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        EntityPlayerSP player;
        if (ev.phase == TickEvent.Phase.START && this.isOverriding() && this.isOverriding() && (player = Minecraft.getMinecraft().player) != null) {
            if (this.currentYaw == -10000.0f & this.currentPitch == -10000.0f) {
                this.currentYaw = player.rotationYaw;
                this.currentPitch = player.rotationPitch;
            }
            player.setPositionAndRotation(player.posX, player.posY, player.posZ, this.currentYaw, this.currentPitch);
        }
    }
}

