/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IVideoProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.ColourMapProducer;
import com.microsoft.Malmo.Schemas.EntityTypes;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.MobWithColour;
import com.microsoft.Malmo.Utils.TextureHelper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ColourMapProducerImplementation
extends HandlerBase
implements IVideoProducer {
    private ColourMapProducer cmParams;
    private Framebuffer fbo;
    private Map<String, Integer> mobColours = new HashMap<String, Integer>();
    private Map<String, Integer> miscColours = new HashMap<String, Integer>();

    @Override
    public boolean parseParameters(Object params) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (params == null || !(params instanceof ColourMapProducer)) {
            return false;
        }
        this.cmParams = (ColourMapProducer)params;
        for (MobWithColour mob : this.cmParams.getColourSpec()) {
            byte[] col = mob.getColour();
            int c = (col[2] & 0xFF) + ((col[1] & 0xFF) << 8) + ((col[0] & 0xFF) << 16);
            for (EntityTypes ent : mob.getType()) {
                String mobName = ent.value();
                this.mobColours.put(mobName, c);
            }
        }
        this.miscColours.put("textures/environment/sun.png", 0xFFFF00);
        this.miscColours.put("textures/environment/moon_phases.png", 0xFFFFFF);
        return true;
    }

    @Override
    public IVideoProducer.VideoType getVideoType() {
        return IVideoProducer.VideoType.COLOUR_MAP;
    }

    @Override
    public int getWidth() {
        return this.cmParams.getWidth();
    }

    @Override
    public int getHeight() {
        return this.cmParams.getHeight();
    }

    @Override
    public int getRequiredBufferSize() {
        return this.getWidth() * this.getHeight() * 3;
    }

    @Override
    public void getFrame(MissionInit missionInit, ByteBuffer buffer) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.fbo.bindFramebuffer(true);
        Minecraft.getMinecraft().getFramebuffer().framebufferRenderExt(width, height, true);
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6407, (int)5121, (ByteBuffer)buffer);
        this.fbo.unbindFramebuffer();
    }

    @Override
    public void prepare(MissionInit missionInit) {
        this.fbo = new Framebuffer(this.getWidth(), this.getHeight(), true);
        TextureHelper.setIsProducingColourMap(true);
        TextureHelper.setMobColours(this.mobColours);
        TextureHelper.setMiscTextureColours(this.miscColours);
        TextureHelper.setSkyRenderer(new TextureHelper.BlankSkyRenderer(this.cmParams.getSkyColour()));
    }

    @Override
    public void cleanup() {
        TextureHelper.setIsProducingColourMap(false);
        this.fbo.deleteFramebuffer();
    }
}

