/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.Schemas.ContinuousMovementCommand;
import com.microsoft.Malmo.Schemas.ContinuousMovementCommands;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.TimeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CommandForWheeledRobotNavigationImplementation
extends CommandBase {
    private boolean overrideKeyboardInput = false;
    private float mVelocity = 0.0f;
    private float mTargetVelocity = 0.0f;
    private int mInertiaTicks = 6;
    private int mTicksSinceLastVelocityChange = 0;
    private float mCameraPitch = 0.0f;
    private float pitchScale = 0.0f;
    private float mYaw = 0.0f;
    private float yawScale = 0.0f;
    private float maxAngularVelocityDegreesPerSecond = 180.0f;
    private long lastAngularUpdateTime;
    private MovementInput overrideMovement = null;
    private MovementInput originalMovement = null;
    public static final String ON_COMMAND_STRING = "1";
    public static final String OFF_COMMAND_STRING = "0";

    public CommandForWheeledRobotNavigationImplementation() {
        this.init();
    }

    private void init() {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        this.mVelocity = 0.0f;
        this.mTargetVelocity = 0.0f;
        this.mTicksSinceLastVelocityChange = 0;
        this.mCameraPitch = player != null ? player.rotationPitch : 0.0f;
        this.pitchScale = 0.0f;
        this.mYaw = player != null ? player.rotationYaw : 0.0f;
        this.yawScale = 0.0f;
    }

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof ContinuousMovementCommands)) {
            return false;
        }
        ContinuousMovementCommands cmparams = (ContinuousMovementCommands)params;
        this.maxAngularVelocityDegreesPerSecond = cmparams.getTurnSpeedDegs().floatValue();
        this.setUpAllowAndDenyLists(cmparams.getModifierList());
        return true;
    }

    public void setInertiaTicks(int ticks) {
        this.mInertiaTicks = ticks;
    }

    public int getInertiaTicks() {
        return this.mInertiaTicks;
    }

    protected boolean updateState() {
        ++this.mTicksSinceLastVelocityChange;
        this.mVelocity = this.mTicksSinceLastVelocityChange <= this.mInertiaTicks ? (this.mVelocity += (this.mTargetVelocity - this.mVelocity) * ((float)this.mTicksSinceLastVelocityChange / (float)this.mInertiaTicks)) : this.mTargetVelocity;
        this.overrideMovement.moveForward = this.mVelocity;
        if (this.overrideMovement.sneak) {
            this.overrideMovement.moveStrafe = (float)((double)this.overrideMovement.moveStrafe * 0.3);
            this.overrideMovement.moveForward = (float)((double)this.overrideMovement.moveForward * 0.3);
        }
        this.updateYawAndPitch();
        return true;
    }

    public void updateYawAndPitch() {
        long timeNow = System.currentTimeMillis();
        long deltaTime = 0L;
        double overclockScale = 1.0;
        if (TimeHelper.SyncManager.isSynchronous().booleanValue()) {
            deltaTime = Minecraft.getMinecraft().isGamePaused ? 0L : 50L;
        } else {
            deltaTime = timeNow - this.lastAngularUpdateTime;
            overclockScale = 50.0 / (double)TimeHelper.serverTickLength;
        }
        this.lastAngularUpdateTime = timeNow;
        double deltaYaw = (double)this.yawScale * overclockScale * (double)this.maxAngularVelocityDegreesPerSecond * ((double)deltaTime / 1000.0);
        double deltaPitch = (double)this.pitchScale * overclockScale * (double)this.maxAngularVelocityDegreesPerSecond * ((double)deltaTime / 1000.0);
        this.mYaw = (float)((double)this.mYaw + deltaYaw);
        this.mCameraPitch = (float)((double)this.mCameraPitch + deltaPitch);
        this.mCameraPitch = this.mCameraPitch < -90.0f ? -90.0f : (this.mCameraPitch > 90.0f ? 90.0f : this.mCameraPitch);
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player != null) {
            player.rotationPitch = this.mCameraPitch;
            player.rotationYaw = this.mYaw;
        }
    }

    @Override
    public boolean isOverriding() {
        return this.overrideKeyboardInput;
    }

    @Override
    public void setOverriding(boolean b) {
        this.init();
        this.overrideKeyboardInput = b;
    }

    @Override
    public boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (verb == null || verb.length() == 0) {
            return false;
        }
        if (verb.equalsIgnoreCase(ContinuousMovementCommand.MOVE.value())) {
            float targetVelocity = this.clamp(Float.valueOf(parameter).floatValue());
            if (targetVelocity != this.mTargetVelocity) {
                this.mTargetVelocity = targetVelocity;
                this.mTicksSinceLastVelocityChange = 0;
            }
            return true;
        }
        if (verb.equalsIgnoreCase(ContinuousMovementCommand.STRAFE.value())) {
            this.overrideMovement.moveStrafe = -this.clamp(Float.valueOf(parameter).floatValue());
            return true;
        }
        if (verb.equalsIgnoreCase(ContinuousMovementCommand.PITCH.value())) {
            this.pitchScale = this.clamp(Float.valueOf(parameter).floatValue());
            this.lastAngularUpdateTime = System.currentTimeMillis();
            return true;
        }
        if (verb.equalsIgnoreCase(ContinuousMovementCommand.TURN.value())) {
            this.yawScale = this.clamp(Float.valueOf(parameter).floatValue());
            this.lastAngularUpdateTime = System.currentTimeMillis();
            return true;
        }
        boolean value = parameter.equalsIgnoreCase(ON_COMMAND_STRING);
        if (verb.equals(ContinuousMovementCommand.JUMP.value())) {
            this.overrideMovement.jump = value;
            return true;
        }
        if (verb.equalsIgnoreCase(ContinuousMovementCommand.CROUCH.value())) {
            this.overrideMovement.sneak = value;
            return true;
        }
        return false;
    }

    private float clamp(float f) {
        return f < -1.0f ? -1.0f : (f > 1.0f ? 1.0f : f);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START && this.isOverriding()) {
            this.updateYawAndPitch();
        }
    }

    @SubscribeEvent
    public void onSetPitchOrYaw(ResetPitchAndYawEvent event) {
        if (event.setYaw) {
            this.mYaw = event.yaw;
        }
        if (event.setPitch) {
            this.mCameraPitch = event.pitch;
        }
    }

    @Override
    public void install(MissionInit missionInit) {
        this.overrideMovement = new MovementHook(Minecraft.getMinecraft().gameSettings);
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player != null) {
            this.originalMovement = player.movementInput;
            player.movementInput = this.overrideMovement;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void deinstall(MissionInit missionInit) {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player != null) {
            player.movementInput = this.originalMovement;
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public MovementInput getMover() {
        return this.overrideMovement;
    }

    public float getCameraYaw() {
        return this.mYaw;
    }

    public float getCameraPitch() {
        return this.mCameraPitch;
    }

    public static class ResetPitchAndYawEvent
    extends Event {
        public final float pitch;
        public final float yaw;
        public final boolean setPitch;
        public final boolean setYaw;

        public ResetPitchAndYawEvent(boolean setYaw, float yaw, boolean setPitch, float pitch) {
            this.setYaw = setYaw;
            this.yaw = yaw;
            this.setPitch = setPitch;
            this.pitch = pitch;
        }
    }

    private class MovementHook
    extends MovementInputFromOptions {
        public MovementHook(GameSettings gameSettingsIn) {
            super(gameSettingsIn);
        }

        public void updatePlayerMoveState() {
            if (!CommandForWheeledRobotNavigationImplementation.this.updateState()) {
                super.updatePlayerMoveState();
            }
        }
    }
}

