/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IVideoProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.DepthProducer;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class DepthProducerImplementation
extends HandlerBase
implements IVideoProducer {
    private DepthProducer videoParams;
    private Framebuffer fbo;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof DepthProducer)) {
            return false;
        }
        this.videoParams = (DepthProducer)params;
        return true;
    }

    @Override
    public IVideoProducer.VideoType getVideoType() {
        return IVideoProducer.VideoType.DEPTH_MAP;
    }

    @Override
    public void getFrame(MissionInit missionInit, ByteBuffer buffer) {
        int width = this.videoParams.getWidth();
        int height = this.videoParams.getHeight();
        GL30.glBindFramebuffer((int)36008, (int)Minecraft.getMinecraft().getFramebuffer().framebufferObject);
        GL30.glBindFramebuffer((int)36009, (int)this.fbo.framebufferObject);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)Minecraft.getMinecraft().getFramebuffer().framebufferWidth, (int)Minecraft.getMinecraft().getFramebuffer().framebufferHeight, (int)0, (int)0, (int)width, (int)height, (int)16640, (int)9728);
        this.fbo.bindFramebuffer(true);
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6402, (int)5126, (FloatBuffer)buffer.asFloatBuffer());
        FloatBuffer fluffer = buffer.asFloatBuffer();
        float zNear = 0.05f;
        float zFar = (float)(Minecraft.getMinecraft().gameSettings.renderDistanceChunks * 16) * MathHelper.SQRT_2;
        float minval = 1.0f;
        float maxval = 0.0f;
        for (int i = 0; i < width * height; ++i) {
            float f = fluffer.get(i);
            if (f < minval) {
                minval = f;
            }
            if (f > maxval) {
                maxval = f;
            }
            f = 2.0f * f - 1.0f;
            float zLinear = 2.0f * zNear * zFar / (zFar + zNear - f * (zFar - zNear));
            fluffer.put(i, zLinear);
        }
        this.fbo.unbindFramebuffer();
    }

    @Override
    public int getWidth() {
        return this.videoParams.getWidth();
    }

    @Override
    public int getHeight() {
        return this.videoParams.getHeight();
    }

    @Override
    public int getRequiredBufferSize() {
        return this.videoParams.getWidth() * this.videoParams.getHeight() * 4;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        this.fbo = new Framebuffer(this.videoParams.getWidth(), this.videoParams.getHeight(), true);
    }

    @Override
    public void cleanup() {
        this.fbo.deleteFramebuffer();
    }
}

