/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldGenerator;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.FileWorldGenerator;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.MapFileHelper;
import java.io.File;
import java.util.List;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.client.FMLClientHandler;

public class FileWorldGeneratorImplementation
extends HandlerBase
implements IWorldGenerator {
    String mapFilename;
    FileWorldGenerator fwparams;
    String errorDetails;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof FileWorldGenerator)) {
            return false;
        }
        this.fwparams = (FileWorldGenerator)params;
        this.mapFilename = this.fwparams.getSrc();
        return true;
    }

    @Override
    public boolean createWorld(MissionInit missionInit) {
        String worldName;
        List worldlist;
        if (this.mapFilename == null || this.mapFilename.length() == 0) {
            this.errorDetails = "No basemap URI provided - check your Mission XML.";
            return false;
        }
        File mapSource = new File(this.mapFilename);
        if (!mapSource.exists()) {
            this.errorDetails = "Basemap file " + this.mapFilename + " was not found - check your Mission XML and ensure the file exists on the Minecraft client machine.";
            return false;
        }
        if (!mapSource.isDirectory()) {
            this.errorDetails = "Basemap location " + this.mapFilename + " needs to be a folder. Check the path in your Mission XML.";
            return false;
        }
        File mapCopy = MapFileHelper.copyMapFiles(mapSource, this.fwparams.isDestroyAfterUse());
        if (mapCopy == null) {
            this.errorDetails = "Unable to copy " + this.mapFilename + " - is the hard drive full?";
            return false;
        }
        if (!Minecraft.getMinecraft().getSaveLoader().canLoadWorld(mapCopy.getName())) {
            this.errorDetails = "Minecraft is unable to load " + this.mapFilename + " - is it a valid saved world?";
            return false;
        }
        ISaveFormat isaveformat = Minecraft.getMinecraft().getSaveLoader();
        try {
            worldlist = isaveformat.getSaveList();
        }
        catch (AnvilConverterException anvilconverterexception) {
            this.errorDetails = "Minecraft couldn't rebuild saved world list.";
            return false;
        }
        WorldSummary newWorld = null;
        for (WorldSummary ws : worldlist) {
            if (!ws.getFileName().equals(mapCopy.getName())) continue;
            newWorld = ws;
        }
        if (newWorld == null) {
            this.errorDetails = "Minecraft could not find the copied world.";
            return false;
        }
        FMLClientHandler.instance().tryLoadExistingWorld(null, newWorld);
        IntegratedServer server = Minecraft.getMinecraft().getIntegratedServer();
        String string = worldName = server != null ? server.getWorldName() : null;
        if (worldName == null || !worldName.equals(newWorld.getDisplayName())) {
            this.errorDetails = "Minecraft could not load " + this.mapFilename + " - is it a valid saved world?";
            return false;
        }
        MapFileHelper.cleanupTemporaryWorlds(mapCopy.getName());
        return true;
    }

    @Override
    public boolean shouldCreateWorld(MissionInit missionInit, World world) {
        if (this.fwparams != null && this.fwparams.isForceReset()) {
            return true;
        }
        if (world == null) {
            return true;
        }
        String name = world != null ? world.getWorldInfo().getWorldName() : "";
        String mapfile = this.mapFilename == null ? "" : this.mapFilename;
        String[] parts = mapfile.split("[\\\\/]");
        return name.length() <= 0 || !parts[parts.length - 1].equalsIgnoreCase(name) || Minecraft.getMinecraft().world == null;
    }

    @Override
    public String getErrorDetails() {
        return this.errorDetails;
    }
}

